/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.tools.schemaframework.DatabaseObjectDefinition;
import oracle.toplink.essentials.tools.schemaframework.FieldDefinition;
import oracle.toplink.essentials.tools.schemaframework.ForeignKeyConstraint;
import oracle.toplink.essentials.tools.schemaframework.UniqueKeyConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDefinition
extends DatabaseObjectDefinition {
    protected Vector fields = new Vector();
    protected HashMap<String, ForeignKeyConstraint> foreignKeyMap = new HashMap();
    protected Vector<UniqueKeyConstraint> uniqueKeys = new Vector();
    protected String creationPrefix = "CREATE TABLE ";
    protected String creationSuffix = "";
    private boolean createSQLFiles;

    public void addField(String fieldName, Class type) {
        this.addField(new FieldDefinition(fieldName, type));
    }

    public void addField(String fieldName, Class type, int fieldSize) {
        this.addField(new FieldDefinition(fieldName, type, fieldSize));
    }

    public void addField(String fieldName, Class type, int fieldSize, int fieldSubSize) {
        this.addField(new FieldDefinition(fieldName, type, fieldSize, fieldSubSize));
    }

    public void addField(String fieldName, String typeName) {
        this.addField(new FieldDefinition(fieldName, typeName));
    }

    public void addField(FieldDefinition field) {
        this.getFields().addElement(field);
    }

    public void addForeignKeyConstraint(String name, String sourceField, String targetField, String targetTable) {
        ForeignKeyConstraint foreignKey = new ForeignKeyConstraint(name, sourceField, targetField, targetTable);
        this.addForeignKeyConstraint(foreignKey);
    }

    public void addUniqueKeyConstraint(String name, String sourceField) {
        UniqueKeyConstraint uniqueKey = new UniqueKeyConstraint(name, sourceField);
        this.addUniqueKeyConstraint(uniqueKey);
    }

    public void addUniqueKeyConstraint(String name, String[] sourceFields) {
        UniqueKeyConstraint uniqueKey = new UniqueKeyConstraint(name, sourceFields);
        this.addUniqueKeyConstraint(uniqueKey);
    }

    public void addForeignKeyConstraint(ForeignKeyConstraint foreignKey) {
        if (!this.foreignKeyMap.containsKey(foreignKey.getName())) {
            this.foreignKeyMap.put(foreignKey.getName(), foreignKey);
        }
    }

    public void addUniqueKeyConstraint(UniqueKeyConstraint uniqueKey) {
        this.getUniqueKeys().addElement(uniqueKey);
    }

    public void addIdentityField(String fieldName, Class type) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type);
        fieldDef.setIsIdentity(true);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addIdentityField(String fieldName, Class type, int fieldSize) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type, fieldSize);
        fieldDef.setIsIdentity(true);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addPrimaryKeyField(String fieldName, Class type) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addPrimaryKeyField(String fieldName, Class type, int fieldSize) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type, fieldSize);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public Writer buildConstraintCreationWriter(AbstractSession session, ForeignKeyConstraint foreignKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(foreignKey.getName() + " ");
            }
            foreignKey.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + foreignKey.getName());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildConstraintDeletionWriter(AbstractSession session, ForeignKeyConstraint foreignKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + foreignKey.getName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintCreationWriter(AbstractSession session, UniqueKeyConstraint uniqueKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(uniqueKey.getName() + " ");
            }
            uniqueKey.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + uniqueKey.getName());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintDeletionWriter(AbstractSession session, UniqueKeyConstraint uniqueKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + uniqueKey.getName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public String getCreationPrefix() {
        return this.creationPrefix;
    }

    public void setCreationPrefix(String creationPrefix) {
        this.creationPrefix = creationPrefix;
    }

    public String getCreationSuffix() {
        return this.creationSuffix;
    }

    public void setCreationSuffix(String creationSuffix) {
        this.creationSuffix = creationSuffix;
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write(this.getCreationPrefix() + this.getFullName() + " (");
            Enumeration fieldsEnum = this.getFields().elements();
            while (fieldsEnum.hasMoreElements()) {
                FieldDefinition field = (FieldDefinition)fieldsEnum.nextElement();
                field.appendDBString(writer, session, this);
                if (!fieldsEnum.hasMoreElements()) continue;
                writer.write(", ");
            }
            Vector keyFields = this.getPrimaryKeyFieldNames();
            if (!keyFields.isEmpty() && session.getPlatform().supportsPrimaryKeyConstraint()) {
                writer.write(", ");
                if (session.getPlatform().requiresNamedPrimaryKeyConstraints()) {
                    writer.write("CONSTRAINT " + this.getFullName() + "_PK ");
                }
                writer.write("PRIMARY KEY (");
                Enumeration keyEnum = keyFields.elements();
                while (keyEnum.hasMoreElements()) {
                    writer.write((String)keyEnum.nextElement());
                    if (!keyEnum.hasMoreElements()) continue;
                    writer.write(", ");
                }
                writer.write(")");
            }
            writer.write(")");
            if (this.getCreationSuffix().length() > 0) {
                writer.write(this.getCreationSuffix());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TABLE " + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    protected void buildFieldTypes(AbstractSession session) {
        this.buildForeignFieldTypes(session);
    }

    private void buildForeignFieldTypes(AbstractSession session) {
        Hashtable fieldTypes = session.getPlatform().getClassTypes();
        FieldDefinition field = null;
        Enumeration enumtr = this.getFields().elements();
        while (enumtr.hasMoreElements()) {
            field = (FieldDefinition)enumtr.nextElement();
            if (field.getForeignKeyFieldName() != null) {
                this.addForeignKeyConstraint(this.buildForeignKeyConstraint(field, session.getPlatform()));
            }
            if (field.getType() != null) continue;
            field.setType((Class)fieldTypes.get(field.getTypeName()));
            if (field.getType() == null) continue;
            field.setTypeName(null);
        }
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(FieldDefinition field, DatabasePlatform platform) {
        Vector<String> sourceFields = new Vector<String>();
        Vector<String> targetFields = new Vector<String>();
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        DatabaseField tempTargetField = new DatabaseField(field.getForeignKeyFieldName());
        DatabaseField tempSourceField = new DatabaseField(field.getName());
        sourceFields.addElement(tempSourceField.getName());
        targetFields.addElement(tempTargetField.getName());
        fkConstraint.setSourceFields(sourceFields);
        fkConstraint.setTargetFields(targetFields);
        fkConstraint.setTargetTable(tempTargetField.getTable().getQualifiedName());
        String tempName = this.buildForeignKeyConstraintName(this.getName(), tempSourceField.getName(), platform.getMaxForeignKeyNameSize());
        fkConstraint.setName(tempName);
        return fkConstraint;
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(Vector fkFieldNames, Vector pkFieldNames, TableDefinition targetTable, DatabasePlatform platform) {
        assert (fkFieldNames.size() > 0 && fkFieldNames.size() == pkFieldNames.size());
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        for (int i = 0; i < fkFieldNames.size(); ++i) {
            fkConstraint.getSourceFields().add((String)fkFieldNames.get(i));
            fkConstraint.getTargetFields().add((String)pkFieldNames.get(i));
        }
        fkConstraint.setTargetTable(targetTable.getFullName());
        String fkFieldName = (String)fkFieldNames.get(0);
        String name = this.buildForeignKeyConstraintName(this.getName(), fkFieldName, platform.getMaxForeignKeyNameSize());
        fkConstraint.setName(name);
        return fkConstraint;
    }

    protected String buildForeignKeyConstraintName(String tableName, String fieldName, int maximumNameLength) {
        String onlyAlphaNumericFieldName;
        String onlyAlphaNumericTableName;
        String foreignKeyName = "FK_" + tableName + "_" + fieldName;
        if (foreignKeyName.length() > maximumNameLength && (foreignKeyName = tableName + "_" + fieldName).length() > maximumNameLength && (foreignKeyName = Helper.removeAllButAlphaNumericToFit(tableName + fieldName, maximumNameLength)).length() > maximumNameLength && (foreignKeyName = Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(tableName, 0), onlyAlphaNumericFieldName = Helper.removeAllButAlphaNumericToFit(fieldName, 0), maximumNameLength)).length() > maximumNameLength) {
            String shortenedFieldName = Helper.removeVowels(onlyAlphaNumericFieldName);
            String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
            foreignKeyName = Helper.truncate(shortenedTableName, maximumNameLength - shortenedFieldName.length()) + shortenedFieldName;
        }
        return foreignKeyName;
    }

    protected UniqueKeyConstraint buildUniqueKeyConstraint(String[] fieldNames, int serialNumber, DatabasePlatform platform) {
        assert (fieldNames.length > 0);
        UniqueKeyConstraint unqConstraint = new UniqueKeyConstraint();
        for (String fieldName : fieldNames) {
            unqConstraint.addSourceField(fieldName);
        }
        String name = this.buildUniqueKeyConstraintName(this.getName(), serialNumber, platform.getMaxUniqueKeyNameSize());
        unqConstraint.setName(name);
        return unqConstraint;
    }

    protected String buildUniqueKeyConstraintName(String tableName, int serialNumber, int maximumNameLength) {
        String onlyAlphaNumericTableName;
        String uniqueKeyName = "UNQ_" + tableName + "_" + serialNumber;
        if (uniqueKeyName.length() > maximumNameLength && (uniqueKeyName = tableName + serialNumber).length() > maximumNameLength && (uniqueKeyName = Helper.removeAllButAlphaNumericToFit(tableName + serialNumber, maximumNameLength)).length() > maximumNameLength && (uniqueKeyName = Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(tableName, 0), "", maximumNameLength)).length() > maximumNameLength) {
            String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
            uniqueKeyName = Helper.truncate(shortenedTableName, maximumNameLength - shortenedTableName.length());
        }
        return uniqueKeyName;
    }

    @Override
    public Object clone() {
        TableDefinition clone = (TableDefinition)super.clone();
        if (this.fields != null) {
            clone.setFields(new Vector(this.fields.size()));
            Enumeration enumtr = this.getFields().elements();
            while (enumtr.hasMoreElements()) {
                FieldDefinition fieldDef = (FieldDefinition)enumtr.nextElement();
                clone.addField((FieldDefinition)fieldDef.clone());
            }
        }
        if (this.foreignKeyMap != null) {
            clone.setForeignKeyMap((HashMap)this.foreignKeyMap.clone());
        }
        if (this.uniqueKeys != null) {
            clone.setUniqueKeys((Vector)this.uniqueKeys.clone());
        }
        return clone;
    }

    public void createConstraints(AbstractSession session, Writer schemaWriter) throws TopLinkException {
        this.createUniqueConstraints(session, schemaWriter);
        this.createForeignConstraints(session, schemaWriter);
    }

    void createUniqueConstraints(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.createUniqueConstraintsOnDatabase(session);
            return;
        }
        Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
            this.buildUniqueConstraintCreationWriter(session, uniqueKey, schemaWriter).toString();
            try {
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    void createForeignConstraints(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.createForeignConstraintsOnDatabase(session);
            return;
        }
        for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
            this.buildConstraintCreationWriter(session, foreignKey, schemaWriter).toString();
            try {
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    public void createConstraintsOnDatabase(AbstractSession session) throws TopLinkException {
        this.createUniqueConstraintsOnDatabase(session);
        this.createForeignConstraintsOnDatabase(session);
    }

    void createUniqueConstraintsOnDatabase(AbstractSession session) throws ValidationException, DatabaseException {
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty()) {
            return;
        }
        Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
            session.executeNonSelectingCall(new SQLCall(this.buildUniqueConstraintCreationWriter(session, uniqueKey, new StringWriter()).toString()));
        }
    }

    void createForeignConstraintsOnDatabase(AbstractSession session) throws ValidationException, DatabaseException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeyMap().isEmpty()) {
            return;
        }
        for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
            session.executeNonSelectingCall(new SQLCall(this.buildConstraintCreationWriter(session, foreignKey, new StringWriter()).toString()));
        }
    }

    public String deletionStringFor(DatabaseAccessor accessor) {
        return "DROP TABLE " + this.getName();
    }

    public void dropConstraints(AbstractSession session, Writer schemaWriter) throws TopLinkException {
        if (schemaWriter == null) {
            this.dropConstraintsOnDatabase(session);
        } else {
            for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
                this.buildConstraintDeletionWriter(session, foreignKey, schemaWriter).toString();
                try {
                    if (this.createSQLFiles) {
                        schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                    }
                    schemaWriter.write("\n");
                }
                catch (IOException exception) {
                    throw ValidationException.fileError(exception);
                }
            }
            Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
            while (uniqueKeysEnum.hasMoreElements()) {
                UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
                this.buildUniqueConstraintDeletionWriter(session, uniqueKey, schemaWriter).toString();
                try {
                    if (this.createSQLFiles) {
                        schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                    }
                    schemaWriter.write("\n");
                }
                catch (IOException exception) {
                    throw ValidationException.fileError(exception);
                }
            }
        }
    }

    public void dropConstraintsOnDatabase(AbstractSession session) throws TopLinkException {
        this.dropForeignConstraintsOnDatabase(session);
        this.dropUniqueConstraintsOnDatabase(session);
    }

    private void dropUniqueConstraintsOnDatabase(AbstractSession session) throws ValidationException {
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty()) {
            return;
        }
        Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
            try {
                session.executeNonSelectingCall(new SQLCall(this.buildUniqueConstraintDeletionWriter(session, uniqueKey, new StringWriter()).toString()));
            }
            catch (DatabaseException ex) {}
        }
    }

    private void dropForeignConstraintsOnDatabase(AbstractSession session) throws ValidationException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeyMap().isEmpty()) {
            return;
        }
        for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
            try {
                session.executeNonSelectingCall(new SQLCall(this.buildConstraintDeletionWriter(session, foreignKey, new StringWriter()).toString()));
            }
            catch (DatabaseException ex) {}
        }
    }

    HashMap<String, ForeignKeyConstraint> getForeignKeyMap() {
        return this.foreignKeyMap;
    }

    void setForeignKeyMap(HashMap<String, ForeignKeyConstraint> foreignKeyMap) {
        this.foreignKeyMap = foreignKeyMap;
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector<ForeignKeyConstraint> getForeignKeys() {
        return new Vector<ForeignKeyConstraint>(this.foreignKeyMap.values());
    }

    public Vector<UniqueKeyConstraint> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public Vector getPrimaryKeyFieldNames() {
        Vector<String> keyNames = new Vector<String>();
        Enumeration fieldEnum = this.getFields().elements();
        while (fieldEnum.hasMoreElements()) {
            FieldDefinition field = (FieldDefinition)fieldEnum.nextElement();
            if (!field.isPrimaryKey()) continue;
            keyNames.addElement(field.getName());
        }
        return keyNames;
    }

    public void setFields(Vector fields) {
        this.fields = fields;
    }

    public void setForeignKeys(Vector<ForeignKeyConstraint> foreignKeys) {
        this.foreignKeyMap.clear();
        if (foreignKeys != null) {
            for (ForeignKeyConstraint foreignKey : foreignKeys) {
                this.foreignKeyMap.put(foreignKey.getName(), foreignKey);
            }
        }
    }

    public void setUniqueKeys(Vector<UniqueKeyConstraint> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    public void setCreateSQLFiles(boolean genFlag) {
        this.createSQLFiles = genFlag;
    }
}

