/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;

public abstract class MetadataAccessibleObject {
    private String m_name;
    private Class m_rawClass;
    private Type m_relationType;
    private String m_attributeName;
    private Class m_referenceClass;
    private AnnotatedElement m_annotatedElement;

    public MetadataAccessibleObject(AnnotatedElement annotatedElement) {
        this.m_annotatedElement = annotatedElement;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.m_annotatedElement;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public Class getMapKeyClass() {
        if (MetadataHelper.isGenericCollectionType(this.m_relationType)) {
            return MetadataHelper.getMapKeyTypeFromGeneric(this.m_relationType);
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public Class getRawClass() {
        if (this.m_rawClass == null) {
            this.m_rawClass = MetadataHelper.isGenericCollectionType(this.m_relationType) ? MetadataHelper.getRawClassFromGeneric(this.m_relationType) : (Class)this.m_relationType;
        }
        return this.m_rawClass;
    }

    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            if (MetadataHelper.isGenericCollectionType(this.m_relationType)) {
                this.m_referenceClass = MetadataHelper.getReturnTypeFromGeneric(this.m_relationType);
            } else {
                if (MetadataHelper.isCollectionClass((Class)this.m_relationType)) {
                    return null;
                }
                if (MetadataHelper.isMapClass((Class)this.m_relationType)) {
                    return null;
                }
                this.m_referenceClass = (Class)this.m_relationType;
            }
        }
        return this.m_referenceClass;
    }

    public Type getRelationType() {
        return this.m_relationType;
    }

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        this.m_annotatedElement = annotatedElement;
    }

    protected void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    protected void setRelationType(Type relationType) {
        this.m_relationType = relationType;
    }
}

