/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.constraints.Min;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.execution.FlowExecutionListenerAdapter;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;

public final class TerminateWebSessionListener
extends FlowExecutionListenerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminateWebSessionListener.class);
    @Min(value=0L)
    private int timeToDieInSeconds = 2;

    public void sessionEnded(RequestContext context, FlowSession session, String outcome, AttributeMap output) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpSession webSession = request.getSession(false);
        if (webSession != null) {
            LOGGER.debug("Terminate web session {} in {} seconds", (Object)webSession.getId(), (Object)this.timeToDieInSeconds);
            webSession.setMaxInactiveInterval(this.timeToDieInSeconds);
        }
    }

    public int getTimeToDieInSeconds() {
        return this.timeToDieInSeconds;
    }

    public void setTimeToDieInSeconds(int timeToDieInSeconds) {
        this.timeToDieInSeconds = timeToDieInSeconds;
    }
}

