/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.converter.export.TaskExport;
import org.flowable.cmmn.model.HumanTask;

public class HumanTaskExport
extends AbstractPlanItemDefinitionExport<HumanTask> {
    protected static String convertListToCommaSeparatedString(List<String> values) {
        StringBuilder valueBuilder = new StringBuilder();
        for (String value : values) {
            if (valueBuilder.length() > 0) {
                valueBuilder.append(",");
            }
            valueBuilder.append(value);
        }
        return valueBuilder.toString();
    }

    @Override
    protected Class<HumanTask> getExportablePlanItemDefinitionClass() {
        return HumanTask.class;
    }

    @Override
    protected String getPlanItemDefinitionXmlElementValue(HumanTask planItemDefinition) {
        return "humanTask";
    }

    @Override
    protected void writePlanItemDefinitionSpecificAttributes(HumanTask humanTask, XMLStreamWriter xtw) throws Exception {
        super.writePlanItemDefinitionSpecificAttributes(humanTask, xtw);
        TaskExport.writeCommonTaskAttributes(humanTask, xtw);
        if (StringUtils.isNotEmpty((CharSequence)humanTask.getAssignee())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "assignee", humanTask.getAssignee());
        }
        if (StringUtils.isNotEmpty((CharSequence)humanTask.getOwner())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "owner", humanTask.getOwner());
        }
        if (humanTask.getCandidateUsers() != null && humanTask.getCandidateUsers().size() > 0) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "candidateUsers", HumanTaskExport.convertListToCommaSeparatedString(humanTask.getCandidateUsers()));
        }
        if (humanTask.getCandidateGroups() != null && humanTask.getCandidateGroups().size() > 0) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "candidateGroups", HumanTaskExport.convertListToCommaSeparatedString(humanTask.getCandidateGroups()));
        }
        if (StringUtils.isNotEmpty((CharSequence)humanTask.getFormKey())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "formKey", humanTask.getFormKey());
        }
    }
}

