/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.parser;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamReader;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.GraphicInfo;

public class BpmnEdgeParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String id = xtr.getAttributeValue(null, "bpmnElement");
        ArrayList<GraphicInfo> wayPointList = new ArrayList<GraphicInfo>();
        block0: while (xtr.hasNext()) {
            GraphicInfo graphicInfo;
            xtr.next();
            if (xtr.isStartElement() && "BPMNLabel".equalsIgnoreCase(xtr.getLocalName())) {
                while (xtr.hasNext()) {
                    xtr.next();
                    if (xtr.isStartElement() && "Bounds".equalsIgnoreCase(xtr.getLocalName())) {
                        graphicInfo = new GraphicInfo();
                        BpmnXMLUtil.addXMLLocation(graphicInfo, xtr);
                        graphicInfo.setX((double)Double.valueOf(xtr.getAttributeValue(null, "x")).intValue());
                        graphicInfo.setY((double)Double.valueOf(xtr.getAttributeValue(null, "y")).intValue());
                        graphicInfo.setWidth((double)Double.valueOf(xtr.getAttributeValue(null, "width")).intValue());
                        graphicInfo.setHeight((double)Double.valueOf(xtr.getAttributeValue(null, "height")).intValue());
                        model.addLabelGraphicInfo(id, graphicInfo);
                        continue block0;
                    }
                    if (!xtr.isEndElement() || !"BPMNLabel".equalsIgnoreCase(xtr.getLocalName())) continue;
                    continue block0;
                }
                continue;
            }
            if (xtr.isStartElement() && "waypoint".equalsIgnoreCase(xtr.getLocalName())) {
                graphicInfo = new GraphicInfo();
                BpmnXMLUtil.addXMLLocation(graphicInfo, xtr);
                graphicInfo.setX((double)Double.valueOf(xtr.getAttributeValue(null, "x")).intValue());
                graphicInfo.setY((double)Double.valueOf(xtr.getAttributeValue(null, "y")).intValue());
                wayPointList.add(graphicInfo);
                continue;
            }
            if (!xtr.isEndElement() || !"BPMNEdge".equalsIgnoreCase(xtr.getLocalName())) continue;
        }
        model.addFlowGraphicInfoList(id, wayPointList);
    }

    public BaseElement parseElement() {
        return null;
    }
}

