/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;

public class InitialFlowSetupAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialFlowSetupAction.class);
    private final CasConfigurationProperties casProperties;
    private final ServicesManager servicesManager;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final CookieRetrievingCookieGenerator warnCookieGenerator;
    private final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    private final List<ArgumentExtractor> argumentExtractors;

    public InitialFlowSetupAction(List<ArgumentExtractor> argumentExtractors, ServicesManager servicesManager, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionPlan, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, CookieRetrievingCookieGenerator warnCookieGenerator, CasConfigurationProperties casProperties) {
        this.argumentExtractors = argumentExtractors;
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionPlan;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.warnCookieGenerator = warnCookieGenerator;
        this.casProperties = casProperties;
    }

    protected Event doExecute(RequestContext context) {
        this.configureCookieGenerators(context);
        this.configureWebflowContext(context);
        this.configureWebflowContextForService(context);
        return this.success();
    }

    private void configureWebflowContextForService(RequestContext context) {
        WebApplicationService service = WebUtils.getService(this.argumentExtractors, (RequestContext)context);
        if (service != null) {
            LOGGER.debug("Placing service in context scope: [{}]", (Object)service.getId());
            Service selectedService = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)service);
            RegisteredService registeredService = this.servicesManager.findServiceBy(selectedService);
            if (registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed()) {
                LOGGER.debug("Placing registered service [{}] with id [{}] in context scope", (Object)registeredService.getServiceId(), (Object)registeredService.getId());
                WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
                RegisteredServiceAccessStrategy accessStrategy = registeredService.getAccessStrategy();
                if (accessStrategy.getUnauthorizedRedirectUrl() != null) {
                    LOGGER.debug("Placing registered service's unauthorized redirect url [{}] with id [{}] in context scope", (Object)accessStrategy.getUnauthorizedRedirectUrl(), (Object)registeredService.getServiceId());
                    WebUtils.putUnauthorizedRedirectUrl((RequestContext)context, (URI)accessStrategy.getUnauthorizedRedirectUrl());
                }
            }
        } else if (!this.casProperties.getSso().isMissingService()) {
            LOGGER.warn("No service authentication request is available at [{}]. CAS is configured to disable the flow.", (Object)WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context).getRequestURL());
            throw new NoSuchFlowExecutionException(context.getFlowExecutionContext().getKey(), (Exception)new UnauthorizedServiceException("screen.service.required.message", "Service is required"));
        }
        WebUtils.putService((RequestContext)context, (Service)service);
    }

    private void configureWebflowContext(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (String)this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request));
        WebUtils.putGoogleAnalyticsTrackingIdIntoFlowScope((RequestContext)context, (Object)this.casProperties.getGoogleAnalytics().getGoogleAnalyticsTrackingId());
        WebUtils.putWarningCookie((RequestContext)context, (Boolean)Boolean.valueOf(this.warnCookieGenerator.retrieveCookieValue(request)));
        WebUtils.putGeoLocationTrackingIntoFlowScope((RequestContext)context, (Object)this.casProperties.getEvents().isTrackGeolocation());
        WebUtils.putRecaptchaSiteKeyIntoFlowScope((RequestContext)context, (Object)this.casProperties.getGoogleRecaptcha().getSiteKey());
        WebUtils.putStaticAuthenticationIntoFlowScope((RequestContext)context, (Object)(StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getAccept().getUsers()) || StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getReject().getUsers()) ? 1 : 0));
        WebUtils.putPasswordManagementEnabled((RequestContext)context, (Boolean)this.casProperties.getAuthn().getPm().isEnabled());
        WebUtils.putRememberMeAuthenticationEnabled((RequestContext)context, (Boolean)this.casProperties.getTicket().getTgt().getRememberMe().isEnabled());
    }

    private void configureCookieGenerators(RequestContext context) {
        String cookiePath;
        String contextPath = context.getExternalContext().getContextPath();
        String string = cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + '/' : "/";
        if (StringUtils.isBlank((CharSequence)this.warnCookieGenerator.getCookiePath())) {
            LOGGER.info("Setting path for cookies for warn cookie generator to: [{}] ", (Object)cookiePath);
            this.warnCookieGenerator.setCookiePath(cookiePath);
        } else {
            LOGGER.debug("Warning cookie path is set to [{}] and path [{}]", (Object)this.warnCookieGenerator.getCookieDomain(), (Object)this.warnCookieGenerator.getCookiePath());
        }
        if (StringUtils.isBlank((CharSequence)this.ticketGrantingTicketCookieGenerator.getCookiePath())) {
            LOGGER.debug("Setting path for cookies for TGC cookie generator to: [{}] ", (Object)cookiePath);
            this.ticketGrantingTicketCookieGenerator.setCookiePath(cookiePath);
        } else {
            LOGGER.debug("TGC cookie path is set to [{}] and path [{}]", (Object)this.ticketGrantingTicketCookieGenerator.getCookieDomain(), (Object)this.ticketGrantingTicketCookieGenerator.getCookiePath());
        }
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }
}

