/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.util;

import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.util.LongDecoderException;

public class LongDecoder {
    private static final long[] MASK = new long[]{255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};

    public static long parse(Value value, long min, long max) throws LongDecoderException {
        long result = 0L;
        byte[] bytes = value.getData();
        if (bytes == null || bytes.length == 0) {
            throw new LongDecoderException("The value is 0 byte long. This is not allowed for a long");
        }
        if (bytes.length > 8) {
            throw new LongDecoderException("The value is more than 4 bytes long. This is not allowed for a long");
        }
        for (int i = 0; i < bytes.length && i < 9; ++i) {
            result = result << 8 | (long)(bytes[i] & 0xFF);
        }
        if ((bytes[0] & 0x80) == 128) {
            result = -((result ^ 0xFFFFFFFFFFFFFFFFL) + 1L & MASK[bytes.length - 1]);
        }
        if (result >= min && result <= max) {
            return result;
        }
        throw new LongDecoderException("The value is not in the range [" + min + ", " + max + "]");
    }

    public static long parse(Value value) throws LongDecoderException {
        return LongDecoder.parse(value, Long.MIN_VALUE, Long.MAX_VALUE);
    }
}

