/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.ext.ParameterHandler;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ReaderInterceptorMBR;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.ResourceInfoImpl;
import org.apache.cxf.jaxrs.impl.WebApplicationExceptionMapper;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.model.BeanParamInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.model.wadl.WadlGenerator;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.DataSourceProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.provider.MultipartProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public final class ProviderFactory {
    public static final String PROVIDER_SELECTION_PROPERTY_CHANGED = "provider.selection.property.changed";
    static final String IGNORE_TYPE_VARIABLES = "org.apache.cxf.jaxrs.providers.ignore.typevars";
    private static final Class<?>[] FILTER_INTERCEPTOR_CLASSES = new Class[]{ContainerRequestFilter.class, ContainerResponseFilter.class, ReaderInterceptor.class, WriterInterceptor.class};
    private static final String ACTIVE_JAXRS_PROVIDER_KEY = "active.jaxrs.provider";
    private static final Logger LOG = LogUtils.getL7dLogger(ProviderFactory.class);
    private static final ProviderFactory SHARED_FACTORY = ProviderFactory.getInstance();
    private static final String DEFAULT_FILTER_NAME_BINDING = "org.apache.cxf.filter.binding";
    private static final String JAXB_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.JAXBElementProvider";
    private static final String JSON_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.json.JSONProvider";
    private static final String BUS_PROVIDERS_ALL = "org.apache.cxf.jaxrs.bus.providers";
    private List<ProviderInfo<MessageBodyReader<?>>> messageReaders = new ArrayList();
    private List<ProviderInfo<MessageBodyWriter<?>>> messageWriters = new ArrayList();
    private List<ProviderInfo<ContextResolver<?>>> contextResolvers = new ArrayList(1);
    private List<ProviderInfo<ContextProvider<?>>> contextProviders = new ArrayList(1);
    private Set<ParamConverterProvider> newParamConverters;
    private LegacyParamConverterProvider legacyParamConverter;
    private List<ProviderInfo<MessageBodyReader<?>>> jaxbReaders = new ArrayList();
    private List<ProviderInfo<MessageBodyWriter<?>>> jaxbWriters = new ArrayList();
    private List<ProviderInfo<ReaderInterceptor>> readerInterceptors = new ArrayList<ProviderInfo<ReaderInterceptor>>(1);
    private List<ProviderInfo<WriterInterceptor>> writerInterceptors = new ArrayList<ProviderInfo<WriterInterceptor>>(1);
    private List<ProviderInfo<ExceptionMapper<?>>> exceptionMappers = new ArrayList(1);
    private List<ProviderInfo<RequestHandler>> requestHandlers = new ArrayList<ProviderInfo<RequestHandler>>(1);
    private List<ProviderInfo<ResponseHandler>> responseHandlers = new ArrayList<ProviderInfo<ResponseHandler>>(1);
    private List<ProviderInfo<ContainerRequestFilter>> preMatchContainerRequestFilters = new ArrayList<ProviderInfo<ContainerRequestFilter>>(1);
    private Map<NameKey, ProviderInfo<ContainerRequestFilter>> postMatchContainerRequestFilters = new LinkedHashMap<NameKey, ProviderInfo<ContainerRequestFilter>>();
    private Map<NameKey, ProviderInfo<ContainerResponseFilter>> postMatchContainerResponseFilters = new LinkedHashMap<NameKey, ProviderInfo<ContainerResponseFilter>>();
    private RequestPreprocessor requestPreprocessor;
    private ProviderInfo<Application> application;
    private List<DynamicFeature> dynamicFeatures = new LinkedList<DynamicFeature>();
    private Map<Class<?>, BeanParamInfo> beanParams = new HashMap();
    private Collection<ProviderInfo<?>> injectedProviders = new LinkedList();
    private List<ProviderInfo<ClientRequestFilter>> clientRequestFilters = new ArrayList<ProviderInfo<ClientRequestFilter>>(1);
    private List<ProviderInfo<ClientResponseFilter>> clientResponseFilters = new ArrayList<ProviderInfo<ClientResponseFilter>>(1);
    private List<ProviderInfo<ResponseExceptionMapper<?>>> responseExceptionMappers = new ArrayList(1);
    private Bus bus;

    private ProviderFactory(Bus bus) {
        this.bus = bus;
        this.initJaxbProviders();
        this.setBusProviders();
    }

    public Bus getBus() {
        return this.bus;
    }

    private void initJaxbProviders() {
        Object jsonProvider;
        Object jaxbProvider = ProviderFactory.createProvider(JAXB_PROVIDER_NAME);
        if (jaxbProvider != null) {
            this.jaxbReaders.add(new ProviderInfo<MessageBodyReader>((MessageBodyReader)jaxbProvider, this.bus));
            this.jaxbWriters.add(new ProviderInfo<MessageBodyWriter>((MessageBodyWriter)jaxbProvider, this.bus));
        }
        if ((jsonProvider = ProviderFactory.createProvider(JSON_PROVIDER_NAME)) != null) {
            this.jaxbReaders.add(new ProviderInfo<MessageBodyReader>((MessageBodyReader)jsonProvider, this.bus));
            this.jaxbWriters.add(new ProviderInfo<MessageBodyWriter>((MessageBodyWriter)jsonProvider, this.bus));
        }
        this.injectContextProxies(this.jaxbReaders, this.jaxbWriters);
    }

    private static Object createProvider(String className) {
        try {
            return ClassLoaderUtils.loadClass(className, ProviderFactory.class).newInstance();
        }
        catch (Throwable ex) {
            String message = "Problem with creating the default provider " + className;
            message = ex.getMessage() != null ? message + ": " + ex.getMessage() : message + ", exception class : " + ex.getClass().getName();
            LOG.fine(message);
            return null;
        }
    }

    public static ProviderFactory getInstance() {
        return new ProviderFactory(BusFactory.getThreadDefaultBus());
    }

    public static ProviderFactory createInstance(Bus bus) {
        return new ProviderFactory(bus);
    }

    public static ProviderFactory getInstance(Bus bus) {
        return (ProviderFactory)bus.getProperty(ProviderFactory.class.getName());
    }

    public static ProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().get(Endpoint.class);
        return (ProviderFactory)e.get(ProviderFactory.class.getName());
    }

    public static ProviderFactory getSharedInstance() {
        return SHARED_FACTORY;
    }

    public void addBeanParamInfo(BeanParamInfo bpi) {
        this.beanParams.put(bpi.getResourceClass(), bpi);
    }

    public BeanParamInfo getBeanParamInfo(Class<?> beanClass) {
        return this.beanParams.get(beanClass);
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        Message responseMessage;
        boolean isRequestor = MessageUtils.isRequestor(m);
        Message requestMessage = isRequestor ? m.getExchange().getOutMessage() : m.getExchange().getInMessage();
        HttpHeadersImpl requestHeaders = new HttpHeadersImpl(requestMessage);
        MediaType mt = null;
        Message message = responseMessage = isRequestor ? m.getExchange().getInMessage() : m.getExchange().getOutMessage();
        if (responseMessage != null) {
            Object ctProperty = responseMessage.get("Content-Type");
            if (ctProperty == null) {
                List accepts = requestHeaders.getAcceptableMediaTypes();
                if (accepts.size() > 0) {
                    mt = (MediaType)accepts.get(0);
                }
            } else {
                mt = JAXRSUtils.toMediaType(ctProperty.toString());
            }
        } else {
            mt = requestHeaders.getMediaType();
        }
        return this.createContextResolver(contextType, m, mt == null ? MediaType.WILDCARD_TYPE : mt);
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m, MediaType type) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ContextResolver<?>> cr : this.contextResolvers) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                List<MediaType> mTypes;
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls) || JAXRSUtils.intersectMimeTypes(mTypes = JAXRSUtils.getProduceTypes(cr.getProvider().getClass().getAnnotation(Produces.class)), type).size() <= 0) continue;
                ProviderFactory.injectContextValues(cr, m);
                candidates.add(cr.getProvider());
            }
        }
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ContextResolver)candidates.get(0);
        }
        Collections.sort(candidates, new ClassComparator());
        return new ContextResolverProxy(candidates);
    }

    public <T> ContextProvider<T> createContextProvider(Type contextType, Message m) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        for (ProviderInfo<ContextProvider<?>> cr : this.contextProviders) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls)) continue;
                return cr.getProvider();
            }
        }
        return null;
    }

    public <T extends Throwable> ExceptionMapper<T> createExceptionMapper(Class<?> exceptionType, Message m) {
        ExceptionMapper<T> mapper = this.doCreateExceptionMapper(exceptionType, m);
        if (mapper != null || this == SHARED_FACTORY) {
            return mapper;
        }
        return SHARED_FACTORY.createExceptionMapper(exceptionType, m);
    }

    private <T extends Throwable> ExceptionMapper<T> doCreateExceptionMapper(Class<?> exceptionType, Message m) {
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ExceptionMapper<?>> em : this.exceptionMappers) {
            ProviderFactory.handleMapper(candidates, em, exceptionType, m, ExceptionMapper.class, true);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator(exceptionType));
        return (ExceptionMapper)candidates.get(0);
    }

    public <T> ParamConverter<T> createParameterHandler(Class<T> paramType, Annotation[] anns) {
        if (this.newParamConverters != null) {
            anns = anns != null ? anns : new Annotation[]{};
            for (ParamConverterProvider newParamConverter : this.newParamConverters) {
                ParamConverter converter = newParamConverter.getConverter(paramType, paramType, anns);
                if (converter == null) continue;
                return converter;
            }
        } else if (this.legacyParamConverter != null) {
            return this.legacyParamConverter.getConverter(paramType, null, null);
        }
        return null;
    }

    public <T extends Throwable> ResponseExceptionMapper<T> createResponseExceptionMapper(Message m, Class<?> paramType) {
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ResponseExceptionMapper<?>> em : this.responseExceptionMappers) {
            ProviderFactory.handleMapper(candidates, em, paramType, m, ResponseExceptionMapper.class, true);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator(paramType));
        return (ResponseExceptionMapper)candidates.get(0);
    }

    private static <T> void handleMapper(List<T> candidates, ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass, boolean injectContext) {
        Class<?> mapperClass = ClassHelper.getRealClass(em.getProvider());
        Type[] types = null;
        types = m != null && MessageUtils.isTrue(m.getContextualProperty(IGNORE_TYPE_VARIABLES)) ? new Type[]{mapperClass} : ProviderFactory.getGenericInterfaces(mapperClass, expectedType);
        for (Type t : types) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type arg = args[i];
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (int j = 0; j < bounds.length; ++j) {
                            Class<?> cls = InjectionUtils.getRawType(bounds[j]);
                            if (cls == null || !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        if (!isResolved) {
                            return;
                        }
                        if (injectContext) {
                            ProviderFactory.injectContextValues(em, m);
                        }
                        candidates.add(em.getProvider());
                        return;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null) continue;
                    if (expectedType.isArray() && !actualClass.isArray()) {
                        expectedType = expectedType.getComponentType();
                    }
                    if (!actualClass.isAssignableFrom(expectedType) && actualClass != Object.class) continue;
                    if (injectContext) {
                        ProviderFactory.injectContextValues(em, m);
                    }
                    candidates.add(em.getProvider());
                    return;
                }
                continue;
            }
            if (!(t instanceof Class) || !providerClass.isAssignableFrom((Class)t)) continue;
            if (injectContext) {
                ProviderFactory.injectContextValues(em, m);
            }
            candidates.add(em.getProvider());
        }
    }

    public <T> List<ReaderInterceptor> createMessageBodyReaderInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyReader<T> mr = this.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mr != null) {
            ReaderInterceptorMBR mbrReader = new ReaderInterceptorMBR(mr, m.getExchange().getInMessage());
            int size = this.readerInterceptors.size();
            List<ReaderInterceptor> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<ReaderInterceptor>(size + 1);
                for (ProviderInfo<ReaderInterceptor> p : this.readerInterceptors) {
                    InjectionUtils.injectContexts(p.getProvider(), p, m);
                    interceptors.add(p.getProvider());
                }
                interceptors.add(mbrReader);
            } else {
                interceptors = Collections.singletonList(mbrReader);
            }
            return interceptors;
        }
        return null;
    }

    public <T> List<WriterInterceptor> createMessageBodyWriterInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyWriter<T> mw = this.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mw != null) {
            WriterInterceptorMBW mbwWriter = new WriterInterceptorMBW(mw, m);
            int size = this.writerInterceptors.size();
            List<WriterInterceptor> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<WriterInterceptor>(size + 1);
                for (ProviderInfo<WriterInterceptor> p : this.writerInterceptors) {
                    InjectionUtils.injectContexts(p.getProvider(), p, m);
                    interceptors.add(p.getProvider());
                }
                interceptors.add(mbwWriter);
            } else {
                interceptors = Collections.singletonList(mbwWriter);
            }
            return interceptors;
        }
        return null;
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyReader<T> mr = this.chooseMessageReader(this.messageReaders, bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mr == null) {
            mr = this.chooseMessageReader(this.jaxbReaders, bodyType, parameterType, parameterAnnotations, mediaType, m);
        }
        if (mr != null || SHARED_FACTORY == this) {
            return mr;
        }
        return SHARED_FACTORY.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
    }

    private boolean isJaxbBasedProvider(Object sharedProvider) {
        String clsName = sharedProvider.getClass().getName();
        return JAXB_PROVIDER_NAME.equals(clsName) || JSON_PROVIDER_NAME.equals(clsName);
    }

    public List<ProviderInfo<ContainerRequestFilter>> getPreMatchContainerRequestFilters() {
        return Collections.unmodifiableList(this.preMatchContainerRequestFilters);
    }

    public List<ProviderInfo<ContainerRequestFilter>> getPostMatchContainerRequestFilters(List<String> names) {
        return ProviderFactory.getPostMatchContainerFilters(this.postMatchContainerRequestFilters, names);
    }

    public List<ProviderInfo<ContainerResponseFilter>> getContainerResponseFilters(List<String> names) {
        return ProviderFactory.getPostMatchContainerFilters(this.postMatchContainerResponseFilters, names);
    }

    public List<ProviderInfo<ClientRequestFilter>> getClientRequestFilters() {
        return Collections.unmodifiableList(this.clientRequestFilters);
    }

    public List<ProviderInfo<ClientResponseFilter>> getClientResponseFilters() {
        return Collections.unmodifiableList(this.clientResponseFilters);
    }

    private static <T> List<ProviderInfo<T>> getPostMatchContainerFilters(Map<NameKey, ProviderInfo<T>> boundFilters, List<String> names) {
        if (boundFilters.isEmpty()) {
            return Collections.emptyList();
        }
        names = names == null ? Collections.emptyList() : names;
        MetadataMap map = new MetadataMap();
        for (Map.Entry<NameKey, ProviderInfo<T>> entry : boundFilters.entrySet()) {
            String entryName = entry.getKey().getName();
            if (entryName.equals(DEFAULT_FILTER_NAME_BINDING)) {
                map.put(entry.getValue(), Collections.emptyList());
                continue;
            }
            if (entryName.endsWith(":dynamic") && !names.contains(entryName)) continue;
            map.add(entry.getValue(), entryName);
        }
        LinkedList<ProviderInfo<T>> list = new LinkedList<ProviderInfo<T>>();
        for (Map.Entry entry : map.entrySet()) {
            if (!names.containsAll((Collection)entry.getValue())) continue;
            list.add((ProviderInfo<T>)entry.getKey());
        }
        return list;
    }

    public List<ProviderInfo<RequestHandler>> getRequestHandlers() {
        List<ProviderInfo<RequestHandler>> handlers = null;
        if (this.requestHandlers.size() == 0) {
            handlers = ProviderFactory.SHARED_FACTORY.requestHandlers;
        } else {
            handlers = new ArrayList<ProviderInfo<RequestHandler>>();
            boolean customWADLHandler = false;
            for (int i = 0; i < this.requestHandlers.size(); ++i) {
                if (!(this.requestHandlers.get(i).getProvider() instanceof WadlGenerator)) continue;
                customWADLHandler = true;
                break;
            }
            if (!customWADLHandler) {
                handlers.addAll(ProviderFactory.SHARED_FACTORY.requestHandlers);
            }
            handlers.addAll(this.requestHandlers);
        }
        return Collections.unmodifiableList(handlers);
    }

    public List<ProviderInfo<ResponseHandler>> getResponseHandlers() {
        return Collections.unmodifiableList(this.responseHandlers);
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyWriter<T> mw = this.chooseMessageWriter(this.messageWriters, bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mw == null) {
            mw = this.chooseMessageWriter(this.jaxbWriters, bodyType, parameterType, parameterAnnotations, mediaType, m);
        }
        if (mw != null || SHARED_FACTORY == this) {
            return mw;
        }
        return SHARED_FACTORY.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
    }

    private void setBusProviders() {
        LinkedList<Object> extensions = new LinkedList<Object>();
        String alreadySetProp = "bus.providers.set";
        if (this.bus.getProperty("bus.providers.set") == null) {
            this.addBusExtension(extensions, MessageBodyReader.class, MessageBodyWriter.class, ExceptionMapper.class);
            if (!extensions.isEmpty()) {
                this.setProviders(extensions.toArray());
                this.bus.setProperty("bus.providers.set", "");
            }
        }
    }

    private void addBusExtension(List<Object> extensions, Class<?> ... extClasses) {
        for (Class<?> extClass : extClasses) {
            Object ext = this.bus.getProperty(extClass.getName());
            if (!extClass.isInstance(ext)) continue;
            extensions.add(ext);
        }
        Object allProp = this.bus.getProperty(BUS_PROVIDERS_ALL);
        if (allProp instanceof List) {
            List all = (List)allProp;
            extensions.addAll(all);
        }
    }

    private void setProviders(Object ... providers) {
        LinkedList postMatchRequestFilters = new LinkedList();
        LinkedList postMatchResponseFilters = new LinkedList();
        for (Object o : providers) {
            if (o == null) continue;
            Class<?> oClass = ClassHelper.getRealClass(o);
            if (MessageBodyReader.class.isAssignableFrom(oClass)) {
                this.messageReaders.add(new ProviderInfo<MessageBodyReader>((MessageBodyReader)o, this.bus));
            }
            if (MessageBodyWriter.class.isAssignableFrom(oClass)) {
                this.messageWriters.add(new ProviderInfo<MessageBodyWriter>((MessageBodyWriter)o, this.bus));
            }
            if (ContextResolver.class.isAssignableFrom(oClass)) {
                this.contextResolvers.add(new ProviderInfo<ContextResolver>((ContextResolver)o, this.bus));
            }
            if (ContextProvider.class.isAssignableFrom(oClass)) {
                this.contextProviders.add(new ProviderInfo<ContextProvider>((ContextProvider)o, this.bus));
            }
            if (RequestHandler.class.isAssignableFrom(oClass)) {
                this.requestHandlers.add(new ProviderInfo<RequestHandler>((RequestHandler)o, this.bus));
            }
            if (ResponseHandler.class.isAssignableFrom(oClass)) {
                this.responseHandlers.add(new ProviderInfo<ResponseHandler>((ResponseHandler)o, this.bus));
            }
            if (ContainerRequestFilter.class.isAssignableFrom(oClass)) {
                ProviderFactory.addContainerFilter(postMatchRequestFilters, new ProviderInfo<ContainerRequestFilter>((ContainerRequestFilter)o, this.bus), this.preMatchContainerRequestFilters);
            }
            if (ContainerResponseFilter.class.isAssignableFrom(oClass)) {
                ProviderFactory.addContainerFilter(postMatchResponseFilters, new ProviderInfo<ContainerResponseFilter>((ContainerResponseFilter)o, this.bus), null);
            }
            if (ReaderInterceptor.class.isAssignableFrom(oClass)) {
                this.readerInterceptors.add(new ProviderInfo<ReaderInterceptor>((ReaderInterceptor)o, this.bus));
            }
            if (WriterInterceptor.class.isAssignableFrom(oClass)) {
                this.writerInterceptors.add(new ProviderInfo<WriterInterceptor>((WriterInterceptor)o, this.bus));
            }
            if (DynamicFeature.class.isAssignableFrom(oClass)) {
                this.dynamicFeatures.add((DynamicFeature)o);
            }
            if (ClientRequestFilter.class.isAssignableFrom(oClass)) {
                this.clientRequestFilters.add(new ProviderInfo<ClientRequestFilter>((ClientRequestFilter)o, this.bus));
            }
            if (ClientResponseFilter.class.isAssignableFrom(oClass)) {
                this.clientResponseFilters.add(new ProviderInfo<ClientResponseFilter>((ClientResponseFilter)o, this.bus));
            }
            if (ExceptionMapper.class.isAssignableFrom(oClass)) {
                this.exceptionMappers.add(new ProviderInfo<ExceptionMapper>((ExceptionMapper)o, this.bus));
            }
            if (ResponseExceptionMapper.class.isAssignableFrom(oClass)) {
                this.responseExceptionMappers.add(new ProviderInfo<ResponseExceptionMapper>((ResponseExceptionMapper)o, this.bus));
            }
            if (ParamConverterProvider.class.isAssignableFrom(oClass)) {
                if (this.newParamConverters == null) {
                    this.newParamConverters = new LinkedHashSet<ParamConverterProvider>();
                }
                this.newParamConverters.add((ParamConverterProvider)o);
            }
            if (!ParameterHandler.class.isAssignableFrom(oClass)) continue;
            if (this.legacyParamConverter == null) {
                this.legacyParamConverter = new LegacyParamConverterProvider();
            }
            this.legacyParamConverter.add(o, this.bus);
        }
        this.sortReaders();
        this.sortWriters();
        this.sortContextResolvers();
        Collections.sort(this.preMatchContainerRequestFilters, new BindingPriorityComparator(true));
        ProviderFactory.mapContainerFilters(this.postMatchContainerRequestFilters, postMatchRequestFilters, true);
        ProviderFactory.mapContainerFilters(this.postMatchContainerResponseFilters, postMatchResponseFilters, false);
        Collections.sort(this.readerInterceptors, new BindingPriorityComparator(true));
        Collections.sort(this.writerInterceptors, new BindingPriorityComparator(false));
        Collections.sort(this.clientRequestFilters, new BindingPriorityComparator(true));
        Collections.sort(this.clientResponseFilters, new BindingPriorityComparator(false));
        this.injectContextProxies(this.messageReaders, this.messageWriters, this.contextResolvers, this.requestHandlers, this.responseHandlers, this.exceptionMappers, this.postMatchContainerRequestFilters.values(), this.preMatchContainerRequestFilters, this.postMatchContainerResponseFilters.values(), this.responseExceptionMappers, this.clientRequestFilters, this.clientResponseFilters, this.readerInterceptors, this.writerInterceptors);
    }

    private static <T> void mapContainerFilters(Map<NameKey, ProviderInfo<T>> map, List<ProviderInfo<T>> postMatchFilters, boolean ascending) {
        Collections.sort(postMatchFilters, new PostMatchFilterComparator(ascending));
        for (ProviderInfo<T> p : postMatchFilters) {
            List<String> names = AnnotationUtils.getNameBindings(p.getProvider().getClass().getAnnotations());
            names = names.isEmpty() ? Collections.singletonList(DEFAULT_FILTER_NAME_BINDING) : names;
            for (String name : names) {
                map.put(new NameKey(name, AnnotationUtils.getBindingPriority(p.getProvider().getClass())), p);
            }
        }
    }

    private static <T> void addContainerFilter(List<ProviderInfo<T>> postMatchFilters, ProviderInfo<T> p, List<ProviderInfo<T>> preMatchFilters) {
        T filter = p.getProvider();
        if (preMatchFilters != null && ProviderFactory.isPrematching(filter.getClass())) {
            preMatchFilters.add(p);
        } else {
            postMatchFilters.add(p);
        }
    }

    private static boolean isPrematching(Class<?> filterCls) {
        return AnnotationUtils.getAnnotation(filterCls.getAnnotations(), PreMatching.class) != null;
    }

    static void injectContextValues(ProviderInfo<?> pi, Message m) {
        if (m != null) {
            InjectionUtils.injectContexts(pi.getProvider(), pi, m);
        }
    }

    void injectContextProxies(Collection<?> ... providerLists) {
        for (Collection<?> list : providerLists) {
            Collection<ProviderInfo> l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                if (SHARED_FACTORY == this && this.isJaxbBasedProvider(pi.getProvider())) continue;
                this.injectContextProxiesIntoProvider(pi);
            }
        }
    }

    void injectContextProxiesIntoProvider(ProviderInfo<?> pi) {
        if (pi.contextsAvailable()) {
            InjectionUtils.injectContextProxies(pi, pi.getProvider());
            this.injectedProviders.add(pi);
        }
    }

    private void sortReaders() {
        Collections.sort(this.messageReaders, new MessageBodyReaderComparator());
    }

    private void sortWriters() {
        Collections.sort(this.messageWriters, new MessageBodyWriterComparator());
    }

    private void sortContextResolvers() {
        Collections.sort(this.contextResolvers, new ContextResolverComparator());
    }

    private <T> MessageBodyReader<T> chooseMessageReader(List<ProviderInfo<MessageBodyReader<?>>> readers, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<MessageBodyReader<?>> ep : readers) {
            if (!this.matchesReaderCriterias(ep, type, genericType, annotations, mediaType, m)) continue;
            if (this == SHARED_FACTORY) {
                return ep.getProvider();
            }
            ProviderFactory.handleMapper(candidates, ep, type, m, MessageBodyReader.class, false);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator());
        return (MessageBodyReader)candidates.get(0);
    }

    private <T> boolean matchesReaderCriterias(ProviderInfo<MessageBodyReader<?>> pi, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        MessageBodyReader<?> ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderConsumeTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes, false);
        if (availableMimeTypes.size() == 0) {
            return false;
        }
        if (this != SHARED_FACTORY || !this.isJaxbBasedProvider(ep)) {
            ProviderFactory.injectContextValues(pi, m);
        }
        return ep.isReadable(type, genericType, annotations, mediaType);
    }

    private <T> MessageBodyWriter<T> chooseMessageWriter(List<ProviderInfo<MessageBodyWriter<?>>> writers, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<MessageBodyWriter<?>> ep : writers) {
            if (!this.matchesWriterCriterias(ep, type, genericType, annotations, mediaType, m)) continue;
            if (this == SHARED_FACTORY) {
                return ep.getProvider();
            }
            ProviderFactory.handleMapper(candidates, ep, type, m, MessageBodyWriter.class, false);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator());
        return (MessageBodyWriter)candidates.get(0);
    }

    private <T> boolean matchesWriterCriterias(ProviderInfo<MessageBodyWriter<?>> pi, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        MessageBodyWriter<?> ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderProduceTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes, false);
        if (availableMimeTypes.size() == 0) {
            return false;
        }
        if (!(this == SHARED_FACTORY && this.isJaxbBasedProvider(ep) || m.get(ACTIVE_JAXRS_PROVIDER_KEY) == ep)) {
            ProviderFactory.injectContextValues(pi, m);
        }
        return ep.isWriteable(type, genericType, annotations, mediaType);
    }

    List<ProviderInfo<MessageBodyReader<?>>> getMessageReaders() {
        return Collections.unmodifiableList(this.messageReaders);
    }

    List<ProviderInfo<MessageBodyWriter<?>>> getMessageWriters() {
        return Collections.unmodifiableList(this.messageWriters);
    }

    List<ProviderInfo<ContextResolver<?>>> getContextResolvers() {
        return Collections.unmodifiableList(this.contextResolvers);
    }

    public void registerUserProvider(Object provider) {
        this.setUserProviders(Collections.singletonList(provider));
    }

    public void setUserProviders(List<?> userProviders) {
        this.setProviders(userProviders.toArray());
    }

    public void setApplicationProvider(ProviderInfo<Application> app) {
        this.application = app;
    }

    public void setRequestPreprocessor(RequestPreprocessor rp) {
        this.requestPreprocessor = rp;
    }

    public RequestPreprocessor getRequestPreprocessor() {
        return this.requestPreprocessor;
    }

    public void clearExceptionMapperProxies() {
        this.clearProxies(this.exceptionMappers);
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.injectedProviders);
        if (this.application != null) {
            this.application.clearThreadLocalProxies();
        }
        if (this != SHARED_FACTORY) {
            SHARED_FACTORY.clearThreadLocalProxies();
        }
    }

    void clearProxies(Collection<?> ... lists) {
        for (Collection<?> list : lists) {
            Collection<ProviderInfo> l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                pi.clearThreadLocalProxies();
            }
        }
    }

    public void clearProviders() {
        this.messageReaders.clear();
        this.messageWriters.clear();
        this.contextResolvers.clear();
        this.contextProviders.clear();
        this.exceptionMappers.clear();
        this.requestHandlers.clear();
        this.responseHandlers.clear();
        this.postMatchContainerRequestFilters.clear();
        this.postMatchContainerResponseFilters.clear();
        this.preMatchContainerRequestFilters.clear();
        if (this.legacyParamConverter != null) {
            this.legacyParamConverter.clear();
        }
        this.responseExceptionMappers.clear();
        this.clientRequestFilters.clear();
        this.clientResponseFilters.clear();
    }

    public void setBus(Bus bus) {
        if (bus == null) {
            return;
        }
        for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
            this.injectProviderProperty(r.getProvider(), "setBus", Bus.class, bus);
        }
    }

    public void applyDynamicFeatures(List<ClassResourceInfo> list) {
        if (this.dynamicFeatures.size() > 0) {
            for (ClassResourceInfo cri : list) {
                this.doApplyDynamicFeatures(cri);
            }
        }
    }

    private void doApplyDynamicFeatures(ClassResourceInfo cri) {
        Set<OperationResourceInfo> oris = cri.getMethodDispatcher().getOperationResourceInfos();
        for (OperationResourceInfo ori : oris) {
            for (DynamicFeature feature : this.dynamicFeatures) {
                MethodConfigurable methodConfigurable = new MethodConfigurable(ori);
                feature.configure((ResourceInfo)new ResourceInfoImpl(ori), (Configurable)methodConfigurable);
            }
        }
        Collection<ClassResourceInfo> subs = cri.getSubResources();
        for (ClassResourceInfo sub : subs) {
            if (sub == cri) continue;
            this.doApplyDynamicFeatures(sub);
        }
    }

    private boolean injectProviderProperty(Object provider, String mName, Class<?> pClass, Object pValue) {
        try {
            Method m = provider.getClass().getMethod(mName, pClass);
            m.invoke(provider, pValue);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setSchemaLocations(List<String> schemas) {
        boolean schemasMethodAvailable = false;
        for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
            schemasMethodAvailable = this.injectProviderProperty(r.getProvider(), "setSchemaLocations", List.class, schemas);
        }
        if (!schemasMethodAvailable) {
            for (ProviderInfo<MessageBodyReader<?>> r : this.jaxbReaders) {
                this.injectProviderProperty(r.getProvider(), "setSchemaLocations", List.class, schemas);
            }
        }
    }

    public void initProviders(List<ClassResourceInfo> cris) {
        Set<Object> set = this.getReadersWriters();
        for (Object o : set) {
            Object provider = ((ProviderInfo)o).getProvider();
            if (!(provider instanceof AbstractConfigurableProvider)) continue;
            ((AbstractConfigurableProvider)provider).init(cris);
        }
        if (this != SHARED_FACTORY) {
            SHARED_FACTORY.initProviders(cris);
        }
    }

    Set<Object> getReadersWriters() {
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(this.messageReaders);
        set.addAll(this.jaxbReaders);
        set.addAll(this.messageWriters);
        set.addAll(this.jaxbWriters);
        return set;
    }

    protected static int compareClasses(Class<?> expectedCls, Object o1, Object o2) {
        Class<?> realClass2;
        Class<?> cl1 = ClassHelper.getRealClass(o1);
        Class<?> cl2 = ClassHelper.getRealClass(o2);
        Type[] types1 = ProviderFactory.getGenericInterfaces(cl1, expectedCls);
        Type[] types2 = ProviderFactory.getGenericInterfaces(cl2, expectedCls);
        if (types1.length == 0 && types2.length > 0) {
            return 1;
        }
        if (types1.length > 0 && types2.length == 0) {
            return -1;
        }
        Class<?> realClass1 = InjectionUtils.getActualType(types1[0]);
        if (realClass1 == (realClass2 = InjectionUtils.getActualType(types2[0]))) {
            return 0;
        }
        if (realClass1.isAssignableFrom(realClass2)) {
            return 1;
        }
        return -1;
    }

    private static Type[] getGenericInterfaces(Class<?> cls, Class<?> expectedClass) {
        Type[] types;
        Type genericSuperType;
        if (Object.class == cls) {
            return new Type[0];
        }
        if (expectedClass != null && (genericSuperType = cls.getGenericSuperclass()) instanceof ParameterizedType) {
            Class<?> actualType = InjectionUtils.getActualType(genericSuperType);
            if (expectedClass == actualType) {
                return new Type[]{genericSuperType};
            }
            if (actualType != null && expectedClass.isAssignableFrom(actualType)) {
                return new Type[0];
            }
        }
        if ((types = cls.getGenericInterfaces()).length > 0) {
            return types;
        }
        return ProviderFactory.getGenericInterfaces(cls.getSuperclass(), expectedClass);
    }

    public MessageBodyWriter<?> getRegisteredJaxbWriter() {
        for (ProviderInfo<MessageBodyWriter<?>> pi : this.messageWriters) {
            Class<?> cls = pi.getProvider().getClass();
            if (!cls.getName().equals(JAXB_PROVIDER_NAME) && !cls.getSuperclass().getName().equals(JAXB_PROVIDER_NAME)) continue;
            return pi.getProvider();
        }
        return null;
    }

    static {
        SHARED_FACTORY.setProviders(new BinaryDataProvider(), new SourceProvider(), new DataSourceProvider(), new FormEncodingProvider(), new PrimitiveTextProvider(), new MultipartProvider(), new WebApplicationExceptionMapper(), new WadlGenerator());
    }

    static class LegacyParamConverter<T>
    implements ParamConverter<T> {
        private ParameterHandler<T> handler;

        public LegacyParamConverter(ParameterHandler<T> handler) {
            this.handler = handler;
        }

        public T fromString(String value) throws IllegalArgumentException {
            return this.handler.fromString(value);
        }

        public String toString(Object value) throws IllegalArgumentException {
            return null;
        }

        ParameterHandler<T> getHandler() {
            return this.handler;
        }
    }

    private static class LegacyParamConverterProvider
    implements ParamConverterProvider {
        private List<ProviderInfo<ParameterHandler<?>>> paramHandlers = new ArrayList(1);

        private LegacyParamConverterProvider() {
        }

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            LinkedList candidates = new LinkedList();
            for (ProviderInfo<ParameterHandler<?>> em : this.paramHandlers) {
                ProviderFactory.handleMapper(candidates, em, rawType, null, ParameterHandler.class, true);
            }
            if (candidates.size() == 0) {
                return null;
            }
            Collections.sort(candidates, new ClassComparator());
            return new LegacyParamConverter((ParameterHandler)candidates.get(0));
        }

        public void clear() {
            this.paramHandlers.clear();
        }

        public void add(Object o, Bus bus) {
            this.paramHandlers.add(new ProviderInfo<ParameterHandler>((ParameterHandler)o, bus));
        }
    }

    private class MethodConfigurable
    implements Configurable {
        private OperationResourceInfo ori;
        private String nameBinding;
        private boolean bindingSet;

        public MethodConfigurable(OperationResourceInfo ori) {
            this.ori = ori;
            this.nameBinding = ProviderFactory.DEFAULT_FILTER_NAME_BINDING + ori.getClassResourceInfo().getServiceClass().getName() + "." + ori.getMethodToInvoke().toString() + ":dynamic";
        }

        public Configurable register(Object provider) {
            return this.register(provider, AnnotationUtils.getBindingPriority(provider.getClass()));
        }

        public Configurable register(Object provider, int bindingPriority) {
            return this.doRegister(provider, bindingPriority, FILTER_INTERCEPTOR_CLASSES);
        }

        public <T> Configurable register(Object provider, Class<? super T> ... contracts) {
            return this.register(provider, 7000, contracts);
        }

        public <T> Configurable register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
            return this.doRegister(provider, bindingPriority, contracts);
        }

        public Configurable register(Class<?> providerClass) {
            return this.register(providerClass, AnnotationUtils.getBindingPriority(providerClass));
        }

        public Configurable register(Class<?> providerClass, int bindingPriority) {
            return this.doRegister(this.createProvider(providerClass), bindingPriority, FILTER_INTERCEPTOR_CLASSES);
        }

        public <T> Configurable register(Class<T> providerClass, Class<? super T> ... contracts) {
            return this.register(providerClass, 7000, contracts);
        }

        public <T> Configurable register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
            return this.doRegister(this.createProvider(providerClass), bindingPriority, contracts);
        }

        private Configurable doRegister(Object provider, int bindingPriority, Class<?> ... contracts) {
            if (provider instanceof Feature) {
                ((Feature)provider).configure((Configurable)this);
                return this;
            }
            boolean setIsNeeded = false;
            for (Class<?> contract : contracts) {
                if (contract == ContainerRequestFilter.class && provider instanceof ContainerRequestFilter) {
                    if (ProviderFactory.isPrematching(provider.getClass())) {
                        this.addToInterceptors(ProviderFactory.this.preMatchContainerRequestFilters, provider, bindingPriority, true);
                    } else {
                        ProviderFactory.this.postMatchContainerRequestFilters = this.addToPostMatching(ProviderFactory.this.postMatchContainerRequestFilters, provider, bindingPriority, true);
                        setIsNeeded = true;
                    }
                }
                if (contract == ContainerResponseFilter.class && provider instanceof ContainerResponseFilter) {
                    ProviderFactory.this.postMatchContainerResponseFilters = this.addToPostMatching(ProviderFactory.this.postMatchContainerResponseFilters, provider, bindingPriority, false);
                    setIsNeeded = true;
                }
                if (contract == ReaderInterceptor.class && provider instanceof ReaderInterceptor) {
                    this.addToInterceptors(ProviderFactory.this.readerInterceptors, provider, bindingPriority, true);
                }
                if (contract != WriterInterceptor.class || !(provider instanceof WriterInterceptor)) continue;
                this.addToInterceptors(ProviderFactory.this.writerInterceptors, provider, bindingPriority, false);
            }
            if (setIsNeeded && !this.bindingSet) {
                this.ori.addNameBindings(Collections.singletonList(this.nameBinding));
                this.bindingSet = true;
            }
            return this;
        }

        private <T> void addToInterceptors(List<ProviderInfo<T>> providers, Object provider, int priority, boolean asc) {
            int size = providers.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    int providerPriority = AnnotationUtils.getBindingPriority(providers.get(i).getProvider().getClass());
                    if (asc) {
                        if (priority >= providerPriority && i + 1 != size) continue;
                        int index = priority < providerPriority ? i : i + 1;
                        providers.add(index, this.newProvider(provider));
                    } else {
                        if (priority <= providerPriority && i + 1 != size) continue;
                        int index = priority > providerPriority ? i : i + 1;
                        providers.add(index, this.newProvider(provider));
                    }
                    break;
                }
            } else {
                providers.add(this.newProvider(provider));
            }
        }

        private <T> ProviderInfo<T> newProvider(T provider) {
            ProviderInfo<T> newProvider = new ProviderInfo<T>(provider, ProviderFactory.this.bus);
            ProviderFactory.this.injectContextProxiesIntoProvider(newProvider);
            return newProvider;
        }

        private <T> Map<NameKey, ProviderInfo<T>> addToPostMatching(Map<NameKey, ProviderInfo<T>> map, Object provider, int priority, boolean asc) {
            LinkedHashMap<NameKey, ProviderInfo<T>> newMap = new LinkedHashMap<NameKey, ProviderInfo<T>>();
            Iterator<Map.Entry<NameKey, ProviderInfo<T>>> it = map.entrySet().iterator();
            if (it.hasNext()) {
                boolean added = false;
                while (it.hasNext()) {
                    Map.Entry<NameKey, ProviderInfo<T>> entry = it.next();
                    int providerPriority = entry.getKey().getPriority();
                    if (!(added || !asc || priority >= providerPriority && it.hasNext())) {
                        this.addNewProvider(newMap, entry, provider, priority, providerPriority >= priority);
                        added = true;
                        continue;
                    }
                    if (!(added || asc || priority <= providerPriority && it.hasNext())) {
                        this.addNewProvider(newMap, entry, provider, priority, priority > providerPriority);
                        added = true;
                        continue;
                    }
                    newMap.put(entry.getKey(), entry.getValue());
                }
            } else {
                newMap.put(new NameKey(this.nameBinding, priority), this.newProvider(provider));
            }
            return newMap;
        }

        private <T> void addNewProvider(Map<NameKey, ProviderInfo<T>> newMap, Map.Entry<NameKey, ProviderInfo<T>> entry, Object provider, int priority, boolean first) {
            if (first) {
                newMap.put(new NameKey(this.nameBinding, priority), this.newProvider(provider));
                newMap.put(entry.getKey(), entry.getValue());
            } else {
                newMap.put(entry.getKey(), entry.getValue());
                newMap.put(new NameKey(this.nameBinding, priority), this.newProvider(provider));
            }
        }

        public Collection<Feature> getFeatures() {
            return null;
        }

        public Set<Class<?>> getProviderClasses() {
            return null;
        }

        public Set<Object> getProviderInstances() {
            return null;
        }

        public Map<String, Object> getProperties() {
            return null;
        }

        public Object getProperty(String name) {
            return null;
        }

        public Configurable setProperties(Map<String, ?> properties) {
            return null;
        }

        public Configurable setProperty(String name, Object value) {
            return null;
        }

        private Object createProvider(Class<?> cls) {
            try {
                return cls.newInstance();
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class NameKey {
        private String name;
        private int bindingPriority;

        public NameKey(String name, int priority) {
            this.name = name;
            this.bindingPriority = priority;
        }

        public String getName() {
            return this.name;
        }

        public int getPriority() {
            return this.bindingPriority;
        }
    }

    static class ContextResolverProxy<T>
    implements ContextResolver<T> {
        private List<ContextResolver<T>> candidates;

        public ContextResolverProxy(List<ContextResolver<T>> candidates) {
            this.candidates = candidates;
        }

        public T getContext(Class<?> cls) {
            for (ContextResolver<T> resolver : this.candidates) {
                Object context = resolver.getContext(cls);
                if (context == null) continue;
                return (T)context;
            }
            return null;
        }

        public List<ContextResolver<T>> getResolvers() {
            return this.candidates;
        }
    }

    private static abstract class AbstactBindingPriorityComparator
    implements Comparator<ProviderInfo<?>> {
        private boolean ascending;

        protected AbstactBindingPriorityComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(ProviderInfo<?> p1, ProviderInfo<?> p2) {
            Integer b1Value = this.getBindingPriorityValue(p1);
            Integer b2Value = this.getBindingPriorityValue(p2);
            int result = b1Value.compareTo(b2Value);
            return this.ascending ? result : result * -1;
        }

        private int getBindingPriorityValue(ProviderInfo<?> p) {
            return AnnotationUtils.getBindingPriority(p.getProvider().getClass());
        }
    }

    private static class BindingPriorityComparator
    extends AbstactBindingPriorityComparator {
        public BindingPriorityComparator(boolean ascending) {
            super(ascending);
        }
    }

    private static class PostMatchFilterComparator
    extends BindingPriorityComparator {
        public PostMatchFilterComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(ProviderInfo<?> p1, ProviderInfo<?> p2) {
            int result = super.compare(p1, p2);
            if (result == 0) {
                Integer namesSize1 = AnnotationUtils.getNameBindings(p1.getProvider().getClass().getAnnotations()).size();
                Integer namesSize2 = AnnotationUtils.getNameBindings(p2.getProvider().getClass().getAnnotations()).size();
                result = namesSize1.compareTo(namesSize2) * -1;
            }
            return result;
        }
    }

    private static class ClassComparator
    implements Comparator<Object> {
        private Class<?> expectedCls;

        public ClassComparator() {
        }

        public ClassComparator(Class<?> expectedCls) {
            this.expectedCls = expectedCls;
        }

        @Override
        public int compare(Object em1, Object em2) {
            return ProviderFactory.compareClasses(this.expectedCls, em1, em2);
        }
    }

    private static class ContextResolverComparator
    implements Comparator<ProviderInfo<ContextResolver<?>>> {
        private ContextResolverComparator() {
        }

        @Override
        public int compare(ProviderInfo<ContextResolver<?>> p1, ProviderInfo<ContextResolver<?>> p2) {
            ContextResolver<?> e1 = p1.getProvider();
            ContextResolver<?> e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e1.getClass().getAnnotation(Produces.class)), "qs");
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e2.getClass().getAnnotation(Produces.class)), "qs");
            return JAXRSUtils.compareSortedMediaTypes(types1, types2, "qs");
        }
    }

    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter<?>>> {
        private MessageBodyWriterComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter<?>> p1, ProviderInfo<MessageBodyWriter<?>> p2) {
            MessageBodyWriter<?> e1 = p1.getProvider();
            MessageBodyWriter<?> e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e1), "qs");
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e2), "qs");
            return JAXRSUtils.compareSortedMediaTypes(types1, types2, "qs");
        }
    }

    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader<?>>> {
        private MessageBodyReaderComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader<?>> p1, ProviderInfo<MessageBodyReader<?>> p2) {
            MessageBodyReader<?> e1 = p1.getProvider();
            MessageBodyReader<?> e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.getProviderConsumeTypes(e1);
            types1 = JAXRSUtils.sortMediaTypes(types1, null);
            List<MediaType> types2 = JAXRSUtils.getProviderConsumeTypes(e2);
            types2 = JAXRSUtils.sortMediaTypes(types2, null);
            return JAXRSUtils.compareSortedMediaTypes(types1, types2, null);
        }
    }
}

