/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.namespace.Constants;
import org.apache.axis2.wsdl.HTTPHeaderMessage;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.SOAPModuleMessage;

public class WSDLSerializationUtil {
    public static String getPrefix(String namespace, Map nameSpaceMap) {
        Iterator keys = nameSpaceMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!nameSpaceMap.get(key).equals(namespace)) continue;
            return key;
        }
        return null;
    }

    public static String getElementName(AxisMessage axisMessage, Map nameSpaceMap) {
        QName elementQName = axisMessage.getElementQName();
        if (elementQName == null) {
            return "#none";
        }
        if (Constants.XSD_ANY.equals(elementQName)) {
            return "#any";
        }
        String prefix = WSDLSerializationUtil.getPrefix(elementQName.getNamespaceURI(), nameSpaceMap);
        return prefix + ":" + elementQName.getLocalPart();
    }

    public static void addSOAPHeaderElements(OMFactory omFactory, ArrayList list, OMNamespace wsoap, OMElement element, Map nameSpaceMap) {
        for (int i = 0; i < list.size(); ++i) {
            SOAPHeaderMessage soapHeaderMessage = (SOAPHeaderMessage)list.get(i);
            OMElement soapHeaderElement = omFactory.createOMElement("header", wsoap);
            QName qName = soapHeaderMessage.getElement();
            soapHeaderElement.addAttribute(omFactory.createOMAttribute("element", null, WSDLSerializationUtil.getPrefix(qName.getNamespaceURI(), nameSpaceMap) + ":" + qName.getLocalPart()));
            soapHeaderElement.addAttribute(omFactory.createOMAttribute("mustUnderstand", null, new Boolean(soapHeaderMessage.isMustUnderstand()).toString()));
            soapHeaderElement.addAttribute(omFactory.createOMAttribute("required", null, new Boolean(soapHeaderMessage.isRequired()).toString()));
            element.addChild((OMNode)soapHeaderElement);
        }
    }

    public static void addSOAPModuleElements(OMFactory omFactory, ArrayList list, OMNamespace wsoap, OMElement element) {
        for (int i = 0; i < list.size(); ++i) {
            SOAPModuleMessage soapModuleMessage = (SOAPModuleMessage)list.get(i);
            OMElement soapModuleElement = omFactory.createOMElement("module", wsoap);
            soapModuleElement.addAttribute(omFactory.createOMAttribute("ref", null, soapModuleMessage.getUri()));
            element.addChild((OMNode)soapModuleElement);
        }
    }

    public static void addHTTPHeaderElements(OMFactory omFactory, ArrayList list, OMNamespace whttp, OMElement element, Map nameSpaceMap) {
        for (int i = 0; i < list.size(); ++i) {
            HTTPHeaderMessage httpHeaderMessage = (HTTPHeaderMessage)list.get(i);
            OMElement httpHeaderElement = omFactory.createOMElement("header", whttp);
            httpHeaderElement.addAttribute(omFactory.createOMAttribute("name", null, httpHeaderMessage.getName()));
            QName qName = httpHeaderMessage.getqName();
            httpHeaderElement.addAttribute(omFactory.createOMAttribute("type", null, WSDLSerializationUtil.getPrefix(qName.getNamespaceURI(), nameSpaceMap) + ":" + qName.getLocalPart()));
            httpHeaderElement.addAttribute(omFactory.createOMAttribute("required", null, new Boolean(httpHeaderMessage.isRequired()).toString()));
            element.addChild((OMNode)httpHeaderElement);
        }
    }

    public static OMElement generateSOAP11Binding(OMFactory fac, AxisService axisService, OMNamespace wsdl, OMNamespace wsoap, OMNamespace tns) {
        OMElement binding = fac.createOMElement("binding", wsdl);
        binding.addAttribute(fac.createOMAttribute("name", null, axisService.getName() + "SOAP11Binding"));
        binding.addAttribute(fac.createOMAttribute("interface", null, tns.getPrefix() + ":" + "ServiceInterface"));
        binding.addAttribute(fac.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/soap"));
        binding.addAttribute(fac.createOMAttribute("version", wsoap, "1.1"));
        WSDLSerializationUtil.generateDefaultSOAPBindingOperations(axisService, fac, binding, wsdl, tns, wsoap);
        return binding;
    }

    public static OMElement generateSOAP12Binding(OMFactory fac, AxisService axisService, OMNamespace wsdl, OMNamespace wsoap, OMNamespace tns) {
        OMElement binding = fac.createOMElement("binding", wsdl);
        binding.addAttribute(fac.createOMAttribute("name", null, axisService.getName() + "SOAP12Binding"));
        binding.addAttribute(fac.createOMAttribute("interface", null, tns.getPrefix() + ":" + "ServiceInterface"));
        binding.addAttribute(fac.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/soap"));
        binding.addAttribute(fac.createOMAttribute("version", wsoap, "1.2"));
        WSDLSerializationUtil.generateDefaultSOAPBindingOperations(axisService, fac, binding, wsdl, tns, wsoap);
        return binding;
    }

    public static OMElement generateHTTPBinding(OMFactory fac, AxisService axisService, OMNamespace wsdl, OMNamespace whttp, OMNamespace tns) {
        OMElement binding = fac.createOMElement("binding", wsdl);
        binding.addAttribute(fac.createOMAttribute("name", null, axisService.getName() + "HttpBinding"));
        binding.addAttribute(fac.createOMAttribute("interface", null, tns.getPrefix() + ":" + "ServiceInterface"));
        binding.addAttribute(fac.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/http"));
        Iterator iterator = axisService.getChildren();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            OMElement opElement = fac.createOMElement("operation", wsdl);
            binding.addChild((OMNode)opElement);
            String name = axisOperation.getName().getLocalPart();
            opElement.addAttribute(fac.createOMAttribute("ref", null, tns.getPrefix() + ":" + name));
            opElement.addAttribute(fac.createOMAttribute("location", whttp, name));
        }
        return binding;
    }

    private static void generateDefaultSOAPBindingOperations(AxisService axisService, OMFactory omFactory, OMElement binding, OMNamespace wsdl, OMNamespace tns, OMNamespace wsoap) {
        Iterator iterator = axisService.getChildren();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            OMElement opElement = omFactory.createOMElement("operation", wsdl);
            binding.addChild((OMNode)opElement);
            String name = axisOperation.getName().getLocalPart();
            opElement.addAttribute(omFactory.createOMAttribute("ref", null, tns.getPrefix() + ":" + name));
            opElement.addAttribute(omFactory.createOMAttribute("action", wsoap, axisOperation.getInputAction()));
        }
    }

    public static OMElement generateServiceElement(OMFactory omFactory, OMNamespace wsdl, OMNamespace tns, AxisService axisService) throws AxisFault {
        String[] eprs = axisService.getEPRs();
        if (eprs == null) {
            eprs = new String[]{axisService.getName()};
        }
        OMElement serviceElement = null;
        for (int i = 0; i < eprs.length; ++i) {
            serviceElement = omFactory.createOMElement("service", wsdl);
            serviceElement.addAttribute(omFactory.createOMAttribute("name", null, axisService.getName()));
            serviceElement.addAttribute(omFactory.createOMAttribute("interface", null, tns.getPrefix() + ":" + "ServiceInterface"));
            OMElement soap11EndpointElement = omFactory.createOMElement("endpoint", wsdl);
            soap11EndpointElement.addAttribute(omFactory.createOMAttribute("name", null, "SOAP11Endpoint"));
            soap11EndpointElement.addAttribute(omFactory.createOMAttribute("binding", null, tns.getPrefix() + ":" + axisService.getName() + "SOAP11Binding"));
            soap11EndpointElement.addAttribute(omFactory.createOMAttribute("address", null, eprs[i]));
            serviceElement.addChild((OMNode)soap11EndpointElement);
            OMElement soap12EndpointElement = omFactory.createOMElement("endpoint", wsdl);
            soap12EndpointElement.addAttribute(omFactory.createOMAttribute("name", null, "SOAP12Endpoint"));
            soap12EndpointElement.addAttribute(omFactory.createOMAttribute("binding", null, tns.getPrefix() + ":" + axisService.getName() + "SOAP12Binding"));
            soap12EndpointElement.addAttribute(omFactory.createOMAttribute("address", null, eprs[i]));
            serviceElement.addChild((OMNode)soap12EndpointElement);
            OMElement httpEndpointElement = omFactory.createOMElement("endpoint", wsdl);
            httpEndpointElement.addAttribute(omFactory.createOMAttribute("name", null, "HTTPEndpoint"));
            httpEndpointElement.addAttribute(omFactory.createOMAttribute("binding", null, tns.getPrefix() + ":" + axisService.getName() + "HttpBinding"));
            httpEndpointElement.addAttribute(omFactory.createOMAttribute("address", null, eprs[i]));
            serviceElement.addChild((OMNode)httpEndpointElement);
        }
        return serviceElement;
    }

    public static void populateNamespaces(OMElement descriptionElement, Map nameSpaceMap) {
        if (nameSpaceMap != null) {
            Iterator keys = nameSpaceMap.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if ("".equals(key)) {
                    descriptionElement.declareDefaultNamespace((String)nameSpaceMap.get(key));
                    continue;
                }
                descriptionElement.declareNamespace((String)nameSpaceMap.get(key), key);
            }
        }
    }

    public static void addWSAWActionAttribute(OMElement element, String action) {
        if (action == null || action.length() == 0) {
            return;
        }
        OMNamespace namespace = element.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
        element.addAttribute("Action", action, namespace);
    }

    public static void addExtensionElement(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement(name, soapNameSpace);
        element.addChild((OMNode)extElement);
        extElement.addAttribute(att1Name, att1Value, null);
    }

    public static void addWSAddressingToBinding(String addressingFlag, OMFactory omFactory, OMElement bindingElement) {
        if (addressingFlag.equals("optional")) {
            OMNamespace wsawNamespace = omFactory.createOMNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
            WSDLSerializationUtil.addExtensionElement(omFactory, bindingElement, "UsingAddressing", "required", "true", wsawNamespace);
        } else if (addressingFlag.equals("required")) {
            OMNamespace wsawNamespace = omFactory.createOMNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
            WSDLSerializationUtil.addExtensionElement(omFactory, bindingElement, "UsingAddressing", "required", "true", wsawNamespace);
        }
    }
}

