/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectStateUtils {
    private static final Log log = LogFactory.getLog((Class)ObjectStateUtils.class);
    public static boolean EMPTY_OBJECT = false;
    public static boolean ACTIVE_OBJECT = true;
    public static String LAST_ENTRY = "LAST_ENTRY";
    public static String EMPTY_MARKER = "EMPTY_MARKER";
    public static String NULL_OBJECT = "NULL_OBJECT";
    public static final String UNSUPPORTED_SUID = "Serialization version ID is not supported.";
    public static final String UNSUPPORTED_REVID = "Revision ID is not supported.";
    public static final String OBJ_SAVE_PROBLEM = "The object could not be saved to the output stream.  The object may or may not be important for processing the message when it is restored. Look at how the object is to be used during message processing.";
    public static final String OBJ_RESTORE_PROBLEM = "The object could not be restored from the input stream.  The object may or may not be important for processing the message when it is restored. Look at how the object is to be used during message processing.";
    public static Hashtable NotSerializableList = new Hashtable();

    public static void writeString(ObjectOutput out, String str, String desc) throws IOException {
        if (str != null) {
            String str_desc = str.getClass().getName();
            out.writeUTF(str_desc);
            out.writeBoolean(ACTIVE_OBJECT);
            int numberStringSections = 1;
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            outBuffer.write(str.getBytes(), 0, str.length());
            out.writeInt(numberStringSections);
            int outSize = outBuffer.size();
            out.writeInt(outSize);
            out.write(outBuffer.toByteArray());
            outBuffer.close();
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:writeString(): ACTIVE string: str_desc [" + str_desc + "]    string [" + str + "]   desc [" + desc + "]   output byte buffer size [" + outSize + "]"));
                log.trace((Object)("ObjectStateUtils:writeString(): ACTIVE string: outBuffer [" + outBuffer.toString() + "]"));
            }
        } else {
            out.writeUTF(desc);
            out.writeBoolean(EMPTY_OBJECT);
        }
    }

    public static String readString(ObjectInput in, String desc) throws IOException, ClassNotFoundException {
        String str = null;
        String str_desc = in.readUTF();
        boolean isActive = in.readBoolean();
        if (isActive == ACTIVE_OBJECT) {
            int numberStringSections = in.readInt();
            if (numberStringSections > 1) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:readString(): ACTIVE string: the [" + desc + "] string with saved description [" + str_desc + "] has [" + numberStringSections + "] sections"));
                }
                StringBuffer sbuff = new StringBuffer();
                for (int k = 0; k < numberStringSections; ++k) {
                    String section = in.readUTF();
                    sbuff.append(section);
                }
                str = sbuff.toString();
            } else {
                int bufSize = in.readInt();
                byte[] buffer = new byte[bufSize];
                int bytesRead = in.read(buffer, 0, bufSize);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:readString(): ACTIVE string: str_desc [" + str_desc + "]    bufSize [" + bufSize + "]   bytesRead [" + bytesRead + "]   desc [" + desc + "]"));
                }
                if (bytesRead > 0) {
                    str = new String(buffer);
                }
            }
        }
        String value = "null";
        if (str != null) {
            value = str;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:readString(): [" + desc + "]  returning  [" + value + "]  for  saved [" + str_desc + "]"));
        }
        return str;
    }

    public static void writeObject(ObjectOutput out, Object obj, String desc) throws IOException {
        IOException returned_exception = null;
        if (obj != null) {
            ObjectOutputStream test_objOut;
            ByteArrayOutputStream test_outBuffer;
            block13: {
                boolean canWrite;
                String objClassName;
                block12: {
                    objClassName = obj.getClass().getName();
                    String fullDesc = desc + ":" + objClassName;
                    out.writeUTF(fullDesc);
                    out.writeBoolean(ACTIVE_OBJECT);
                    test_outBuffer = new ByteArrayOutputStream();
                    test_objOut = new ObjectOutputStream(test_outBuffer);
                    canWrite = false;
                    try {
                        test_objOut.writeObject(obj);
                        canWrite = true;
                    }
                    catch (NotSerializableException nse2) {
                        returned_exception = nse2;
                        ObjectStateUtils.traceNotSerializable(obj, nse2, desc, "ObjectStateUtils.writeObject()", OBJ_SAVE_PROBLEM);
                    }
                    catch (IOException exc2) {
                        returned_exception = exc2;
                        if (!log.isTraceEnabled()) break block12;
                        log.trace((Object)("ObjectStateUtils:writeObject(): object[" + obj.getClass().getName() + "]  ***Exception***  [" + exc2.getClass().getName() + " : " + exc2.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)exc2);
                    }
                }
                if (canWrite) {
                    try {
                        out.writeObject(obj);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("ObjectStateUtils:writeObject(): Object [" + objClassName + "]  desc [" + desc + "]"));
                        }
                    }
                    catch (NotSerializableException nse) {
                        returned_exception = nse;
                        ObjectStateUtils.traceNotSerializable(obj, nse, desc, "ObjectStateUtils.writeObject()", OBJ_SAVE_PROBLEM);
                    }
                    catch (IOException exc) {
                        returned_exception = exc;
                        if (!log.isTraceEnabled()) break block13;
                        log.trace((Object)("ObjectStateUtils:writeObject(): object[" + obj.getClass().getName() + "]  ***Exception***  [" + exc.getClass().getName() + " : " + exc.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)exc);
                    }
                }
            }
            out.writeObject(LAST_ENTRY);
            test_outBuffer.close();
            test_objOut.close();
            if (returned_exception != null) {
                throw returned_exception;
            }
        } else {
            out.writeUTF(desc);
            out.writeBoolean(EMPTY_OBJECT);
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:writeObject(): EMPTY Object [" + desc + "]  "));
            }
        }
    }

    public static Object readObject(ObjectInput in, String desc) throws IOException, ClassNotFoundException {
        Object obj = null;
        String str_desc = in.readUTF();
        boolean isActive = in.readBoolean();
        if (isActive == ACTIVE_OBJECT) {
            String tmp;
            boolean done = false;
            obj = in.readObject();
            if (obj != null && obj instanceof String && (tmp = (String)obj).equalsIgnoreCase(LAST_ENTRY)) {
                done = true;
                obj = null;
            }
            if (!done) {
                String tmp2;
                Object obj2 = in.readObject();
                boolean isConsistent = false;
                if (obj2 != null && obj2 instanceof String && (tmp2 = (String)obj2).equalsIgnoreCase(LAST_ENTRY)) {
                    isConsistent = true;
                }
                if (!isConsistent && log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:readObject(): Inconsistent results reading the stream for [" + desc + "]  for saved [" + str_desc + "]"));
                }
            }
        }
        String value = "null";
        if (obj != null) {
            value = "(" + str_desc + ")" + ":" + obj.getClass().getName();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:readObject(): [" + desc + "]  returning  [" + value + "]   for saved [" + str_desc + "]"));
        }
        return obj;
    }

    public static void writeArrayList(ObjectOutput out, ArrayList al, String desc) throws IOException {
        out.writeUTF(desc);
        if (al == null || al.isEmpty()) {
            out.writeBoolean(EMPTY_OBJECT);
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:writeArrayList(): EMPTY List [" + desc + "]  "));
            }
        } else {
            out.writeBoolean(ACTIVE_OBJECT);
            int listSize = al.size();
            int savedListSize = 0;
            out.writeInt(listSize);
            ByteArrayOutputStream test_outBuffer = new ByteArrayOutputStream();
            ObjectOutputStream test_objOut = new ObjectOutputStream(test_outBuffer);
            Iterator i = al.iterator();
            while (i.hasNext()) {
                block14: {
                    boolean canWrite;
                    Object obj;
                    block13: {
                        obj = i.next();
                        String tmpClassName = obj.getClass().getName();
                        canWrite = false;
                        try {
                            test_objOut.writeObject(obj);
                            canWrite = true;
                        }
                        catch (NotSerializableException nse2) {
                            ObjectStateUtils.traceNotSerializable(obj, nse2, desc, "ObjectStateUtils.writeArrayList()", OBJ_SAVE_PROBLEM);
                        }
                        catch (Exception exc) {
                            if (!log.isTraceEnabled()) break block13;
                            log.trace((Object)("ObjectStateUtils:writeArrayList(): object[" + obj.getClass().getName() + "]  ***Exception***  [" + exc.getClass().getName() + " : " + exc.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)exc);
                        }
                    }
                    if (canWrite) {
                        try {
                            out.writeObject(obj);
                            ++savedListSize;
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("ObjectStateUtils:writeArrayList(): " + desc + " [" + obj.getClass().getName() + "]"));
                            }
                        }
                        catch (NotSerializableException nse) {
                            ObjectStateUtils.traceNotSerializable(obj, nse, desc, "ObjectStateUtils.writeArrayList()", OBJ_SAVE_PROBLEM);
                        }
                        catch (Exception ex) {
                            if (!log.isTraceEnabled()) break block14;
                            log.trace((Object)("ObjectStateUtils:writeArrayList(): " + desc + " [" + obj.getClass().getName() + "]  ***Exception***  [" + ex.getClass().getName() + " : " + ex.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)ex);
                        }
                    }
                }
                test_objOut.reset();
            }
            out.writeObject(LAST_ENTRY);
            out.writeInt(++savedListSize);
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:writeArrayList(): List [" + desc + "]   members saved [" + savedListSize + "]"));
            }
            test_outBuffer.close();
            test_objOut.close();
        }
    }

    public static ArrayList readArrayList(ObjectInput in, String desc) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        String str_desc = in.readUTF();
        boolean isActive = in.readBoolean();
        if (isActive == ACTIVE_OBJECT) {
            int expectedListSize = in.readInt();
            boolean keepGoing = true;
            int count = 0;
            Object obj = null;
            while (keepGoing) {
                try {
                    obj = in.readObject();
                    ++count;
                    if (obj != null) {
                        String tmp;
                        if (obj instanceof String && (tmp = (String)obj).equalsIgnoreCase(LAST_ENTRY)) {
                            keepGoing = false;
                        }
                        if (!keepGoing) continue;
                        String tmpClassName = obj.getClass().getName();
                        list.add(obj);
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  index [" + count + "]  object [" + tmpClassName + "]   for saved [" + str_desc + "]"));
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  object index [" + count + "] ***Unexpected null object***   for saved [" + str_desc + "]"));
                    }
                    keepGoing = false;
                }
                catch (Exception ex) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  object index [" + count + "]   for saved [" + str_desc + "]  ***Exception***  [" + ex.getClass().getName() + " : " + ex.getMessage() + "]  " + OBJ_RESTORE_PROBLEM), (Throwable)ex);
                    }
                    keepGoing = false;
                }
            }
            int adjustedNumberEntries = in.readInt();
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:readArrayList(): adjusted number of entries [" + adjustedNumberEntries + "]     for saved [" + str_desc + "] "));
            }
            if (list.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  returning  [null]  for saved [" + str_desc + "]"));
                }
                return null;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  returning  [listsize=" + list.size() + "]  for saved [" + str_desc + "]"));
            }
            return list;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  returning  [null]    for saved [" + str_desc + "]"));
        }
        return null;
    }

    public static void writeHashMap(ObjectOutput out, HashMap map, String desc) throws IOException {
        out.writeUTF(desc);
        if (map == null || map.isEmpty()) {
            out.writeBoolean(EMPTY_OBJECT);
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:writeHashMap(): EMPTY map [" + desc + "]  "));
            }
        } else {
            out.writeBoolean(ACTIVE_OBJECT);
            int listSize = map.size();
            out.writeInt(listSize);
            int savedListSize = 0;
            ByteArrayOutputStream pair_outBuffer = new ByteArrayOutputStream();
            ObjectOutputStream pair_objOut = new ObjectOutputStream(pair_outBuffer);
            Set keyset = map.keySet();
            Iterator i = keyset.iterator();
            while (i.hasNext()) {
                block25: {
                    boolean canWritePair;
                    Object value;
                    Object key;
                    block24: {
                        key = i.next();
                        value = map.get(key);
                        canWritePair = false;
                        try {
                            pair_objOut.writeObject(key);
                            try {
                                if (value == null) {
                                    pair_objOut.writeObject(NULL_OBJECT);
                                } else {
                                    pair_objOut.writeObject(value);
                                }
                                canWritePair = true;
                            }
                            catch (NotSerializableException nse) {
                                ObjectStateUtils.traceNotSerializable(value, nse, desc, "ObjectStateUtils.writeHashMap() map value", OBJ_SAVE_PROBLEM);
                            }
                            catch (Exception ex) {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("ObjectStateUtils:writeHashMap(): map value [" + value.getClass().getName() + "]  ***Exception***  [" + ex.getClass().getName() + " : " + ex.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)ex);
                                }
                            }
                        }
                        catch (NotSerializableException nse2) {
                            ObjectStateUtils.traceNotSerializable(key, nse2, desc, "ObjectStateUtils.writeHashMap() map key", OBJ_SAVE_PROBLEM);
                        }
                        catch (Exception exc) {
                            if (!log.isTraceEnabled()) break block24;
                            log.trace((Object)("ObjectStateUtils:writeHashMap(): map key [" + key.getClass().getName() + "]  ***Exception***  [" + exc.getClass().getName() + " : " + exc.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)exc);
                        }
                    }
                    if (canWritePair) {
                        try {
                            out.writeObject(key);
                            try {
                                if (value == null) {
                                    out.writeObject(NULL_OBJECT);
                                } else {
                                    out.writeObject(value);
                                }
                            }
                            catch (NotSerializableException nse3) {
                                ObjectStateUtils.traceNotSerializable(value, nse3, desc, "ObjectStateUtils.writeHashMap() map value output error", OBJ_SAVE_PROBLEM);
                            }
                            catch (Exception excp) {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("ObjectStateUtils:writeHashMap(): output error: map value [" + value.getClass().getName() + "]  ***Exception***  [" + excp.getClass().getName() + " : " + excp.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)excp);
                                }
                                out.writeObject(EMPTY_MARKER);
                            }
                            ++savedListSize;
                        }
                        catch (NotSerializableException nse4) {
                            ObjectStateUtils.traceNotSerializable(key, nse4, desc, "ObjectStateUtils.writeHashMap() map key output error", OBJ_SAVE_PROBLEM);
                        }
                        catch (Exception ex) {
                            if (!log.isTraceEnabled()) break block25;
                            log.trace((Object)("ObjectStateUtils:writeHashMap(): output error: map key [" + key.getClass().getName() + "]  ***Exception***  [" + ex.getClass().getName() + " : " + ex.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)ex);
                        }
                    }
                }
                pair_objOut.reset();
            }
            out.writeObject(LAST_ENTRY);
            out.writeInt(++savedListSize);
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:writeHashMap(): map [" + desc + "]   members saved [" + savedListSize + "]"));
            }
            pair_outBuffer.close();
            pair_objOut.close();
        }
    }

    public static HashMap readHashMap(ObjectInput in, String desc) throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        String str_desc = in.readUTF();
        boolean isActive = in.readBoolean();
        if (isActive == ACTIVE_OBJECT) {
            int expectedListSize = in.readInt();
            int obtainedListSize = 0;
            boolean keepGoing = true;
            while (keepGoing) {
                Object key = null;
                Object value = null;
                try {
                    String tmpkey;
                    key = in.readObject();
                    if (key instanceof String && (tmpkey = (String)key).equalsIgnoreCase(LAST_ENTRY)) {
                        keepGoing = false;
                        break;
                    }
                    value = in.readObject();
                    boolean keepPair = true;
                    if (value instanceof String) {
                        String tmpvalue = (String)value;
                        if (tmpvalue.equalsIgnoreCase(EMPTY_MARKER)) {
                            keepPair = false;
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("ObjectStateUtils:readHashMap(): [" + desc + "]  object pair index [" + obtainedListSize + "]  will be skipped because the value object is unavailable.    For saved [" + str_desc + "]"));
                            }
                        } else if (tmpvalue.equalsIgnoreCase(NULL_OBJECT)) {
                            value = null;
                        }
                    }
                    if (keepPair) {
                        map.put(key, value);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("ObjectStateUtils:readHashMap(): [" + desc + "]  object pair index [" + obtainedListSize + "]   for saved [" + str_desc + "]"));
                        }
                    }
                    ++obtainedListSize;
                }
                catch (Exception ex) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("ObjectStateUtils:readHashMap(): [" + desc + "]  object pair index [" + obtainedListSize + "]   for saved [" + str_desc + "] ***Exception***  [" + ex.getClass().getName() + " : " + ex.getMessage() + "]  " + OBJ_RESTORE_PROBLEM), (Throwable)ex);
                }
            }
            int savedListSize = in.readInt();
            if (map.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:readHashMap(): [" + desc + "]  returning  [null]  for saved [" + str_desc + "]"));
                }
                return null;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:readHashMap(): [" + desc + "]  returning  [mapsize=" + map.size() + "]    for saved [" + str_desc + "]"));
            }
            return map;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:readHashMap(): [" + desc + "]  returning  [null]    for saved [" + str_desc + "]"));
        }
        return null;
    }

    public static void writeLinkedList(ObjectOutput out, LinkedList objlist, String desc) throws IOException {
        out.writeUTF(desc);
        if (objlist == null || objlist.isEmpty()) {
            out.writeBoolean(EMPTY_OBJECT);
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:writeLinkedList(): EMPTY List [" + desc + "]  "));
            }
        } else {
            out.writeBoolean(ACTIVE_OBJECT);
            int listSize = objlist.size();
            int savedListSize = 0;
            out.writeInt(listSize);
            ByteArrayOutputStream test_outBuffer = new ByteArrayOutputStream();
            ObjectOutputStream test_objOut = new ObjectOutputStream(test_outBuffer);
            Iterator i = objlist.iterator();
            while (i.hasNext()) {
                block14: {
                    boolean canWrite;
                    Object obj;
                    block13: {
                        obj = i.next();
                        String tmpClassName = obj.getClass().getName();
                        canWrite = false;
                        try {
                            test_objOut.writeObject(obj);
                            canWrite = true;
                        }
                        catch (NotSerializableException nse2) {
                            ObjectStateUtils.traceNotSerializable(obj, nse2, desc, "ObjectStateUtils.writeLinkedList()", OBJ_SAVE_PROBLEM);
                        }
                        catch (Exception exc) {
                            if (!log.isTraceEnabled()) break block13;
                            log.trace((Object)("ObjectStateUtils:writeLinkedList(): object[" + obj.getClass().getName() + "]  ***Exception***  [" + exc.getClass().getName() + " : " + exc.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)exc);
                        }
                    }
                    if (canWrite) {
                        try {
                            out.writeObject(obj);
                            ++savedListSize;
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("ObjectStateUtils:writeLinkedList(): " + desc + " [" + obj.getClass().getName() + "]"));
                            }
                        }
                        catch (NotSerializableException nse) {
                            ObjectStateUtils.traceNotSerializable(obj, nse, desc, "ObjectStateUtils.writeLinkedList()", OBJ_SAVE_PROBLEM);
                        }
                        catch (Exception ex) {
                            if (!log.isTraceEnabled()) break block14;
                            log.trace((Object)("ObjectStateUtils:writeLinkedList(): " + desc + " [" + obj.getClass().getName() + "]  ***Exception***  [" + ex.getClass().getName() + " : " + ex.getMessage() + "] " + OBJ_SAVE_PROBLEM), (Throwable)ex);
                        }
                    }
                }
                test_objOut.reset();
            }
            out.writeObject(LAST_ENTRY);
            out.writeInt(++savedListSize);
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:writeLinkedList(): List [" + desc + "]   members saved [" + savedListSize + "]"));
            }
            test_outBuffer.close();
            test_objOut.close();
        }
    }

    public static LinkedList readLinkedList(ObjectInput in, String desc) throws IOException {
        LinkedList<Object> list = new LinkedList<Object>();
        String str_desc = in.readUTF();
        boolean isActive = in.readBoolean();
        if (isActive == ACTIVE_OBJECT) {
            int expectedListSize = in.readInt();
            boolean keepGoing = true;
            int count = 0;
            Object obj = null;
            while (keepGoing) {
                try {
                    obj = in.readObject();
                    ++count;
                    if (obj != null) {
                        String tmp;
                        if (obj instanceof String && (tmp = (String)obj).equalsIgnoreCase(LAST_ENTRY)) {
                            keepGoing = false;
                        }
                        if (!keepGoing) continue;
                        String tmpClassName = obj.getClass().getName();
                        list.add(obj);
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)("ObjectStateUtils:readLinkedList(): [" + desc + "]  index [" + count + "]  object [" + tmpClassName + "]   for saved [" + str_desc + "]"));
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("ObjectStateUtils:readLinkedList(): [" + desc + "]  object index [" + count + "] ***Unexpected null object***   for saved [" + str_desc + "]"));
                    }
                    keepGoing = false;
                }
                catch (Exception ex) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("ObjectStateUtils:readLinkedList(): [" + desc + "]  object index [" + count + "]   for saved [" + str_desc + "] ***Exception***  [" + ex.getClass().getName() + " : " + ex.getMessage() + "]  " + OBJ_RESTORE_PROBLEM), (Throwable)ex);
                    }
                    keepGoing = false;
                }
            }
            int adjustedNumberEntries = in.readInt();
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:readLinkedList(): adjusted number of entries [" + adjustedNumberEntries + "]     for saved [" + str_desc + "] "));
            }
            if (list.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:readLinkedList(): [" + desc + "]  returning  [null]  for saved [" + str_desc + "]"));
                }
                return null;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:readLinkedList(): [" + desc + "]  returning  [listsize=" + list.size() + "]   for saved [" + str_desc + "]"));
            }
            return list;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:readLinkedList(): [" + desc + "]  returning  [null]   for saved [" + str_desc + "]"));
        }
        return null;
    }

    public static AxisOperation findOperation(AxisConfiguration axisConfig, String opClassName, QName opQName) {
        HashMap services = axisConfig.getServices();
        Iterator its = services.values().iterator();
        while (its.hasNext()) {
            AxisService service = (AxisService)its.next();
            Iterator ito = service.getOperations();
            while (ito.hasNext()) {
                AxisOperation operation = (AxisOperation)ito.next();
                String tmpOpName = operation.getClass().getName();
                QName tmpOpQName = operation.getName();
                if (!tmpOpName.equals(opClassName) || !tmpOpQName.equals(opQName)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:findOperation(axisCfg): returning  [" + opClassName + "]   [" + opQName.toString() + "]"));
                }
                return operation;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findOperation(axisCfg): [" + opClassName + "]   [" + opQName.toString() + "]  returning  [null]"));
        }
        return null;
    }

    public static AxisOperation findOperation(AxisService service, String opClassName, QName opQName) {
        if (service == null) {
            return null;
        }
        Iterator ito = service.getOperations();
        while (ito.hasNext()) {
            AxisOperation operation = (AxisOperation)ito.next();
            String tmpOpName = operation.getClass().getName();
            QName tmpOpQName = operation.getName();
            if (!tmpOpName.equals(opClassName) || !tmpOpQName.equals(opQName)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findOperation(service): returning  [" + opClassName + "]   [" + opQName.toString() + "]"));
            }
            return operation;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findOperation(service): [" + opClassName + "]   [" + opQName.toString() + "]  returning  [null]"));
        }
        return null;
    }

    public static AxisService findService(AxisConfiguration axisConfig, String serviceClassName, String serviceName) {
        HashMap services = axisConfig.getServices();
        Iterator its = services.values().iterator();
        while (its.hasNext()) {
            AxisService service = (AxisService)its.next();
            String tmpServClassName = service.getClass().getName();
            String tmpServName = service.getName();
            if (!tmpServClassName.equals(serviceClassName) || !tmpServName.equals(serviceName)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findService(): returning  [" + serviceClassName + "]   [" + serviceName + "]"));
            }
            return service;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findService(): [" + serviceClassName + "]   [" + serviceName + "]  returning  [null]"));
        }
        return null;
    }

    public static AxisServiceGroup findServiceGroup(AxisConfiguration axisConfig, String serviceGrpClassName, String serviceGrpName) {
        Iterator its = axisConfig.getServiceGroups();
        while (its.hasNext()) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)its.next();
            String tmpSGClassName = serviceGroup.getClass().getName();
            String tmpSGName = serviceGroup.getServiceGroupName();
            if (!tmpSGClassName.equals(serviceGrpClassName)) continue;
            boolean found = false;
            if (tmpSGName == null && serviceGrpName == null) {
                found = true;
            } else if (tmpSGName != null && tmpSGName.equals(serviceGrpName)) {
                found = true;
            }
            if (!found) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findServiceGroup(): returning  [" + serviceGrpClassName + "]   [" + serviceGrpName + "]"));
            }
            return serviceGroup;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findServiceGroup(): [" + serviceGrpClassName + "]   [" + serviceGrpName + "]  returning  [null]"));
        }
        return null;
    }

    public static AxisMessage findMessage(AxisOperation op, String msgName, String msgElementName) {
        boolean matching;
        if (op == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): [" + msgName + "]  [" + msgElementName + "] returning  [null] - no AxisOperation"));
            }
            return null;
        }
        if (msgName == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): [" + msgName + "]  [" + msgElementName + "] returning  [null] - message name is not set"));
            }
            return null;
        }
        String tmpName = null;
        String tmpElementName = null;
        AxisMessage out = null;
        try {
            out = op.getMessage("Out");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (out != null) {
            tmpName = out.getName();
            QName tmpQout = out.getElementQName();
            if (tmpQout != null) {
                tmpElementName = tmpQout.toString();
            }
        }
        if (matching = ObjectStateUtils.matchMessageNames(tmpName, tmpElementName, msgName, msgElementName)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): returning OUT message  [" + msgName + "]  [" + msgElementName + "] "));
            }
            return out;
        }
        AxisMessage in = null;
        try {
            in = op.getMessage("In");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (in != null) {
            tmpName = in.getName();
            QName tmpQin = in.getElementQName();
            if (tmpQin != null) {
                tmpElementName = tmpQin.toString();
            }
        } else {
            tmpName = null;
            tmpElementName = null;
        }
        matching = ObjectStateUtils.matchMessageNames(tmpName, tmpElementName, msgName, msgElementName);
        if (matching) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): returning IN message [" + msgName + "]  [" + msgElementName + "] "));
            }
            return in;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findMessage(): [" + msgName + "]  [" + msgElementName + "] returning  [null]"));
        }
        return null;
    }

    private static boolean matchMessageNames(String name1, String elementName1, String name2, String elementName2) {
        if (name1 != null && name2 != null && name1.equals(name2)) {
            if (elementName1 == null && elementName2 == null) {
                return true;
            }
            return elementName1 != null && elementName2 != null && elementName1.equals(elementName2);
        }
        return false;
    }

    public static Object findHandler(ArrayList existingHandlers, MetaDataEntry metaDataEntry) {
        String title = "ObjectStateUtils:findHandler(): ";
        String handlerClassName = metaDataEntry.getClassName();
        String qNameAsString = metaDataEntry.getQNameAsString();
        for (int i = 0; i < existingHandlers.size(); ++i) {
            if (existingHandlers.get(i) == null) continue;
            String tmpClassName = existingHandlers.get(i).getClass().getName();
            String tmpName = ((Handler)existingHandlers.get(i)).getName().toString();
            if (!tmpClassName.equals(handlerClassName) || !tmpName.equals(qNameAsString)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)(title + " [" + handlerClassName + "]  name [" + qNameAsString + "]  returned"));
            }
            return (Handler)existingHandlers.get(i);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(title + " [" + handlerClassName + "]  name [" + qNameAsString + "] was not found in the existingHandlers list"));
        }
        return null;
    }

    public static TransportListener findTransportListener(AxisConfiguration axisConfig, String listenerClassName) {
        HashMap transportsIn = axisConfig.getTransportsIn();
        Collection values = transportsIn.values();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            TransportInDescription ti = (TransportInDescription)i.next();
            TransportListener tl = ti.getReceiver();
            String tlClassName = tl.getClass().getName();
            if (!tlClassName.equals(listenerClassName)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findTransportListener():  [" + listenerClassName + "]  returned"));
            }
            return tl;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"ObjectStateUtils:findTransportListener(): returning  [null]");
        }
        return null;
    }

    public static boolean isEquivalent(ArrayList a1, ArrayList a2, boolean strict) {
        if (a1 != null && a2 != null) {
            int size2;
            int size1 = a1.size();
            if (size1 != (size2 = a2.size())) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:isEquivalent(ArrayList,ArrayList): FALSE - size mismatch [" + size1 + "] != [" + size2 + "]"));
                }
                return false;
            }
            if (strict) {
                return a1.equals(a2);
            }
            Iterator i1 = a1.iterator();
            while (i1.hasNext()) {
                Object obj1 = i1.next();
                if (a2.contains(obj1)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:isEquivalent(ArrayList,ArrayList): FALSE - mismatch with element [" + obj1.getClass().getName() + "] "));
                }
                return false;
            }
            return true;
        }
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 != null && a2 == null) {
            return a1.size() == 0;
        }
        if (a1 == null && a2 != null) {
            return a2.size() == 0;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"ObjectStateUtils:isEquivalent(ArrayList,ArrayList): FALSE - mismatch in lists");
        }
        return false;
    }

    public static boolean isEquivalent(Map m1, Map m2, boolean strict) {
        if (m1 != null && m2 != null) {
            int size2;
            if (strict) {
                return ((Object)m1).equals(m2);
            }
            int size1 = m1.size();
            if (size1 != (size2 = m2.size())) {
                return false;
            }
            Iterator it1 = m1.keySet().iterator();
            while (it1.hasNext()) {
                Object key1 = it1.next();
                if (m2.containsKey(key1)) continue;
                return false;
            }
            return true;
        }
        return m1 == null && m2 == null;
    }

    public static boolean isEquivalent(LinkedList l1, LinkedList l2) {
        if (l1 != null && l2 != null) {
            return l1.equals(l2);
        }
        return l1 == null && l2 == null;
    }

    public static void traceNotSerializable(Object obj, NotSerializableException nse, String objDesc, String methodName, String desc) {
        String objName;
        if (!log.isTraceEnabled()) {
            return;
        }
        if (obj != null && NotSerializableList.get(objName = obj.getClass().getName()) == null) {
            Integer counter = new Integer(1);
            NotSerializableList.put(objName, counter);
            log.trace((Object)("ObjectStateUtils: ***NotSerializableException*** [" + nse.getMessage() + "] in method [" + methodName + "] for object [" + objName + "]  associated with [" + objDesc + "].  " + desc));
        }
    }
}

