/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.HashMap;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.Utils;

public class CallbackReceiver
implements MessageReceiver {
    public static String SERVICE_NAME = "ClientService";
    private HashMap callbackStore = new HashMap();

    public void addCallback(String MsgID, Callback callback) {
        this.callbackStore.put(MsgID, callback);
    }

    public Callback lookupCallback(String msgID) {
        return (Callback)this.callbackStore.get(msgID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageContext messageCtx) throws AxisFault {
        RelatesTo relatesTO = messageCtx.getOptions().getRelatesTo();
        if (relatesTO == null) {
            throw new AxisFault("Cannot identify correct Callback object. RelatesTo is null");
        }
        String messageID = relatesTO.getValue();
        Callback callback = (Callback)this.callbackStore.remove(messageID);
        AsyncResult result = new AsyncResult(messageCtx);
        if (callback == null) {
            throw new AxisFault("The Callback realtes to MessageID " + messageID + " is not found");
        }
        try {
            SOAPEnvelope envelope = result.getResponseEnvelope();
            SOAPFault fault = envelope.getBody().getFault();
            if (fault == null) {
                callback.onComplete(result);
            } else {
                AxisFault axisFault = Utils.getInboundFaultFromMessageContext(messageCtx);
                callback.onError(axisFault);
            }
        }
        finally {
            callback.setComplete(true);
        }
    }

    public HashMap getCallbackStore() {
        return this.callbackStore;
    }
}

