/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpRequest;
import org.apache.axis2.transport.http.server.AxisHttpRequestImpl;
import org.apache.axis2.transport.http.server.AxisHttpResponse;
import org.apache.axis2.transport.http.server.AxisHttpResponseImpl;
import org.apache.axis2.transport.http.server.Worker;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

public class AxisHttpService {
    private static final Log LOG = LogFactory.getLog((Class)AxisHttpService.class);
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    private final HttpResponseFactory responseFactory;
    private final MessageContext msgContext;
    private final ConfigurationContext configurationContext;
    private final Worker worker;
    private HttpParams params;

    public AxisHttpService(HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, ConfigurationContext configurationContext, Worker worker) {
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection strategy may not be null");
        }
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        if (worker == null) {
            throw new IllegalArgumentException("Worker may not be null");
        }
        if (configurationContext == null) {
            throw new IllegalArgumentException("Configuration context may not be null");
        }
        this.httpProcessor = httpProcessor;
        this.connStrategy = connStrategy;
        this.responseFactory = responseFactory;
        this.configurationContext = configurationContext;
        this.worker = worker;
        this.msgContext = ContextFactory.createMessageContext(configurationContext);
        this.msgContext.setIncomingTransportName("http");
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setParams(HttpParams params) {
        this.params = params;
    }

    public void handleRequest(AxisHttpConnection conn, HttpContext context) throws IOException, HttpException {
        HttpResponse response;
        if (conn instanceof HttpInetConnection) {
            AxisHttpConnection inetconn = conn;
            this.msgContext.setProperty("REMOTE_ADDR", inetconn.getRemoteAddress().getHostAddress());
            this.msgContext.setProperty("TRANSPORT_ADDR", inetconn.getLocalAddress().getHostAddress());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remote address of the connection : " + inetconn.getRemoteAddress().getHostAddress()));
            }
        }
        try {
            OutputStream outstream;
            HttpRequest request = conn.receiveRequest(this.params);
            HttpVersion ver = request.getRequestLine().getHttpVersion();
            if (!ver.lessEquals(HttpVersion.HTTP_1_1)) {
                ver = HttpVersion.HTTP_1_1;
            }
            response = this.responseFactory.newHttpResponse(ver, 200, context);
            response.getParams().setDefaults(this.params);
            if (request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).expectContinue()) {
                HttpResponse ack = this.responseFactory.newHttpResponse(ver, 100, context);
                ack.getParams().setDefaults(this.params);
                conn.sendResponse(ack);
                conn.flush();
            }
            AxisHttpRequestImpl axisreq = new AxisHttpRequestImpl(conn, request, this.httpProcessor, context);
            AxisHttpResponseImpl axisres = new AxisHttpResponseImpl(conn, response, this.httpProcessor, context);
            axisreq.prepare();
            this.doService(axisreq, axisres, context);
            InputStream instream = conn.getInputStream();
            if (instream != null) {
                instream.close();
            }
            if (!axisres.isCommitted()) {
                axisres.commit();
            }
            if ((outstream = conn.getOutputStream()) != null) {
                outstream.close();
            }
        }
        catch (HttpException ex) {
            response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, context);
            response.getParams().setDefaults(this.params);
            this.handleException(ex, response);
            this.httpProcessor.process(response, context);
            conn.sendResponse(response);
        }
        conn.flush();
        if (!this.connStrategy.keepAlive(response, context)) {
            conn.close();
        } else {
            conn.reset();
        }
    }

    protected void handleException(HttpException ex, HttpResponse response) {
        if (ex instanceof MethodNotSupportedException) {
            response.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response.setStatusCode(400);
        } else {
            response.setStatusCode(500);
        }
    }

    protected void doService(AxisHttpRequest request, AxisHttpResponse response, HttpContext context) throws HttpException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Request method: " + request.getMethod()));
            LOG.debug((Object)("Target URI: " + request.getRequestURI()));
        }
        try {
            TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut("http");
            TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn("http");
            String sessionKey = (String)context.getAttribute("Cookie");
            this.msgContext.setTransportIn(transportIn);
            this.msgContext.setTransportOut(transportOut);
            this.msgContext.setServerSide(true);
            this.msgContext.setProperty("Cookie", sessionKey);
            this.msgContext.setProperty("TransportInURL", request.getRequestURI());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            Iterator it = request.headerIterator();
            while (it.hasNext()) {
                Header header = (Header)it.next();
                headerMap.put(header.getName(), header.getValue());
            }
            this.msgContext.setProperty("TRANSPORT_HEADERS", headerMap);
            this.msgContext.setProperty("ContentType", request.getContentType());
            this.msgContext.setProperty("TRANSPORT_OUT", response.getOutputStream());
            this.msgContext.setProperty("OutTransportInfo", response);
            this.msgContext.setTo(new EndpointReference(request.getRequestURI()));
            this.msgContext.setProperty("RequestResponseTransportControl", new SimpleHTTPRequestResponseTransport());
            this.worker.service(request, response, this.msgContext);
        }
        catch (SocketException ex) {
            throw ex;
        }
        catch (HttpException ex) {
            throw ex;
        }
        catch (Throwable e) {
            AxisEngine engine = new AxisEngine(this.configurationContext);
            this.msgContext.setProperty("TRANSPORT_OUT", response.getOutputStream());
            this.msgContext.setProperty("OutTransportInfo", response);
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(this.msgContext, e);
            if (AddressingHelper.isFaultRedirected(this.msgContext)) {
                response.setStatus(202);
            } else {
                response.sendError(500, "Internal server error");
            }
            engine.sendFault(faultContext);
        }
    }

    class SimpleHTTPRequestResponseTransport
    implements RequestResponseTransport {
        private CountDownLatch responseReadySignal = new CountDownLatch(1);
        RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.INITIAL;
        AxisFault faultToBeThrownOut = null;

        SimpleHTTPRequestResponseTransport() {
        }

        public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
            this.signalResponseReady();
        }

        public void awaitResponse() throws InterruptedException, AxisFault {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
            this.responseReadySignal.await();
            if (this.faultToBeThrownOut != null) {
                throw this.faultToBeThrownOut;
            }
        }

        public void signalResponseReady() {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
            this.responseReadySignal.countDown();
        }

        public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
            return this.status;
        }

        public void signalFaultReady(AxisFault fault) {
            this.faultToBeThrownOut = fault;
            this.signalResponseReady();
        }
    }
}

