/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.Utils;

public class AxisServiceGroup
extends AxisDescription {
    private ArrayList modulesList = new ArrayList();
    private ArrayList engagedModules;
    private HashMap moduleConfigmap = new HashMap();
    private ClassLoader serviceGroupClassLoader;
    private String serviceGroupName;
    private boolean foundWebResources;

    public AxisServiceGroup() {
        this.engagedModules = new ArrayList();
    }

    public AxisServiceGroup(AxisConfiguration axisDescription) {
        this();
        this.setParent(axisDescription);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        if (this.moduleConfigmap == null) {
            this.moduleConfigmap = new HashMap();
        }
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addModuleref(String moduleref) {
        this.modulesList.add(moduleref);
    }

    public void addService(AxisService service) throws AxisFault {
        if (service == null) {
            return;
        }
        if (this.serviceGroupName == null) {
            this.serviceGroupName = service.getName();
        }
        service.setParent(this);
        AxisConfiguration axisConfig = (AxisConfiguration)this.getParent();
        if (axisConfig != null) {
            Iterator modules = this.engagedModules.iterator();
            while (modules.hasNext()) {
                String moduleName = (String)modules.next();
                AxisModule axisModule = axisConfig.getModule(moduleName);
                if (axisModule != null) {
                    Module moduleImpl = axisModule.getModule();
                    if (moduleImpl != null) {
                        moduleImpl.engageNotify(service);
                    }
                    service.engageModule(axisModule, axisConfig);
                    continue;
                }
                throw new AxisFault(Messages.getMessage("modulenotavailble", moduleName));
            }
        }
        service.setLastupdate();
        this.addChild(service);
    }

    public void addToGroup(AxisService service) throws Exception {
        if (service == null) {
            return;
        }
        service.setParent(this);
        AxisConfiguration axisConfig = (AxisConfiguration)this.getParent();
        if (axisConfig != null) {
            Iterator modules = this.engagedModules.iterator();
            while (modules.hasNext()) {
                String moduleName = (String)modules.next();
                AxisModule axisModule = axisConfig.getModule(moduleName);
                if (axisModule != null) {
                    Module moduleImpl = axisModule.getModule();
                    if (moduleImpl != null) {
                        moduleImpl.engageNotify(service);
                    }
                    service.engageModule(axisModule, axisConfig);
                    continue;
                }
                throw new AxisFault(Messages.getMessage("modulenotavailble", moduleName));
            }
        }
        service.setLastupdate();
        this.addChild(service);
        if (axisConfig != null) {
            axisConfig.addToAllServicesMap(service.getName(), service);
        }
    }

    public void addToengagedModules(String moduleName) {
        this.engagedModules.add(moduleName);
    }

    public void removeFromEngageList(String moduleName) {
        this.engagedModules.remove(moduleName);
    }

    public void engageModule(AxisModule module, AxisConfiguration axisConfig) throws AxisFault {
        String moduleName = module.getName();
        Iterator iterator = this.engagedModules.iterator();
        while (iterator.hasNext()) {
            String modu = (String)iterator.next();
            boolean isEngagable = Utils.checkVersion(moduleName, modu);
            if (isEngagable) continue;
            return;
        }
        Iterator serviceIter = this.getServices();
        while (serviceIter.hasNext()) {
            AxisService axisService = (AxisService)serviceIter.next();
            axisService.engageModule(module, axisConfig);
        }
        this.addToengagedModules(moduleName);
    }

    public void disengageModule(AxisModule module) throws AxisFault {
        Iterator serviceIter = this.getServices();
        while (serviceIter.hasNext()) {
            AxisService axisService = (AxisService)serviceIter.next();
            axisService.disengageModule(module);
        }
        this.removeFromEngageList(module.getName());
    }

    public void removeService(String name) throws AxisFault {
        AxisService service = this.getService(name);
        if (service != null) {
            ((AxisConfiguration)this.getParent()).notifyObservers(0, service);
        }
        this.removeChild(name);
    }

    public AxisConfiguration getAxisDescription() {
        return (AxisConfiguration)this.getParent();
    }

    public ArrayList getEngagedModules() {
        return this.engagedModules;
    }

    public ModuleConfiguration getModuleConfig(String moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public ArrayList getModuleRefs() {
        return this.modulesList;
    }

    public AxisService getService(String name) throws AxisFault {
        return (AxisService)this.getChild(name);
    }

    public ClassLoader getServiceGroupClassLoader() {
        return this.serviceGroupClassLoader;
    }

    public String getServiceGroupName() {
        return this.serviceGroupName;
    }

    public Iterator getServices() {
        return this.getChildren();
    }

    public void setAxisDescription(AxisConfiguration axisDescription) {
        this.setParent(axisDescription);
    }

    public void setServiceGroupClassLoader(ClassLoader serviceGroupClassLoader) {
        this.serviceGroupClassLoader = serviceGroupClassLoader;
    }

    public void setServiceGroupName(String serviceGroupName) {
        this.serviceGroupName = serviceGroupName;
    }

    public Object getKey() {
        return this.serviceGroupName;
    }

    public boolean isEngaged(String moduleName) {
        AxisModule module = this.getAxisDescription().getModule(moduleName);
        if (module == null) {
            return false;
        }
        Iterator engagedModuleItr = this.engagedModules.iterator();
        while (engagedModuleItr.hasNext()) {
            String axisModule = (String)engagedModuleItr.next();
            if (!axisModule.equals(module.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isFoundWebResources() {
        return this.foundWebResources;
    }

    public void setFoundWebResources(boolean foundWebResources) {
        this.foundWebResources = foundWebResources;
    }
}

