/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL2Constants;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.ws.commons.schema.XmlSchema;

public class AxisService2WSDL2
implements WSDL2Constants {
    private AxisService axisService;
    private String[] url;

    public AxisService2WSDL2(AxisService service, String[] serviceURL) {
        this.axisService = service;
        this.url = serviceURL;
    }

    public OMElement toWSDL20() throws AxisFault {
        Map nameSpacesMap = this.axisService.getNameSpacesMap();
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMNamespace wsdl = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl", nameSpacesMap)) : omFactory.createOMNamespace("http://www.w3.org/ns/wsdl", "wsdl2");
        OMElement descriptionElement = omFactory.createOMElement("description", wsdl);
        WSDLSerializationUtil.populateNamespaces(descriptionElement, nameSpacesMap);
        descriptionElement.declareNamespace(this.axisService.getTargetNamespace(), this.axisService.getTargetNamespacePrefix());
        OMAttribute targetNamespace = omFactory.createOMAttribute("targetNamespace", null, this.axisService.getTargetNamespace());
        descriptionElement.addAttribute(targetNamespace);
        OMNamespace tns = omFactory.createOMNamespace(this.axisService.getTargetNamespace(), this.axisService.getTargetNamespacePrefix());
        if (nameSpacesMap != null && !nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl")) {
            descriptionElement.declareDefaultNamespace("http://www.w3.org/ns/wsdl");
        }
        OMNamespace wsoap = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl/soap") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl/soap", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl/soap", nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl/soap", "wsoap");
        OMNamespace whttp = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl/http") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl/http", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl/http", nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl/http", "whttp");
        OMNamespace wsdlx = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl-extensions") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl-extensions", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl-extensions", nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl-extensions", "wsdlx");
        OMElement documentationElement = omFactory.createOMElement("documentation", wsdl);
        String description = this.axisService.getServiceDescription();
        if (description != null) {
            documentationElement.setText(description);
        }
        descriptionElement.addChild((OMNode)documentationElement);
        OMElement typesElement = omFactory.createOMElement("types", wsdl);
        this.axisService.populateSchemaMappings();
        ArrayList schemas = this.axisService.getSchema();
        for (int i = 0; i < schemas.size(); ++i) {
            StringWriter writer = new StringWriter();
            XmlSchema schema = this.axisService.getSchema(i);
            if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) continue;
            schema.write((Writer)writer);
            String schemaString = writer.toString();
            if ("".equals(schemaString)) continue;
            try {
                typesElement.addChild(XMLUtils.toOM(new ByteArrayInputStream(schemaString.getBytes())));
                continue;
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
        }
        descriptionElement.addChild((OMNode)typesElement);
        Parameter parameter = this.axisService.getParameter("interface");
        String interfaceName = parameter != null ? (String)parameter.getValue() : "ServiceInterface";
        descriptionElement.addChild((OMNode)this.getInterfaceEmelent(wsdl, tns, wsdlx, omFactory, interfaceName));
        Map endpointMap = this.axisService.getEndpoints();
        if (endpointMap != null && endpointMap.size() > 0) {
            String[] eprs = this.axisService.getEPRs();
            if (eprs == null) {
                eprs = new String[]{this.axisService.getName()};
            }
            OMElement serviceElement = this.getServiceElement(wsdl, tns, omFactory, interfaceName);
            Iterator iterator = endpointMap.values().iterator();
            while (iterator.hasNext()) {
                AxisEndpoint axisEndpoint = (AxisEndpoint)iterator.next();
                serviceElement.addChild((OMNode)axisEndpoint.toWSDL20(wsdl, tns, whttp, eprs[0]));
                descriptionElement.addChild((OMNode)axisEndpoint.getBinding().toWSDL20(wsdl, tns, wsoap, whttp, interfaceName, this.axisService.getNameSpacesMap(), this.axisService.getWSAddressingFlag()));
            }
            descriptionElement.addChild((OMNode)serviceElement);
        } else {
            descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateSOAP11Binding(omFactory, this.axisService, wsdl, wsoap, tns));
            descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateSOAP12Binding(omFactory, this.axisService, wsdl, wsoap, tns));
            descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateHTTPBinding(omFactory, this.axisService, wsdl, whttp, tns));
            descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateServiceElement(omFactory, wsdl, tns, this.axisService));
        }
        return descriptionElement;
    }

    private OMElement getInterfaceEmelent(OMNamespace wsdl, OMNamespace tns, OMNamespace wsdlx, OMFactory fac, String interfaceName) {
        OMElement interfaceElement = fac.createOMElement("interface", wsdl);
        interfaceElement.addAttribute(fac.createOMAttribute("name", null, interfaceName));
        Iterator iterator = this.axisService.getOperations();
        ArrayList<OMElement> interfaceOperations = new ArrayList<OMElement>();
        ArrayList<String> interfaceFaults = new ArrayList<String>();
        int i = 0;
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            interfaceOperations.add(i, axisOperation.toWSDL20(wsdl, tns, wsdlx));
            ++i;
            Iterator faultsIterator = axisOperation.getFaultMessages().iterator();
            while (faultsIterator.hasNext()) {
                AxisMessage faultMessage = (AxisMessage)faultsIterator.next();
                String name = faultMessage.getName();
                if (interfaceFaults.contains(name)) continue;
                OMElement faultElement = fac.createOMElement("fault", wsdl);
                faultElement.addAttribute(fac.createOMAttribute("name", null, name));
                faultElement.addAttribute(fac.createOMAttribute("element", null, WSDLSerializationUtil.getElementName(faultMessage, this.axisService.getNameSpacesMap())));
                interfaceFaults.add(name);
                interfaceElement.addChild((OMNode)faultElement);
            }
        }
        for (i = 0; i < interfaceOperations.size(); ++i) {
            interfaceElement.addChild((OMNode)interfaceOperations.get(i));
        }
        return interfaceElement;
    }

    private OMElement getServiceElement(OMNamespace wsdl, OMNamespace tns, OMFactory omFactory, String interfaceName) {
        OMElement serviceElement = omFactory.createOMElement("service", wsdl);
        serviceElement.addAttribute(omFactory.createOMAttribute("name", null, this.axisService.getName()));
        serviceElement.addAttribute(omFactory.createOMAttribute("interface", null, tns.getPrefix() + ":" + interfaceName));
        return serviceElement;
    }
}

