/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.cluster.ClusterManager;
import org.apache.axis2.cluster.configuration.ConfigurationManager;
import org.apache.axis2.cluster.configuration.ConfigurationManagerListener;
import org.apache.axis2.cluster.context.ContextManager;
import org.apache.axis2.cluster.context.ContextManagerListener;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;

public class ClusterBuilder
extends DescriptionBuilder {
    public ClusterBuilder(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public ClusterBuilder(InputStream serviceInputStream, AxisConfiguration axisConfig) {
        super(serviceInputStream, axisConfig);
    }

    public void buildCluster(OMElement clusterElement) throws DeploymentException {
        OMAttribute classNameAttr = clusterElement.getAttribute(new QName("class"));
        if (classNameAttr == null) {
            throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "cluster"));
        }
        String className = classNameAttr.getAttributeValue();
        try {
            OMElement contextManagerElement;
            Class<?> clazz = Class.forName(className);
            ClusterManager clusterManager = (ClusterManager)clazz.newInstance();
            Iterator params = clusterElement.getChildrenWithName(new QName("parameter"));
            this.processParameters(params, clusterManager, null);
            OMElement configurationManagerElement = clusterElement.getFirstChildWithName(new QName("configurationManager"));
            if (configurationManagerElement != null) {
                classNameAttr = configurationManagerElement.getAttribute(new QName("class"));
                if (classNameAttr == null) {
                    throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "configurationManager"));
                }
                className = classNameAttr.getAttributeValue();
                clazz = Class.forName(className);
                ConfigurationManager configurationManager = (ConfigurationManager)clazz.newInstance();
                clusterManager.setConfigurationManager(configurationManager);
                OMElement listenersElement = configurationManagerElement.getFirstChildWithName(new QName("listeners"));
                if (listenersElement != null) {
                    Iterator listenerElemIter = listenersElement.getChildrenWithName(new QName("listener"));
                    while (listenerElemIter.hasNext()) {
                        OMElement listenerElement = (OMElement)listenerElemIter.next();
                        classNameAttr = listenerElement.getAttribute(new QName("class"));
                        if (classNameAttr == null) {
                            throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "listener"));
                        }
                        className = classNameAttr.getAttributeValue();
                        clazz = Class.forName(className);
                        ConfigurationManagerListener listener = (ConfigurationManagerListener)clazz.newInstance();
                        listener.setConfigurationContext(this.configCtx);
                        configurationManager.addConfigurationManagerListener(listener);
                    }
                }
                configurationManager.setConfigurationContext(this.configCtx);
            }
            if ((contextManagerElement = clusterElement.getFirstChildWithName(new QName("contextManager"))) != null) {
                classNameAttr = contextManagerElement.getAttribute(new QName("class"));
                if (classNameAttr == null) {
                    throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "contextManager"));
                }
                className = classNameAttr.getAttributeValue();
                clazz = Class.forName(className);
                ContextManager contextManager = (ContextManager)clazz.newInstance();
                clusterManager.setContextManager(contextManager);
                OMElement listenersElement = contextManagerElement.getFirstChildWithName(new QName("listeners"));
                if (listenersElement != null) {
                    Iterator listenerElemIter = listenersElement.getChildrenWithName(new QName("listener"));
                    while (listenerElemIter.hasNext()) {
                        OMElement listenerElement = (OMElement)listenerElemIter.next();
                        classNameAttr = listenerElement.getAttribute(new QName("class"));
                        if (classNameAttr == null) {
                            throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "listener"));
                        }
                        className = classNameAttr.getAttributeValue();
                        clazz = Class.forName(className);
                        System.out.println(className);
                        ContextManagerListener listener = (ContextManagerListener)clazz.newInstance();
                        contextManager.addContextManagerListener(listener);
                    }
                }
            }
            this.axisConfig.setClusterManager(clusterManager);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(Messages.getMessage("clusterImplNotFound"));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new DeploymentException(Messages.getMessage("cannotLoadClusterImpl"));
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(e);
        }
    }
}

