/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.axis2.util.ObjectStateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceContext
extends AbstractContext
implements Externalizable {
    private static final Log log = LogFactory.getLog((Class)ServiceContext.class);
    private static final String myClassName = "ServiceContext";
    private String logCorrelationIDString = "ServiceContext@" + UUIDGenerator.getUUID();
    private static final long serialVersionUID = 8265625275015738957L;
    private static final int REVISION_1 = 1;
    private static final int revisionID = 1;
    public static final String SERVICE_OBJECT = "serviceObject";
    private EndpointReference targetEPR;
    private EndpointReference myEPR;
    private transient AxisService axisService;
    private transient ServiceGroupContext serviceGroupContext;
    private transient ConfigurationContext configContext;
    private boolean cachingOperationContext;
    private transient OperationContext lastOperationContext;
    private transient boolean needsToBeReconciled = false;
    private transient MetaDataEntry metaAxisService = null;
    private transient ServiceGroupContext metaParent = null;

    public ServiceContext() {
        super(null);
    }

    public ServiceContext(AxisService serviceConfig, ServiceGroupContext serviceGroupContext) {
        super(serviceGroupContext);
        this.serviceGroupContext = serviceGroupContext;
        this.axisService = serviceConfig;
        this.configContext = (ConfigurationContext)this.parent.getParent();
    }

    public OperationContext createOperationContext(QName name) {
        AxisOperation axisOp = this.axisService.getOperation(name);
        return this.createOperationContext(axisOp);
    }

    public OperationContext createOperationContext(AxisOperation axisOp) {
        OperationContext ctx = ContextFactory.createOperationContext(axisOp, this);
        if (this.cachingOperationContext) {
            this.lastOperationContext = ctx;
        }
        return ctx;
    }

    public AxisService getAxisService() {
        this.checkActivateWarning("getAxisService");
        return this.axisService;
    }

    public ConfigurationContext getConfigurationContext() {
        this.checkActivateWarning("getConfigurationContext");
        return this.configContext;
    }

    public ServiceGroupContext getServiceGroupContext() {
        this.checkActivateWarning("getServiceGroupContext");
        return this.serviceGroupContext;
    }

    public EndpointReference getMyEPR(String transport) throws AxisFault {
        this.axisService.isEnableAllTransports();
        ConfigurationContext configctx = this.configContext;
        if (configctx != null) {
            ListenerManager lm = configctx.getListenerManager();
            if (!lm.isListenerRunning(transport)) {
                TransportInDescription trsin = configctx.getAxisConfiguration().getTransportIn(transport);
                if (trsin != null) {
                    lm.addListener(trsin, false);
                } else {
                    throw new AxisFault(Messages.getMessage("transportnotfound", transport));
                }
            }
            if (!lm.isStopped()) {
                return lm.getEPRforService(this.axisService.getName(), null, transport);
            }
        }
        return null;
    }

    public EndpointReference getTargetEPR() {
        return this.targetEPR;
    }

    public void setTargetEPR(EndpointReference targetEPR) {
        this.targetEPR = targetEPR;
    }

    public EndpointReference getMyEPR() {
        if (this.myEPR == null) {
            try {
                if (ListenerManager.defaultConfigurationContext != null) {
                    ListenerManager listenerManager = ListenerManager.defaultConfigurationContext.getListenerManager();
                    this.myEPR = listenerManager.getEPRforService(this.axisService.getName(), null, null);
                }
            }
            catch (AxisFault axisFault) {
                this.myEPR = null;
            }
        }
        return this.myEPR;
    }

    public void setMyEPR(EndpointReference myEPR) {
        this.myEPR = myEPR;
    }

    public OperationContext getLastOperationContext() {
        return this.lastOperationContext;
    }

    public void setLastOperationContext(OperationContext lastOperationContext) {
        this.lastOperationContext = lastOperationContext;
    }

    public boolean isCachingOperationContext() {
        return this.cachingOperationContext;
    }

    public void setCachingOperationContext(boolean cacheLastOperationContext) {
        this.cachingOperationContext = cacheLastOperationContext;
    }

    public String getName() {
        if (this.axisService != null) {
            return this.axisService.getName();
        }
        if (this.metaAxisService != null) {
            return this.metaAxisService.getName();
        }
        return null;
    }

    public String getGroupName() {
        if (this.serviceGroupContext != null) {
            return this.serviceGroupContext.getId();
        }
        if (this.metaParent != null) {
            return this.metaParent.getId();
        }
        return null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(8265625275015738957L);
        out.writeInt(1);
        out.writeLong(this.getLastTouchedTime());
        out.writeBoolean(this.cachingOperationContext);
        ObjectStateUtils.writeString(out, this.logCorrelationIDString, this.logCorrelationIDString + ".logCorrelationIDString");
        try {
            ObjectStateUtils.writeObject(out, this.targetEPR, "ServiceContext.targetEPR");
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            ObjectStateUtils.writeObject(out, this.myEPR, "ServiceContext.myEPR");
        }
        catch (Exception e2) {
            // empty catch block
        }
        Map tmpMap = this.getProperties();
        HashMap tmpHashMap = null;
        if (tmpMap != null && !tmpMap.isEmpty()) {
            tmpHashMap = new HashMap(tmpMap);
        }
        ObjectStateUtils.writeHashMap(out, tmpHashMap, "ServiceContext.properties");
        String axisServMarker = "ServiceContext.metaAxisService";
        ObjectStateUtils.writeString(out, axisServMarker, axisServMarker);
        if (this.axisService == null) {
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
        } else {
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            this.metaAxisService = new MetaDataEntry(this.axisService.getClass().getName(), this.axisService.getName());
            ObjectStateUtils.writeObject(out, this.metaAxisService, "ServiceContext.metaAxisService");
        }
        ServiceGroupContext myParent = (ServiceGroupContext)this.getParent();
        ObjectStateUtils.writeObject(out, myParent, "ServiceContext.parent ServiceGroupContext");
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.needsToBeReconciled = true;
        log.trace((Object)("ServiceContext:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  "));
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != 8265625275015738957L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 1) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        long time = in.readLong();
        this.setLastTouchedTime(time);
        this.cachingOperationContext = in.readBoolean();
        this.logCorrelationIDString = ObjectStateUtils.readString(in, "ServiceContext.logCorrelationIDString");
        log.trace((Object)("ServiceContext:readExternal():  reading input stream for [" + this.logCorrelationIDString + "]  "));
        this.targetEPR = (EndpointReference)ObjectStateUtils.readObject(in, "ServiceContext.targetEPR");
        this.myEPR = (EndpointReference)ObjectStateUtils.readObject(in, "ServiceContext.myEPR");
        HashMap tmpHashMap = ObjectStateUtils.readHashMap(in, "ServiceContext.properties");
        this.properties = new HashMap();
        if (tmpHashMap != null) {
            this.setProperties(tmpHashMap);
        }
        ObjectStateUtils.readString(in, "ServiceContext.axisService");
        boolean metaAxisServiceIsActive = in.readBoolean();
        this.metaAxisService = metaAxisServiceIsActive == ObjectStateUtils.ACTIVE_OBJECT ? (MetaDataEntry)ObjectStateUtils.readObject(in, "ServiceContext.metaAxisService") : null;
        this.metaParent = (ServiceGroupContext)ObjectStateUtils.readObject(in, "ServiceContext.parent ServiceGroupContext");
        this.lastOperationContext = null;
    }

    public void activate(ConfigurationContext cc) {
        if (!this.needsToBeReconciled) {
            return;
        }
        this.configContext = cc;
        AxisConfiguration axisConfig = cc.getAxisConfiguration();
        this.axisService = null;
        if (this.metaAxisService != null) {
            this.axisService = ObjectStateUtils.findService(axisConfig, this.metaAxisService.getClassName(), this.metaAxisService.getQNameAsString());
        }
        if (this.metaParent != null) {
            String groupName = this.metaParent.getId();
            ServiceGroupContext existingSGC = null;
            ServiceGroupContext sgc = cc.getServiceGroupContext(groupName);
            if (existingSGC == null) {
                this.metaParent.activate(cc);
                this.setParent(this.metaParent);
            } else {
                this.setParent(existingSGC);
                this.metaParent.putContextProperties(existingSGC);
            }
        } else {
            this.setParent(this.metaParent);
        }
        this.serviceGroupContext = (ServiceGroupContext)this.getParent();
        if (this.serviceGroupContext != null) {
            this.serviceGroupContext.addServiceContext(this);
        }
        this.needsToBeReconciled = false;
        if (this.metaParent != null) {
            this.metaParent.addServiceContext(this);
        }
    }

    public void putContextProperties(ServiceContext context, boolean doParentProperties) {
        if (context != null) {
            Map props = this.getProperties();
            context.mergeProperties(props);
            if (doParentProperties) {
                ServiceGroupContext mySGC = null;
                if (this.serviceGroupContext != null) {
                    mySGC = this.serviceGroupContext;
                } else if (this.metaParent != null) {
                    mySGC = this.metaParent;
                }
                if (mySGC != null) {
                    ServiceGroupContext sgc = context.getServiceGroupContext();
                    mySGC.putContextProperties(sgc);
                }
            }
        }
    }

    public boolean isEquivalent(ServiceContext ctx) {
        if (!this.axisService.equals(ctx.getAxisService())) {
            return false;
        }
        EndpointReference targetEPR2 = ctx.getTargetEPR();
        if (this.targetEPR != null && targetEPR2 != null) {
            if (!this.targetEPR.isEquivalent(targetEPR2)) {
                return false;
            }
        } else if (this.targetEPR != null || targetEPR2 != null) {
            return false;
        }
        EndpointReference myEPR2 = ctx.getMyEPR();
        if (this.myEPR != null && myEPR2 != null) {
            if (!this.myEPR.isEquivalent(myEPR2)) {
                return false;
            }
        } else if (this.myEPR != null || myEPR2 != null) {
            return false;
        }
        return true;
    }

    public String getLogCorrelationIDString() {
        return this.logCorrelationIDString;
    }

    private void checkActivateWarning(String methodname) {
        if (this.needsToBeReconciled) {
            log.warn((Object)(this.logCorrelationIDString + ":" + methodname + "(): ****WARNING**** " + myClassName + ".activate(configurationContext) needs to be invoked."));
        }
    }

    public ConfigurationContext getRootContext() {
        return this.configContext;
    }
}

