/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;

public class ApplicationXMLBuilder
implements Builder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        try {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
            int b = pushbackInputStream.read();
            if (b > 0) {
                pushbackInputStream.unread(b);
                StAXBuilder builder = BuilderUtil.getPOXBuilder(pushbackInputStream, (String)messageContext.getProperty("CHARACTER_SET_ENCODING"));
                OMNodeEx documentElement = (OMNodeEx)builder.getDocumentElement();
                documentElement.setParent(null);
                SOAPBody body = soapEnvelope.getBody();
                body.addChild((OMNode)documentElement);
            }
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
        return soapEnvelope;
    }
}

