/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointReference
implements Serializable {
    private static final long serialVersionUID = 5278892171162372439L;
    private static final Log log = LogFactory.getLog((Class)EndpointReference.class);
    private String name;
    private String address;
    private ArrayList addressAttributes;
    private ArrayList metaData;
    private ArrayList metaDataAttributes;
    private Map referenceParameters;
    private ArrayList extensibleElements;
    private ArrayList attributes;

    public EndpointReference(String address) {
        this.address = address;
    }

    public void addReferenceParameter(OMElement omElement) {
        if (omElement == null) {
            return;
        }
        if (this.referenceParameters == null) {
            this.referenceParameters = new HashMap();
        }
        this.referenceParameters.put(omElement.getQName(), omElement);
    }

    public void addReferenceParameter(QName qname, String value) {
        if (qname == null) {
            return;
        }
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(qname, null);
        omElement.setText(value);
        this.addReferenceParameter(omElement);
    }

    public Map getAllReferenceParameters() {
        return this.referenceParameters;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public ArrayList getAddressAttributes() {
        return this.addressAttributes;
    }

    public void setAddressAttributes(ArrayList al) {
        this.addressAttributes = al;
    }

    public ArrayList getMetadataAttributes() {
        return this.metaDataAttributes;
    }

    public void setMetadataAttributes(ArrayList al) {
        this.metaDataAttributes = al;
    }

    public boolean hasAnonymousAddress() {
        boolean result;
        boolean bl = result = "http://www.w3.org/2005/08/addressing/anonymous".equals(this.address) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(this.address) || this.address != null && this.address.startsWith("http://docs.oasis-open.org/ws-rx/wsmc/200702/anonymous?id=");
        if (log.isTraceEnabled()) {
            log.trace((Object)("hasAnonymousAddress: " + this.address + " is Anonymous: " + result));
        }
        return result;
    }

    public boolean hasNoneAddress() {
        boolean result = "http://www.w3.org/2005/08/addressing/none".equals(this.address);
        if (log.isTraceEnabled()) {
            log.trace((Object)("hasNoneAddress: " + this.address + " is None: " + result));
        }
        return result;
    }

    public void addAttribute(String localName, OMNamespace ns, String value) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(OMAbstractFactory.getOMFactory().createOMAttribute(localName, ns, value));
    }

    public ArrayList getAttributes() {
        return this.attributes;
    }

    public void addAttribute(OMAttribute omAttribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(omAttribute);
    }

    public ArrayList getExtensibleElements() {
        return this.extensibleElements;
    }

    public void setExtensibleElements(ArrayList extensibleElements) {
        this.extensibleElements = extensibleElements;
    }

    public void addExtensibleElement(OMElement extensibleElement) {
        if (extensibleElement != null) {
            if (this.extensibleElements == null) {
                this.extensibleElements = new ArrayList();
            }
            this.extensibleElements.add(extensibleElement);
        }
    }

    public ArrayList getMetaData() {
        return this.metaData;
    }

    public void addMetaData(OMNode metaData) {
        if (metaData != null) {
            if (this.metaData == null) {
                this.metaData = new ArrayList();
            }
            this.metaData.add(metaData);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReferenceParameters(Map referenceParameters) {
        this.referenceParameters = referenceParameters;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Address: " + this.address);
        if (this.addressAttributes != null) {
            buffer.append(", Address Attributes: ").append(this.addressAttributes);
        }
        if (this.metaData != null) {
            buffer.append(", Metadata: ").append(this.metaData);
        }
        if (this.referenceParameters != null) {
            buffer.append(", Reference Parameters: ").append(this.referenceParameters);
        }
        if (this.extensibleElements != null) {
            buffer.append(", Extensibility elements: ").append(this.extensibleElements);
        }
        if (this.attributes != null) {
            buffer.append(", Attributes: ").append(this.attributes);
        }
        return buffer.toString();
    }

    public void fromOM(OMElement eprOMElement) {
        OMElement metaDataElement;
        OMElement addressElement = eprOMElement.getFirstChildWithName(new QName("Address"));
        this.setAddress(addressElement.getText());
        Iterator allAddrAttributes = addressElement.getAllAttributes();
        if (this.addressAttributes == null) {
            this.addressAttributes = new ArrayList();
        }
        while (allAddrAttributes.hasNext()) {
            OMAttribute attribute = (OMAttribute)allAddrAttributes.next();
            this.addressAttributes.add(attribute);
        }
        OMElement refParamElement = eprOMElement.getFirstChildWithName(new QName("ReferenceParameters"));
        if (refParamElement != null) {
            Iterator refParams = refParamElement.getChildElements();
            while (refParams.hasNext()) {
                OMElement omElement = (OMElement)refParams.next();
                this.addReferenceParameter(omElement);
            }
        }
        if ((metaDataElement = eprOMElement.getFirstChildWithName(new QName("Metadata"))) != null) {
            Iterator children = metaDataElement.getChildren();
            while (children.hasNext()) {
                OMNode omNode = (OMNode)children.next();
                this.addMetaData(omNode);
            }
        }
        this.setName(eprOMElement.getLocalName());
        Iterator allAttributes = eprOMElement.getAllAttributes();
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        while (allAttributes.hasNext()) {
            OMAttribute attribute = (OMAttribute)allAttributes.next();
            this.attributes.add(attribute);
        }
        Iterator childElements = eprOMElement.getChildElements();
        while (childElements.hasNext()) {
            OMElement eprChildElement = (OMElement)childElements.next();
            String localName = eprChildElement.getLocalName();
            if (localName.equals("Address") || localName.equals("ReferenceParameters") || localName.equals("Metadata")) continue;
            this.addExtensibleElement(eprChildElement);
        }
    }

    public OMElement toOM(String nsurl, String localName, String prefix) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        if (prefix != null) {
            ArrayList omElements;
            OMAttribute omAttributes;
            Iterator attrIter;
            OMNamespace wrapNs = fac.createOMNamespace(nsurl, prefix);
            OMElement epr = fac.createOMElement(localName, wrapNs);
            OMNamespace wsaNS = fac.createOMNamespace("http://www.w3.org/2005/08/addressing", "wsa");
            OMElement addressE = fac.createOMElement("Address", wsaNS, (OMContainer)epr);
            addressE.setText(this.address);
            if (this.addressAttributes != null) {
                attrIter = this.addressAttributes.iterator();
                while (attrIter.hasNext()) {
                    omAttributes = (OMAttribute)attrIter.next();
                    addressE.addAttribute(omAttributes);
                }
            }
            if (this.metaData != null) {
                OMElement metadataE = fac.createOMElement("Metadata", wsaNS, (OMContainer)epr);
                Iterator metadata = this.metaData.iterator();
                while (metadata.hasNext()) {
                    metadataE.addChild((OMNode)metadata.next());
                }
            }
            if (this.referenceParameters != null) {
                OMElement refParameterElement = fac.createOMElement("ReferenceParameters", wsaNS, (OMContainer)epr);
                Iterator refParms = this.referenceParameters.values().iterator();
                while (refParms.hasNext()) {
                    refParameterElement.addChild((OMNode)refParms.next());
                }
            }
            if (this.attributes != null) {
                attrIter = this.attributes.iterator();
                while (attrIter.hasNext()) {
                    omAttributes = (OMAttribute)attrIter.next();
                    epr.addAttribute(omAttributes);
                }
            }
            if ((omElements = this.extensibleElements) != null) {
                for (int i = 0; i < omElements.size(); ++i) {
                    epr.addChild((OMNode)((OMElement)omElements.get(i)));
                }
            }
            return epr;
        }
        throw new AxisFault("prefix must be specified");
    }

    public boolean isEquivalent(EndpointReference epr) {
        if (this.name != null && epr.getName() != null) {
            if (!this.name.equals(epr.getName())) {
                return false;
            }
        } else if (this.name != null || epr.getName() != null) {
            return false;
        }
        if (this.address != null && epr.getAddress() != null) {
            if (!this.address.equals(epr.getAddress())) {
                return false;
            }
        } else if (this.address != null || epr.getAddress() != null) {
            return false;
        }
        ArrayList eprMetaData = epr.getMetaData();
        if (this.metaData != null && eprMetaData != null) {
            if (!this.metaData.equals(eprMetaData)) {
                return false;
            }
        } else if (this.metaData != null || eprMetaData != null) {
            return false;
        }
        ArrayList eprExtensibleElements = epr.getExtensibleElements();
        if (this.extensibleElements != null && eprExtensibleElements != null) {
            if (!this.extensibleElements.equals(eprExtensibleElements)) {
                return false;
            }
        } else if (this.extensibleElements != null || eprExtensibleElements != null) {
            return false;
        }
        ArrayList eprAttributes = epr.getAttributes();
        if (this.attributes != null && eprAttributes != null) {
            if (!this.attributes.equals(eprAttributes)) {
                return false;
            }
        } else if (this.attributes != null || eprAttributes != null) {
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        OMElement om = EndpointReferenceHelper.toOM(OMAbstractFactory.getOMFactory(), this, new QName("urn:axis2", "omepr", "ser"), "http://www.w3.org/2005/08/addressing");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            om.serialize((OutputStream)baos);
        }
        catch (XMLStreamException e) {
            throw (IOException)new IOException("Unable to serialize the EPR").initCause(e);
        }
        out.writeInt(baos.size());
        out.write(baos.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int numBytes = in.readInt();
        byte[] serBytes = new byte[numBytes];
        in.read(serBytes, 0, numBytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(serBytes);
        XMLStreamReader xmlReader = null;
        try {
            xmlReader = StAXUtils.createXMLStreamReader((InputStream)bais);
            StAXOMBuilder builder = new StAXOMBuilder(xmlReader);
            OMElement om = builder.getDocumentElement();
            EndpointReferenceHelper.fromOM(this, om, "http://www.w3.org/2005/08/addressing");
        }
        catch (XMLStreamException e) {
            throw (IOException)new IOException("Unable to deserialize the EPR").initCause(e);
        }
        finally {
            if (xmlReader != null) {
                try {
                    xmlReader.close();
                }
                catch (XMLStreamException e) {
                    throw (IOException)new IOException("Unable to deserialize the EPR").initCause(e);
                }
            }
            if (bais != null) {
                bais.close();
            }
        }
    }
}

