/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Event;
import org.activiti.engine.task.Task;
import org.activiti.rest.service.api.engine.EventResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskEventResource
extends TaskBaseResource {
    @RequestMapping(value={"/runtime/tasks/{taskId}/events/{eventId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public EventResponse getEvent(@PathVariable(value="taskId") String taskId, @PathVariable(value="eventId") String eventId, HttpServletRequest request) {
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        Event event = this.taskService.getEvent(eventId);
        if (event == null || !task.getId().equals(event.getTaskId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an event with id '" + eventId + "'.", Event.class);
        }
        return this.restResponseFactory.createEventResponse(event);
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/events/{eventId}"}, method={RequestMethod.DELETE})
    public void deleteEvent(@PathVariable(value="taskId") String taskId, @PathVariable(value="eventId") String eventId, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        Event event = this.taskService.getEvent(eventId);
        if (event == null || event.getTaskId() == null || !event.getTaskId().equals(task.getId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an event with id '" + event + "'.", Event.class);
        }
        this.taskService.deleteComment(eventId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

