/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HistoricProcessInstanceVariableDataResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;

    @RequestMapping(value={"/history/historic-process-instances/{processInstanceId}/variables/{variableName}/data"}, method={RequestMethod.GET})
    @ResponseBody
    public byte[] getVariableData(@PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="variableName") String variableName, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] result = null;
            RestVariable variable = this.getVariableFromRequest(true, processInstanceId, variableName, request);
            if ("binary".equals(variable.getType())) {
                result = (byte[])variable.getValue();
                response.setContentType("application/octet-stream");
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                result = buffer.toByteArray();
                response.setContentType("application/x-java-serialized-object");
            } else {
                throw new ActivitiObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new ActivitiException("Unexpected exception getting variable data", (Throwable)ioe);
        }
    }

    public RestVariable getVariableFromRequest(boolean includeBinary, String processInstanceId, String variableName, HttpServletRequest request) {
        HistoricProcessInstance processObject = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).includeProcessVariables().singleResult();
        if (processObject == null) {
            throw new ActivitiObjectNotFoundException("Historic process instance '" + processInstanceId + "' couldn't be found.", HistoricProcessInstanceEntity.class);
        }
        Object value = processObject.getProcessVariables().get(variableName);
        if (value == null) {
            throw new ActivitiObjectNotFoundException("Historic process instance '" + processInstanceId + "' variable value for " + variableName + " couldn't be found.", VariableInstanceEntity.class);
        }
        return this.restResponseFactory.createRestVariable(variableName, value, null, processInstanceId, 5, includeBinary);
    }
}

