/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.common.application;

import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.application.ActivitiStatusService;
import org.activiti.rest.common.application.DefaultMediaTypeResolver;
import org.activiti.rest.common.application.MediaTypeResolver;
import org.activiti.rest.common.filter.RestAuthenticator;
import org.restlet.Application;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeScheme;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.SecretVerifier;
import org.restlet.security.Verifier;

public abstract class ActivitiRestApplication
extends Application {
    protected ChallengeAuthenticator authenticator;
    protected ActivitiStatusService activitiStatusService = new ActivitiStatusService();
    protected MediaTypeResolver mediaTypeResolver;
    protected RestAuthenticator restAuthenticator;

    public ActivitiRestApplication() {
        this.setStatusService(this.activitiStatusService);
    }

    public MediaTypeResolver getMediaTypeResolver() {
        if (this.mediaTypeResolver == null) {
            this.mediaTypeResolver = new DefaultMediaTypeResolver();
        }
        return this.mediaTypeResolver;
    }

    public void setRestAuthenticator(RestAuthenticator restAuthenticator) {
        this.restAuthenticator = restAuthenticator;
    }

    public void setMediaTypeResolver(MediaTypeResolver mediaTypeResolver) {
        this.mediaTypeResolver = mediaTypeResolver;
    }

    public void initializeAuthentication() {
        SecretVerifier verifier = new SecretVerifier(){

            public int verify(String username, char[] password) throws IllegalArgumentException {
                boolean verified = ActivitiUtil.getIdentityService().checkPassword(username, new String(password));
                if (verified) {
                    return 4;
                }
                return -1;
            }
        };
        this.authenticator = new ChallengeAuthenticator(null, true, ChallengeScheme.HTTP_BASIC, "Activiti Realm"){

            protected boolean authenticate(Request request, Response response) {
                if (ActivitiRestApplication.this.restAuthenticator != null && !ActivitiRestApplication.this.restAuthenticator.requestRequiresAuthentication(request)) {
                    return true;
                }
                if (request.getChallengeResponse() == null) {
                    return false;
                }
                boolean authenticated = super.authenticate(request, response);
                if (authenticated && ActivitiRestApplication.this.restAuthenticator != null) {
                    authenticated = ActivitiRestApplication.this.restAuthenticator.isRequestAuthorized(request);
                }
                return authenticated;
            }
        };
        this.authenticator.setVerifier((Verifier)verifier);
    }

    public String authenticate(Request request, Response response) {
        if (!request.getClientInfo().isAuthenticated()) {
            this.authenticator.challenge(response, false);
            return null;
        }
        return request.getClientInfo().getUser().getIdentifier();
    }
}

