/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.filter.DateValueFilter;
import com.mingsoft.base.filter.DoubleValueFilter;
import com.mingsoft.basic.biz.IColumnBiz;
import com.mingsoft.basic.entity.ColumnEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.mdiy.action.BaseAction;
import com.mingsoft.mdiy.biz.IContentModelFieldBiz;
import com.mingsoft.mdiy.biz.ISearchBiz;
import com.mingsoft.mdiy.constant.Const;
import com.mingsoft.mdiy.entity.ContentModelFieldEntity;
import com.mingsoft.mdiy.entity.SearchEntity;
import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/mdiy/search"})
public class SearchAction
extends BaseAction {
    @Autowired
    private ISearchBiz searchBiz;
    @Autowired
    private IColumnBiz columnBiz;
    @Autowired
    private IContentModelFieldBiz fieldBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        model.addAttribute("searchType", (Object)BasicUtil.resToMap((String)"com.mingsoft.mdiy.resources.search_type"));
        return this.view("/mdiy/search/index");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute SearchEntity search, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (search == null) {
            search = new SearchEntity();
        }
        search.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List searchList = this.searchBiz.query((BaseEntity)search);
        this.outJson(response, (Object)JSONArray.toJSONString((Object)new EUListBean(searchList, (int)BasicUtil.endPage((List)searchList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @RequestMapping(value={"/form"})
    public void form(@ModelAttribute SearchEntity search, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (search.getSearchId() <= 0) {
            this.outJson(response, false);
            return;
        }
        SearchEntity searchEntity = (SearchEntity)this.searchBiz.getEntity((BaseEntity)search);
        this.outJson(response, (BaseEntity)searchEntity);
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute SearchEntity search, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (search.getSearchId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("search.id")}));
            return;
        }
        SearchEntity _search = (SearchEntity)this.searchBiz.getEntity(search.getSearchId());
        this.outJson(response, (BaseEntity)_search);
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:search:save"})
    public void save(@ModelAttribute SearchEntity search, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((String)search.getSearchType())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("search.type")}));
            return;
        }
        if (!StringUtil.checkLength((String)(search.getSearchType() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("search.type"), "1", "255"}));
            return;
        }
        if (StringUtil.isBlank((String)search.getSearchName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("search.name")}));
            return;
        }
        if (!StringUtil.checkLength((String)(search.getSearchName() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("search.name"), "1", "255"}));
            return;
        }
        search.setAppId(BasicUtil.getAppId());
        this.searchBiz.saveEntity((BaseEntity)search);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)search));
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:search:del"})
    public void delete(@RequestBody List<SearchEntity> searchs, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[searchs.size()];
        for (int i = 0; i < searchs.size(); ++i) {
            ids[i] = searchs.get(i).getSearchId();
        }
        this.searchBiz.delete(ids);
        this.outJson(response, true);
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:search:update"})
    public void update(@ModelAttribute SearchEntity search, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((String)search.getSearchType())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("search.type")}));
            return;
        }
        if (!StringUtil.checkLength((String)(search.getSearchType() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("search.type"), "1", "255"}));
            return;
        }
        this.searchBiz.updateEntity((BaseEntity)search);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)search));
    }

    @RequestMapping(value={"/{columnId}/queryFieldName"})
    @ResponseBody
    public Map queryFieldName(@PathVariable int columnId, HttpServletRequest request) {
        HashMap<String, List> model = new HashMap<String, List>();
        ColumnEntity column = (ColumnEntity)this.columnBiz.getEntity(columnId);
        if (column != null) {
            int fieldCmid = column.getColumnContentModelId();
            List listField = this.fieldBiz.queryListByCmid(fieldCmid);
            model.put("listField", listField);
        }
        return model;
    }

    @RequestMapping(value={"/generateSreachFormHtml"})
    public String generateSreachFormHtml(ModelMap model, HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int searchId = 0;
        if (!StringUtil.isBlank((String)request.getParameter("searchId"))) {
            searchId = Integer.valueOf(request.getParameter("searchId"));
        }
        Map field = new HashMap();
        field = request.getParameterMap();
        int basicCategoryId = 0;
        int cmId = 0;
        Map basicField = this.getMapByProperties(Const.BASIC_FIELD);
        Map basicAttribute = this.getMapByProperties(Const.BASIC_ATTRIBUTE);
        ArrayList listFieldName = new ArrayList();
        for (Map.Entry entry : field.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((String[])entry.getValue())[0];
            if (key.equals("columnId") && !StringUtil.isBlank((String)value) && !key.equals("searchId")) {
                basicCategoryId = Integer.valueOf(value);
            }
            if (key.equals("columnId") || key.equals("searchId")) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", key);
            map.put("type", value);
            if (!StringUtil.isBlank((String)((String)basicField.get(key)))) {
                map.put("ch", (String)basicField.get(key));
            } else {
                ContentModelFieldEntity fieldEntity;
                if (basicCategoryId != 0) {
                    ColumnEntity column = (ColumnEntity)this.columnBiz.getEntity(Integer.valueOf(basicCategoryId).intValue());
                    cmId = column.getColumnContentModelId();
                }
                if (!StringUtil.isBlank((Object)(fieldEntity = this.fieldBiz.getEntityByCmId(cmId, key)))) {
                    String fieldTipsName = fieldEntity.getFieldTipsName();
                    map.put("ch", fieldTipsName);
                }
            }
            if (key.equals("article_type")) {
                map.put("default", basicAttribute.toString());
            } else {
                map.put("default", key.toString());
            }
            listFieldName.add(map);
        }
        model.addAttribute("searchId", (Object)searchId);
        model.addAttribute("websiteId", (Object)managerSession.getBasicId());
        model.addAttribute("listFieldName", listFieldName);
        model.addAttribute("basicCategoryId", (Object)basicCategoryId);
        return this.view("/mdiy/search/search_field");
    }

    @RequestMapping(value={"/{searchId}/searchCode"})
    public String searchCode(@PathVariable int searchId, ModelMap model, HttpServletRequest request) {
        List columnList = this.columnBiz.queryColumnListByWebsiteId(this.getAppId(request));
        SearchEntity searchEntity = new SearchEntity();
        searchEntity.setSearchId(searchId);
        SearchEntity search = (SearchEntity)this.searchBiz.getEntity((BaseEntity)searchEntity);
        model.addAttribute("columnList", (Object)JSONArray.toJSONString((Object)columnList, (SerializeFilter[])new SerializeFilter[0]));
        model.addAttribute("searchId", (Object)searchId);
        model.addAttribute("searchType", (Object)search.getSearchType());
        return this.view("/mdiy/search/search_code");
    }
}

