/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.filter.DateValueFilter;
import com.mingsoft.base.filter.DoubleValueFilter;
import com.mingsoft.basic.constant.e.SessionConstEnum;
import com.mingsoft.basic.entity.ManagerEntity;
import com.mingsoft.mdiy.action.BaseAction;
import com.mingsoft.mdiy.biz.IFormBiz;
import com.mingsoft.mdiy.biz.IFormFieldBiz;
import com.mingsoft.mdiy.entity.FormEntity;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/mdiy/form"})
public class FormAction
extends BaseAction {
    private static final String TABLE_NAME_PREFIX = "mdiy_";
    private static final String TABLE_NAME_SPLIT = "_";
    @Autowired
    IFormBiz formBiz;
    @Autowired
    IFormFieldBiz formFieldBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return this.view("/mdiy/form/index");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute FormEntity form, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        form.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List formList = this.formBiz.query((BaseEntity)form);
        this.outJson(response, (Object)JSONArray.toJSONString((Object)new EUListBean(formList, (int)BasicUtil.endPage((List)formList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @RequestMapping(value={"/form"})
    public String form(@ModelAttribute FormEntity form, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (form.getFormId() != null) {
            FormEntity formEntity = (FormEntity)this.formBiz.getEntity(form.getFormId().intValue());
            model.addAttribute("formEntity", (Object)formEntity);
        }
        return this.view("/mdiy/form/form");
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute FormEntity form, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (form.getFormId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("form.id")}));
            return;
        }
        FormEntity _form = (FormEntity)this.formBiz.getEntity(form.getFormId().intValue());
        this.outJson(response, (BaseEntity)_form);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public void delete(@RequestBody List<FormEntity> forms, HttpServletResponse response, HttpServletRequest request) {
        for (int i = 0; i < forms.size(); ++i) {
            FormEntity form = (FormEntity)this.formBiz.getEntity(forms.get(i).getFormId().intValue());
            if (form == null) {
                this.outJson(response, null, false, this.getResString("err.not.exist", new String[]{this.getResString("diy.form")}));
                return;
            }
            this.formBiz.dropTable(form.getFormTableName());
            this.formBiz.deleteEntity(forms.get(i).getFormId().intValue());
        }
        this.outJson(response, true);
    }

    @RequestMapping(value={"/save"})
    @RequiresPermissions(value={"mdiy:form:save"})
    public void save(@ModelAttribute FormEntity form, HttpServletRequest request, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)form.getFormTableName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldTipsName"), "1", "20"}));
            return;
        }
        if (!StringUtil.checkLength((String)form.getFormTipsName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldFieldName"), "1", "20"}));
            return;
        }
        ManagerEntity managerSession = (ManagerEntity)this.getSession(request, (BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        int managerId = managerSession.getManagerId();
        String formTableName = TABLE_NAME_PREFIX + form.getFormTableName() + TABLE_NAME_SPLIT + managerId;
        FormEntity _form = new FormEntity();
        _form.setFormTableName(formTableName);
        if (this.formBiz.getEntity((BaseEntity)_form) != null) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("diy.form.table.name")}));
            return;
        }
        int appId = this.getAppId(request);
        form.setAppId(BasicUtil.getAppId());
        String tableName = TABLE_NAME_PREFIX + form.getFormTableName() + TABLE_NAME_SPLIT + managerId;
        form.setFormTableName(tableName);
        this.formBiz.createDiyFormTable(form.getFormTableName(), null);
        this.formBiz.saveEntity((BaseEntity)form);
        _form.setAppId(BasicUtil.getAppId());
        _form = (FormEntity)this.formBiz.getEntity((BaseEntity)_form);
        int diyFormId = _form.getFormId();
        this.outJson(response, null, true, String.valueOf(diyFormId));
    }

    @RequestMapping(value={"/update"})
    @RequiresPermissions(value={"mdiy:form:update"})
    public void update(@ModelAttribute FormEntity form, HttpServletResponse response, HttpServletRequest request) {
        if (!StringUtil.checkLength((String)form.getFormTableName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldTipsName"), "1", "20"}));
            return;
        }
        if (!StringUtil.checkLength((String)form.getFormTipsName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldFieldName"), "1", "20"}));
            return;
        }
        FormEntity _form = new FormEntity();
        _form.setFormTableName(form.getFormTableName());
        _form.setAppId(BasicUtil.getAppId());
        _form = (FormEntity)this.formBiz.getEntity((BaseEntity)_form);
        int formId = _form.getFormId();
        form.setFormId(Integer.valueOf(formId));
        this.formBiz.updateEntity((BaseEntity)form);
        this.outJson(response, null, true, String.valueOf(formId));
    }

    @RequestMapping(value={"/checkTableNameExist"})
    public void checkTableNameExist(@ModelAttribute FormEntity form, HttpServletRequest request, HttpServletResponse response) {
        ManagerEntity managerSession = (ManagerEntity)this.getSession(request, (BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        int managerId = managerSession.getManagerId();
        String formTableName = TABLE_NAME_PREFIX + form.getFormTableName() + TABLE_NAME_SPLIT + managerId;
        FormEntity _form = new FormEntity();
        _form.setFormTableName(formTableName);
        _form = (FormEntity)this.formBiz.getEntity((BaseEntity)_form);
        if (_form == null) {
            this.outJson(response, null, false);
            return;
        }
        this.outJson(response, null, true);
    }

    @RequestMapping(value={"/querydata"})
    public String query(@ModelAttribute FormEntity form, HttpServletRequest request, ModelMap model) {
        int pageNo = 1;
        if (request.getParameter("pageNo") != null) {
            pageNo = Integer.parseInt(request.getParameter("pageNo"));
        }
        int appId = BasicUtil.getAppId();
        int count = this.formBiz.countDiyFormData(form.getFormId().intValue(), appId);
        PageUtil page = new PageUtil(pageNo, 30, count, "/manager/diy_form/" + form.getFormId() + "/query.do");
        Map map = this.formBiz.queryDiyFormData(form.getFormId().intValue(), appId, page);
        if (map != null) {
            if (map.get("fields") != null) {
                model.addAttribute("fields", map.get("fields"));
            }
            if (map.get("list") != null) {
                model.addAttribute("list", map.get("list"));
            }
        }
        model.addAttribute("title", (Object)request.getParameter("title"));
        model.addAttribute("page", (Object)page);
        return this.view("/mdiy/diy_form/diy_form_data_list");
    }

    @RequestMapping(value={"/{diyFormId}/{id}/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:form:del"})
    public void delete(@PathVariable(value="id") int id, @PathVariable(value="diyFormId") int diyFormId, HttpServletRequest request, HttpServletResponse response) {
        this.formBiz.deleteQueryDiyFormData(id, diyFormId);
        this.outJson(response, null, true);
    }
}

