/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.SslContextBuilder;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.okio.BufferedSink;
import com.squareup.okhttp.internal.okio.Okio;
import com.squareup.okhttp.internal.okio.Sink;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.IncomingStreamHandler;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import com.squareup.okhttp.internal.spdy.SpdyStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.jetty.npn.NextProtoNego;

public final class SpdyServer
implements IncomingStreamHandler {
    private final File baseDirectory;
    private SSLSocketFactory sslSocketFactory;

    public SpdyServer(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void useHttps(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    private void run() throws Exception {
        ServerSocket serverSocket = new ServerSocket(8888);
        serverSocket.setReuseAddress(true);
        while (true) {
            Socket socket = serverSocket.accept();
            if (this.sslSocketFactory != null) {
                socket = this.doSsl(socket);
            }
            new SpdyConnection.Builder(false, socket).handler((IncomingStreamHandler)this).build();
        }
    }

    private Socket doSsl(Socket socket) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        sslSocket.setUseClientMode(false);
        NextProtoNego.put((SSLSocket)sslSocket, (NextProtoNego.Provider)new NextProtoNego.ServerProvider(){

            public void unsupported() {
                System.out.println("UNSUPPORTED");
            }

            public List<String> protocols() {
                return Arrays.asList(Protocol.SPDY_3.name.utf8());
            }

            public void protocolSelected(String protocol) {
                System.out.println("PROTOCOL SELECTED: " + protocol);
            }
        });
        return sslSocket;
    }

    public void receive(SpdyStream stream) throws IOException {
        List requestHeaders = stream.getRequestHeaders();
        String path = null;
        for (int i = 0; i < requestHeaders.size(); ++i) {
            if (!((Header)requestHeaders.get((int)i)).name.equals((Object)Header.TARGET_PATH)) continue;
            path = ((Header)requestHeaders.get((int)i)).value.utf8();
            break;
        }
        if (path == null) {
            throw new AssertionError();
        }
        File file = new File(this.baseDirectory + path);
        if (file.isDirectory()) {
            this.serveDirectory(stream, file.list());
        } else if (file.exists()) {
            this.serveFile(stream, file);
        } else {
            this.send404(stream, path);
        }
    }

    private void send404(SpdyStream stream, String path) throws IOException {
        List responseHeaders = Util.headerEntries((String[])new String[]{":status", "404", ":version", "HTTP/1.1", "content-type", "text/plain"});
        stream.reply(responseHeaders, true);
        BufferedSink out = Okio.buffer((Sink)stream.getSink());
        out.writeUtf8("Not found: " + path);
        out.close();
    }

    private void serveDirectory(SpdyStream stream, String[] files) throws IOException {
        List responseHeaders = Util.headerEntries((String[])new String[]{":status", "200", ":version", "HTTP/1.1", "content-type", "text/html; charset=UTF-8"});
        stream.reply(responseHeaders, true);
        BufferedSink out = Okio.buffer((Sink)stream.getSink());
        for (String file : files) {
            out.writeUtf8("<a href='" + file + "'>" + file + "</a><br>");
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFile(SpdyStream stream, File file) throws IOException {
        byte[] buffer = new byte[8192];
        stream.reply(Util.headerEntries((String[])new String[]{":status", "200", ":version", "HTTP/1.1", "content-type", this.contentType(file)}), true);
        FileInputStream in = new FileInputStream(file);
        BufferedSink out = Okio.buffer((Sink)stream.getSink());
        try {
            int count;
            while ((count = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
        }
        finally {
            Util.closeQuietly((Closeable)in);
            Util.closeQuietly((Closeable)out);
        }
    }

    private String contentType(File file) {
        return file.getName().endsWith(".html") ? "text/html" : "text/plain";
    }

    public static void main(String ... args) throws Exception {
        if (args.length != 1 || args[0].startsWith("-")) {
            System.out.println("Usage: SpdyServer <base directory>");
            return;
        }
        SpdyServer server = new SpdyServer(new File(args[0]));
        server.useHttps(SslContextBuilder.localhost().getSocketFactory());
        server.run();
    }
}

