/*
 * Decompiled with CFR 0.152.
 */
package org.nico.ourbatis.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nico.ourbatis.xml.Document;
import org.nico.ourbatis.xml.DocumentType;
import org.nico.ourbatis.xml.DocumentUtils;
import org.nico.ourbatis.xml.SmartScanner;

public class SimpleScanner
extends SmartScanner {
    private Document currentDocument;
    private LinkedList<Document> results = new LinkedList();
    private int singleCount = 0;
    private int doubleCount = 0;
    private int tagCount = 0;
    public static final Map<String, String> SPECIAL_NAMES = new HashMap<String, String>(){
        private static final long serialVersionUID = 6675296460361731643L;
        {
            this.put("?xml", "?");
            this.put("!--", "--");
        }
    };
    public static final Set<String> NOTAIL_NAMES = new HashSet<String>(){
        private static final long serialVersionUID = 6675296460361731643L;
        {
            this.add("!DOCTYPE");
            this.add("img");
        }
    };

    public SimpleScanner(String value) {
        super(value);
    }

    @Override
    protected SmartScanner.Status parseStart(char c) {
        if (c == '<' && !this.cut(2).equals("</")) {
            this.currentDocument = new Document();
            this.currentDocument.setBeforeContent(this.builder.toString());
            if (!this.results.isEmpty()) {
                Document lastDoc = this.results.getLast();
                this.currentDocument.setPre(lastDoc);
                lastDoc.setNext(this.currentDocument);
                lastDoc.setAfterContent(this.currentDocument.getBeforeContent());
            }
            this.builder.setLength(0);
            return SmartScanner.Status.HEAD;
        }
        if (this.isLast()) {
            this.append(c);
            if (!this.results.isEmpty()) {
                this.results.getLast().setAfterContent(this.builder.toString());
            }
            this.builder.setLength(0);
        } else {
            this.append(c);
        }
        return SmartScanner.Status.START;
    }

    @Override
    protected SmartScanner.Status parseHead(char c) {
        if (this.builder.toString().equals("!--")) {
            return SmartScanner.Status.ANNOTATION;
        }
        String special = SPECIAL_NAMES.get(this.builder.toString());
        if (c == ' ' || c == '\t' || c == '\n' || c == '>' || this.cut(2).equals("/>") || special != null && this.cut(special.length()).equals(special)) {
            String name = this.builder.toString();
            if (c == '\n') {
                name = name.replaceAll("\r", "");
            }
            this.currentDocument.setName(name);
            ++this.tagCount;
            this.builder.setLength(0);
            if (c == ' ' || c == '\t' || c == '\n') {
                return SmartScanner.Status.PARAM;
            }
            if (NOTAIL_NAMES.contains(this.currentDocument.getName())) {
                this.currentDocument.setType(DocumentType.SINGLE);
                this.currentDocument.setTail("");
                return this.parseFinished();
            }
            if (c == '>') {
                this.currentDocument.setType(DocumentType.DOUBLE);
                return SmartScanner.Status.BODY;
            }
            if (this.cut(2).equals("/>")) {
                this.currentDocument.setType(DocumentType.SINGLE);
                this.currentDocument.setTail("/");
                return SmartScanner.Status.BODY;
            }
            this.currentDocument.setType(DocumentType.SINGLE);
            this.currentDocument.setTail(special);
            this.move(this.currentDocument.getTail().length());
            return this.parseFinished();
        }
        this.append(c);
        return SmartScanner.Status.HEAD;
    }

    @Override
    protected SmartScanner.Status parseAnnotation(char c) {
        this.append(c);
        if (this.builder.toString().endsWith("-->")) {
            this.builder.setLength(0);
            return SmartScanner.Status.START;
        }
        return SmartScanner.Status.ANNOTATION;
    }

    @Override
    protected SmartScanner.Status parseParam(char c) {
        this.quotesFilter(c);
        String special = SPECIAL_NAMES.get(this.currentDocument.getName());
        if (this.quotesIsClose() && (c == '>' || this.cut(2).equals("/>") || special != null && this.cut(special.length()).equals(special))) {
            String params = this.builder.toString();
            this.currentDocument.setParameterString(params);
            this.currentDocument.setParameters(DocumentUtils.parseParameters(params));
            this.builder.setLength(0);
            if (NOTAIL_NAMES.contains(this.currentDocument.getName())) {
                this.currentDocument.setType(DocumentType.SINGLE);
                this.currentDocument.setTail("");
                return this.parseFinished();
            }
            if (c == '>') {
                this.currentDocument.setType(DocumentType.DOUBLE);
                return SmartScanner.Status.BODY;
            }
            if (this.cut(2).equals("/>")) {
                this.move(1);
                this.currentDocument.setType(DocumentType.SINGLE);
                this.currentDocument.setTail("/");
                return this.parseFinished();
            }
            this.currentDocument.setType(DocumentType.SINGLE);
            this.currentDocument.setTail(this.cut(special.length()));
            this.move(this.currentDocument.getTail().length());
            return this.parseFinished();
        }
        this.append(c);
        return SmartScanner.Status.PARAM;
    }

    @Override
    protected SmartScanner.Status parseBody(char c) {
        if (c == '<') {
            String name = this.currentDocument.getName();
            if (this.cut(1 + name.length()).equals("<" + name)) {
                ++this.tagCount;
            } else if (this.cut(2 + name.length()).equals("</" + name)) {
                --this.tagCount;
            }
            if (this.tagCount == 0) {
                String body = this.builder.toString();
                this.currentDocument.setContent(body);
                this.builder.setLength(0);
                this.move(2 + name.length());
                return this.parseFinished();
            }
        }
        this.append(c);
        return SmartScanner.Status.BODY;
    }

    @Override
    protected SmartScanner.Status parseFinished() {
        this.tagCount = 0;
        this.results.add(this.currentDocument);
        List<Document> childs = new SimpleScanner(this.currentDocument.getContent()).scan().results();
        if (childs != null && !childs.isEmpty()) {
            this.currentDocument.setChilds(childs);
            childs.forEach(doc -> doc.setParent(this.currentDocument));
        }
        return SmartScanner.Status.START;
    }

    @Override
    public List<Document> results() {
        return this.results;
    }

    public void quotesFilter(char c) {
        if (c == '\'') {
            if (this.singleIsClose()) {
                if (this.doubleIsClose()) {
                    this.singleCount = 1;
                }
            } else {
                this.singleCount = 0;
            }
        } else if (c == '\"') {
            if (this.doubleIsClose()) {
                if (this.singleIsClose()) {
                    this.doubleCount = 1;
                }
            } else {
                this.doubleCount = 0;
            }
        }
    }

    public boolean doubleIsClose() {
        return this.doubleCount == 0;
    }

    public boolean singleIsClose() {
        return this.singleCount == 0;
    }

    public boolean quotesIsClose() {
        return this.doubleIsClose() && this.singleIsClose();
    }
}

