/*
 * Decompiled with CFR 0.152.
 */
package org.nico.ourbatis.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.nico.ourbatis.annotation.MapperBy;
import org.nico.ourbatis.annotation.RenderIgnore;
import org.nico.ourbatis.annotation.RenderName;
import org.nico.ourbatis.annotation.RenderPrimary;

public class ReflectUtils {
    public static Field[] getFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    public static <T extends Annotation> T getAnnotation(Field field, Class<T> annotationType) {
        return field.getDeclaredAnnotation(annotationType);
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationType) {
        return clazz.getDeclaredAnnotation(annotationType);
    }

    public static boolean isAnnotation(Field field, Class<? extends Annotation> annotationType) {
        return ReflectUtils.getAnnotation(field, annotationType) != null;
    }

    public static boolean isAnnotation(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return ReflectUtils.getAnnotation(clazz, annotationType) != null;
    }

    public static boolean isRenderIgnore(Field field) {
        return ReflectUtils.isAnnotation(field, RenderIgnore.class);
    }

    public static boolean isRenderPrimary(Field field) {
        return ReflectUtils.isAnnotation(field, RenderPrimary.class);
    }

    public static boolean isRenderName(Field field) {
        return ReflectUtils.isAnnotation(field, RenderName.class);
    }

    public static boolean isRenderName(Class<?> clazz) {
        return ReflectUtils.isAnnotation(clazz, RenderName.class);
    }

    public static boolean isMapperBy(Class<?> clazz) {
        return ReflectUtils.isAnnotation(clazz, MapperBy.class);
    }

    public static Class<?> getMapperBy(Class<?> clazz) {
        return ReflectUtils.getAnnotation(clazz, MapperBy.class).value();
    }

    public static String getRenderName(Field field) {
        return ReflectUtils.getAnnotation(field, RenderName.class).value();
    }

    public static String getRenderName(Class<?> clazz) {
        return ReflectUtils.getAnnotation(clazz, RenderName.class).value();
    }

    public static Object getFieldValue(String fieldName, Object obj) {
        Object target = null;
        Field field = ReflectUtils.getField(fieldName, obj.getClass());
        if (field != null) {
            try {
                field.setAccessible(true);
                target = field.get(obj);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return target;
    }

    public static Field getField(String fieldName, Class<?> clazz) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                field = ReflectUtils.getField(fieldName, clazz.getSuperclass());
            }
            return null;
        }
        return field;
    }
}

