/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.InfrastructureException;
import com.seeyon.ctp.common.init.MclclzUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class CTPLocalSessionFactoryBean
extends LocalSessionFactoryBean {
    private static final Log LOGGER = CtpLogFactory.getLog(CTPLocalSessionFactoryBean.class);
    private static final Class c1 = MclclzUtil.ioiekc((String)"com.seeyon.ctp.common.plugin.PluginSystemInit");

    public void setHibernateProperties(Properties hibernateProperties) {
        if (!AppContext.isRunningModeDevelop()) {
            hibernateProperties.remove("hibernate.hbm2ddl.auto");
        }
        super.setHibernateProperties(hibernateProperties);
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        List plugins;
        boolean isRunningTestMode = "true".equals(System.getProperty("ctp.mode.test"));
        try {
            Method mainMethod = c1.getMethod("getInstance", new Class[0]);
            Object obj = mainMethod.invoke(null, null);
            Method initMethod = c1.getMethod("getPluginIds", new Class[0]);
            plugins = (List)initMethod.invoke(obj, null);
        }
        catch (Exception e) {
            throw new InfrastructureException(e);
        }
        ArrayList<Resource> newMappingResources = new ArrayList<Resource>();
        HashMap<String, String> hbmMap = new HashMap<String, String>();
        for (int i = 0; i < mappingLocations.length; ++i) {
            Resource res = mappingLocations[i];
            boolean added = false;
            String hbmPathStr = "";
            try {
                hbmPathStr = res.getURL().getPath();
                int idx = hbmPathStr.lastIndexOf("seeyon/");
                if (idx != -1) {
                    String tmpStr = hbmPathStr.substring(idx + 7);
                    if (hbmMap.containsKey(tmpStr)) {
                        String dupStr = (String)hbmMap.get(tmpStr);
                        LOGGER.warn((Object)("***** Ignored HBM[" + hbmPathStr + "],duplicated with '" + dupStr + "'"));
                        added = true;
                    } else {
                        hbmMap.put(tmpStr, hbmPathStr);
                        if (tmpStr.startsWith("ctp")) {
                            added = true;
                            newMappingResources.add(res);
                        } else if (tmpStr.startsWith("apps")) {
                            tmpStr = tmpStr.substring(5);
                            tmpStr = tmpStr.substring(0, tmpStr.indexOf(47));
                            boolean hasPlugin = plugins.contains(tmpStr);
                            added = true;
                            newMappingResources.add(res);
                        } else if (tmpStr.startsWith("v3x")) {
                            added = true;
                            newMappingResources.add(res);
                        } else if (tmpStr.startsWith("gov")) {
                            added = true;
                            newMappingResources.add(res);
                        } else if (tmpStr.startsWith("cmp")) {
                            added = true;
                            newMappingResources.add(res);
                        } else if (tmpStr.startsWith("cap4")) {
                            added = true;
                            newMappingResources.add(res);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (added) continue;
            LOGGER.warn((Object)("**** Ignored HBM[" + hbmPathStr + "],plugin inactive or path not like com.seeyon.ctp.*.po.** or com.seeyon.apps.*.po.**"));
        }
        super.setMappingLocations(newMappingResources.toArray(new Resource[newMappingResources.size()]));
    }

    public void setLobHandler(LobHandler lobHandler) {
        if (!"text".equals(System.getProperty("clobtype", "text"))) {
            super.setLobHandler(lobHandler);
        }
    }
}

