/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.util.HashSet;
import java.util.Set;

public class BeanTypeBlacklist {
    private static Set<Class> BLACKLIST = new HashSet<Class>();

    private static void add(String className) {
        try {
            BLACKLIST.add(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean match(Class<?> targetType) {
        for (Class clazz : BLACKLIST) {
            if (!clazz.isAssignableFrom(targetType)) continue;
            return true;
        }
        return false;
    }

    static {
        BeanTypeBlacklist.add("com.seeyon.ctp.portal.section.BaseSection");
        BeanTypeBlacklist.add("com.seeyon.ctp.common.usermessage.pipeline.MessagePipeline");
        BeanTypeBlacklist.add("com.seeyon.ctp.common.usermessage.UserMessageFilter");
        BeanTypeBlacklist.add("com.seeyon.v3x.mobile.adapter.AdapterMobileMessageManger");
        BeanTypeBlacklist.add("com.seeyon.apps.index.manager.IndexEnable");
        BeanTypeBlacklist.add("com.seeyon.ctp.organization.selectpeople.manager.SelectPeoplePanel");
        BeanTypeBlacklist.add("com.seeyon.ctp.workflow.wapi.WorkFlowAppExtendManager");
        BeanTypeBlacklist.add("com.seeyon.ctp.workflow.wapi.WorkflowCustomRoleManager");
        BeanTypeBlacklist.add("com.seeyon.ctp.workflow.wapi.HumenNodeMatchInterface");
        BeanTypeBlacklist.add("com.seeyon.ctp.workflow.event.AbstractWorkflowEvent");
    }
}

