/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.resolver;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.util.Strings;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.CTPDB2Dialect;
import org.hibernate.dialect.CTPMySQLDialect;
import org.hibernate.dialect.CTPOracle10gDialect;
import org.hibernate.dialect.CTPOracle8iDialect;
import org.hibernate.dialect.CTPOracle9iDialect;
import org.hibernate.dialect.CTPPostgreSQLDialect;
import org.hibernate.dialect.CTPSQLServerDialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.IngresDialect;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.dialect.resolver.AbstractDialectResolver;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTPDialectResolver
extends AbstractDialectResolver {
    private static final Logger log = LoggerFactory.getLogger(CTPDialectResolver.class);

    protected Dialect resolveDialectInternal(DatabaseMetaData metaData) throws SQLException {
        String databaseName = metaData.getDatabaseProductName();
        AppContext.putCache("DATABASE_NAME", databaseName);
        int databaseMajorVersion = metaData.getDatabaseMajorVersion();
        if ("HSQL Database Engine".equals(databaseName)) {
            return new HSQLDialect();
        }
        if ("H2".equals(databaseName)) {
            return new H2Dialect();
        }
        if ("MySQL".equals(databaseName)) {
            return new CTPMySQLDialect();
        }
        if ("PostgreSQL".equals(databaseName)) {
            return new CTPPostgreSQLDialect();
        }
        if ("Apache Derby".equals(databaseName)) {
            return new DerbyDialect();
        }
        if ("ingres".equalsIgnoreCase(databaseName)) {
            return new IngresDialect();
        }
        if (databaseName.startsWith("Microsoft SQL Server")) {
            return new CTPSQLServerDialect();
        }
        if ("Sybase SQL Server".equals(databaseName) || "Adaptive Server Enterprise".equals(databaseName)) {
            return new SybaseDialect();
        }
        if ("Informix Dynamic Server".equals(databaseName)) {
            return new InformixDialect();
        }
        if (databaseName.startsWith("DB2/")) {
            return new CTPDB2Dialect();
        }
        if ("Oracle".equals(databaseName)) {
            switch (databaseMajorVersion) {
                case 11: 
                case 12: 
                case 13: {
                    return new CTPOracle10gDialect();
                }
                case 10: {
                    return new CTPOracle10gDialect();
                }
                case 9: {
                    return new CTPOracle9iDialect();
                }
                case 8: {
                    return new CTPOracle8iDialect();
                }
            }
            log.warn("unknown Oracle major version [" + databaseMajorVersion + "]");
            return new CTPOracle10gDialect();
        }
        String dialect = SystemProperties.getInstance().getProperty("db.hibernateDialect");
        if (databaseName.startsWith("DM ") || "org.hibernate.dialect.DmDialect".equals(dialect)) {
            dialect = "org.hibernate.dialect.CTPDmDialect";
        } else if (databaseName.startsWith("Kingbase") || "org.hibernate.dialect.Kingbase8Dialect".equals(dialect)) {
            dialect = "org.hibernate.dialect.CTPKingbase8Dialect";
        }
        if (!Strings.isEmpty(dialect)) {
            return CTPDialectResolver.instantiateDialect(dialect);
        }
        return null;
    }

    private static Dialect instantiateDialect(String dialectName) throws HibernateException {
        if (dialectName == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            return (Dialect)ReflectHelper.classForName((String)dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", (Throwable)e);
        }
    }
}

