/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.dialect.CTPDBDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.mapping.Column;
import org.hibernate.type.Type;

public class CTPMySQLDialect
extends MySQLDialect
implements CTPDBDialect {
    private final int TEXT_LIMIT = 65535;

    public CTPMySQLDialect() {
        this.registerFunction("convert_gbk", (SQLFunction)new SQLFunctionTemplate((Type)Hibernate.STRING, "convert(?1 using gbk)"));
    }

    @Override
    public String getModifyColumnString(String columnName) {
        StringBuilder sb = new StringBuilder();
        sb.append(" modify ");
        sb.append(new Column(columnName).getQuotedName((Dialect)this));
        sb.append(" ");
        return sb.toString();
    }

    @Override
    public int getTextLimit() {
        return 65535;
    }
}

