/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.v3x.common.ajax.impl;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.aspect.AbstractAspectContext;
import com.seeyon.ctp.common.aspect.AspectContext;
import com.seeyon.ctp.common.aspect.AspectManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.v3x.common.ajax.AJAXException;
import com.seeyon.v3x.common.ajax.AJAXRequest;
import com.seeyon.v3x.common.ajax.AJAXResponse;
import com.seeyon.v3x.common.ajax.AJAXService;
import com.seeyon.v3x.common.ajax.impl.AJAXResponseImpl;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class AJAXServiceImpl
implements AJAXService,
BeanFactoryAware {
    protected static final Log LOG = CtpLogFactory.getLog(AJAXServiceImpl.class);
    private Map<String, String> serviceToBeans;
    private static Set<String> beanNames = new HashSet<String>();
    private BeanFactory beanFactory;

    public AJAXServiceImpl(Map<String, String> serviceToBeans) {
        this.serviceToBeans = serviceToBeans;
        if (SystemEnvironment.isDistributedMode() && serviceToBeans != null) {
            beanNames = serviceToBeans.keySet();
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public AJAXResponse processRequest(AJAXRequest request) throws AJAXException {
        String serviceName = request.getServiceName();
        String methodName = request.getMethodName();
        if (Strings.isBlank(serviceName) || Strings.isBlank(methodName)) {
            try {
                return new AJAXResponseImpl(null, request.getServletResponse().getWriter());
            }
            catch (IOException e) {
                throw new AJAXException(e);
            }
        }
        String beanId = this.serviceToBeans.get(serviceName);
        if (Strings.isBlank(beanId)) {
            throw new AJAXException("AJAX Service " + serviceName + "." + methodName + "\u65e0\u6743\u8bbf\u95ee\u3002");
        }
        Object targetService = null;
        try {
            targetService = this.beanFactory.getBean(beanId);
        }
        catch (Exception ex) {
            throw new AJAXException("AJAX Service " + serviceName + "." + methodName + "\u4e0d\u5b58\u5728\u3002", ex);
        }
        if (null == targetService) {
            throw new AJAXException("AJAX Service " + serviceName + " instance is not exist.");
        }
        try {
            Method method = targetService.getClass().getMethod(methodName, request.getTypes());
            Object result = method.invoke(targetService, request.getValues());
            final Object[] args = request.getValues();
            try {
                Class clazz = AopProxyUtils.ultimateTargetClass((Object)targetService);
                if (AspectManager.withParameters(clazz, methodName)) {
                    final HashMap map = new HashMap(request.getServletRequest().getParameterMap());
                    AbstractAspectContext ctx = new AbstractAspectContext(AspectManager.getSourceName(clazz, methodName), AspectContext.SourceType.Ajax, AppContext.getCurrentUser()){
                        private Object[] arguments;
                        {
                            super(sourceName, sourceType, user);
                            this.arguments = args;
                        }

                        @Override
                        public Object getParameter(String name) {
                            return map.get(name);
                        }

                        @Override
                        public Object getParameter(int index) {
                            return this.arguments[index];
                        }
                    };
                    AspectManager.initContext(ctx);
                }
                AspectManager.execute(clazz, methodName);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return new AJAXResponseImpl(result, request.getServletResponse().getWriter());
        }
        catch (Exception ex) {
            throw new AJAXException(ex);
        }
    }

    public static Set<String> getAccessiableBeanNames() {
        return beanNames;
    }
}

