/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.common.code.KeyEnum;
import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.impl.AbstractMapper;
import com.seeyon.ctp.util.json.model.JSONInteger;
import com.seeyon.ctp.util.json.model.JSONString;
import com.seeyon.ctp.util.json.model.JSONValue;

public class EnumMapper
extends AbstractMapper {
    @Override
    public Class getHelpedClass() {
        return Enum.class;
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        Enum enu = (Enum)aPojo;
        return new JSONString(enu.name());
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        block6: {
            T[] objs;
            block5: {
                objs = aRequestedClass.getEnumConstants();
                if (!aValue.isString()) break block5;
                String enu = ((JSONString)aValue).getValue().trim();
                int key = Integer.MIN_VALUE;
                try {
                    key = Integer.parseInt(enu);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                for (Object o : objs) {
                    Enum e = (Enum)o;
                    if (e.name().equals(enu)) {
                        return e;
                    }
                    if (key == Integer.MIN_VALUE || !(o instanceof KeyEnum) || key != ((KeyEnum)o).getKey()) continue;
                    return e;
                }
                break block6;
            }
            if (!aValue.isInteger()) break block6;
            int key = ((JSONInteger)aValue).getValue().intValue();
            for (Object o : objs) {
                Enum e = (Enum)o;
                if (!(o instanceof KeyEnum) || key != ((KeyEnum)o).getKey()) continue;
                return e;
            }
        }
        throw new MapperException("EnumMapper cannot map: " + aValue.getClass().getName() + " to enum " + aRequestedClass.getName());
    }
}

