/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.json.mapper.JSONMapper;
import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.model.JSONArray;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Collection.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRawClass) throws MapperException {
        Collection lCollObj;
        if (!aValue.isArray()) {
            throw new MapperException("CollectionMapper cannot map: " + aValue.getClass().getName());
        }
        if (!Collection.class.isAssignableFrom(aRawClass)) {
            throw new MapperException("CollectionMapper cannot map: " + aValue.getClass().getName());
        }
        JSONArray aObject = (JSONArray)aValue;
        try {
            lCollObj = aRawClass.isInterface() ? (aRawClass == Set.class ? new HashSet() : (aRawClass == SortedSet.class ? new TreeSet() : new LinkedList())) : (Collection)aRawClass.newInstance();
        }
        catch (Exception e) {
            lCollObj = new LinkedList();
        }
        Iterator oIte = aObject.getValue().iterator();
        Class<?> clz = JSONMapper.getParameterizedTypeLocal();
        while (oIte.hasNext()) {
            JSONValue lVal = (JSONValue)oIte.next();
            if (clz != null) {
                lCollObj.add(JSONMapper.toJava(lVal, clz));
                continue;
            }
            lCollObj.add(JSONMapper.toJava(lVal));
        }
        return lCollObj;
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        JSONArray lArray = new JSONArray();
        if (!Collection.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("CollectionMapper cannot map: " + aPojo.getClass().getName());
        }
        Collection lColl = (Collection)aPojo;
        for (Object lEl : lColl) {
            lArray.getValue().add(JSONMapper.toJSON(lEl));
        }
        return lArray;
    }
}

