/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.model.JSONInteger;
import com.seeyon.ctp.util.json.model.JSONString;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.math.BigInteger;

public class BigIntegerMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return BigInteger.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (aValue.isString()) {
            return ((JSONString)aValue).getValue();
        }
        if (aValue.isInteger()) {
            return ((JSONInteger)aValue).getValue().toString();
        }
        throw new MapperException("BigIntegerMapper cannot map: " + aValue.getClass().getName());
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        if (!BigInteger.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("BigIntegerMapper cannot map: " + aPojo.getClass().getName());
        }
        return new JSONString(aPojo.toString());
    }
}

