/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.array;

import com.seeyon.ctp.util.array.ArrayBase;

public class StringArray
extends ArrayBase<String> {
    private static final long serialVersionUID = -780020663900485338L;

    protected String[] makeArray(int len) {
        return new String[len];
    }

    @Override
    public boolean add(StringArray set) {
        int num = set.size;
        this.ensureCapacity(this.size + num);
        System.arraycopy(set.elements, 0, this.elements, this.size, num);
        this.size += num;
        return num != 0;
    }

    public void split(String src, String regex) {
        if (src == null || src.length() == 0) {
            return;
        }
        String[] list = src.split(regex);
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].trim();
        }
        this.add((T[])list);
    }

    public void split(String value, char splitChar) {
        String v;
        int i;
        int len = value.length();
        char[] content = new char[len];
        value.getChars(0, len, content, 0);
        int start = 0;
        for (i = 0; i < len; ++i) {
            if (content[i] != splitChar) continue;
            v = String.valueOf(content, start, i - start);
            start = i + 1;
            this.add(v);
        }
        if (i > start) {
            v = String.valueOf(content, start, i - start);
            this.add(v);
        }
    }

    public String meger(String delim) {
        if (this.size == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append(((String[])this.elements)[0]);
        for (int i = 1; i < this.size; ++i) {
            result.append(delim);
            result.append(((String[])this.elements)[i]);
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.size != 0) {
            result.append(((String[])this.elements)[0]);
            for (int i = 1; i < this.size; ++i) {
                result.append(',');
                result.append(((String[])this.elements)[i]);
            }
        }
        return result.toString();
    }

    @Override
    public int indexOf(String elem) {
        if (elem == null) {
            for (int i = 0; i < this.size; ++i) {
                if (((String[])this.elements)[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (elem.compareTo(((String[])this.elements)[i]) != 0) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(String elem) {
        if (elem == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (((String[])this.elements)[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (elem.compareTo(((String[])this.elements)[i]) != 0) continue;
                return i;
            }
        }
        return -1;
    }
}

