/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.annotation;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.annotation.AOPProxyUtil;
import com.seeyon.ctp.util.annotation.AnnotationAware;
import com.seeyon.ctp.util.annotation.AnnotationFactory;
import com.seeyon.ctp.util.annotation.FieldAnnotation;
import com.seeyon.ctp.util.annotation.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Set;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.springframework.util.ReflectionUtils;

public class InjectAnnotationAware
extends AbstractSystemInitializer
implements AnnotationAware {
    private static final Log log = CtpLogFactory.getLog(InjectAnnotationAware.class);
    private AnnotationFactory annotationFactory;

    @Override
    public void setAnnotationFactory(AnnotationFactory annotationFactory) {
        this.annotationFactory = annotationFactory;
    }

    @Override
    public void initialize() {
        HashMap ajaxMap = new HashMap();
        Set<FieldAnnotation> fieldAnnotation = this.annotationFactory.getAnnotationOfField(Inject.class);
        if (fieldAnnotation != null) {
            for (FieldAnnotation annotation : fieldAnnotation) {
                try {
                    Object value;
                    Annotation[] annotations;
                    String beanName = annotation.getBeanName();
                    Field field = annotation.getField();
                    Object bean = AppContext.getBean(beanName);
                    if (bean == null) continue;
                    Object b = AOPProxyUtil.getTarget(bean);
                    String fieldName = field.getName();
                    for (Annotation anno : annotations = field.getAnnotations()) {
                        if (anno.annotationType() != Named.class) continue;
                        Named n = (Named)anno;
                        fieldName = n.value();
                        break;
                    }
                    if ((value = AppContext.getBean(fieldName)) == null) continue;
                    ReflectionUtils.makeAccessible((Field)field);
                    ReflectionUtils.setField((Field)field, (Object)b, (Object)value);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getSortOrder() {
        return -7;
    }
}

