/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.constants.ServerTypeEnum;
import com.seeyon.ctp.util.Datetimes;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public final class XMLCoder {
    private static XStream xStreamInstance;
    private static Map<String, String> allowTypeHierarchyMap;

    public static String encoder(Object o) {
        if (o == null) {
            return null;
        }
        return xStreamInstance.toXML(o);
    }

    public static String encoderMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<map>");
        sb.append("\r\n");
        for (Map.Entry<String, Object> e : map.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            if (value == null) continue;
            String text = "";
            String clazz = value.getClass().getSimpleName().toLowerCase();
            if (value instanceof Integer) {
                clazz = "int";
                text = value.toString();
            }
            if (value instanceof Character) {
                clazz = "char";
                text = value.toString();
            } else if (value instanceof Timestamp) {
                clazz = "sql-timestamp";
                text = Datetimes.formatNoTimeZone((Date)value, "yyyy-MM-dd HH:mm:ss.S");
            } else if (value instanceof Date) {
                clazz = "date";
                text = Datetimes.formatNoTimeZone((Date)value, "yyyy-MM-dd HH:mm:ss.S z");
            } else {
                text = value.toString();
            }
            text = "<![CDATA[" + text + "]]>";
            sb.append("<entry>");
            sb.append("<string>" + key + "</string>");
            sb.append("<" + clazz + ">" + text + "</" + clazz + ">");
            sb.append("</entry>");
            sb.append("\r\n");
        }
        sb.append("</map>");
        return sb.toString();
    }

    private static XStream newXStream() {
        XStream xstream = ServerTypeEnum.Tomcat == ServerTypeEnum.getCurrentServerType() ? new XStream() : new XStream((HierarchicalStreamDriver)new DomDriver());
        return xstream;
    }

    public static Object decoder(String xml) {
        if (StringUtils.isBlank((CharSequence)xml)) {
            return null;
        }
        return xStreamInstance.fromXML(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T decoder(String xml, Class<T> clas) {
        if (StringUtils.isBlank((CharSequence)xml)) {
            return null;
        }
        try {
            String className = clas.getName();
            if (allowTypeHierarchyMap.containsKey(className)) return (T)xStreamInstance.fromXML(xml);
            allowTypeHierarchyMap.put(className, "1");
            Class<XMLCoder> clazz = XMLCoder.class;
            synchronized (XMLCoder.class) {
                xStreamInstance.allowTypeHierarchy(clas);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return (T)xStreamInstance.fromXML(xml);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return (T)xStreamInstance.fromXML(xml);
    }

    static {
        allowTypeHierarchyMap = new ConcurrentHashMap<String, String>();
        xStreamInstance = ServerTypeEnum.Tomcat == ServerTypeEnum.getCurrentServerType() ? new XStream() : new XStream((HierarchicalStreamDriver)new DomDriver());
        xStreamInstance.registerConverter((Converter)new ReflectionConverter(xStreamInstance.getMapper(), xStreamInstance.getReflectionProvider()), -9);
    }
}

