/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.SingletonInvocable;
import com.seeyon.ctp.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.script.Invocable;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import org.apache.commons.logging.Log;

public class StringUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(StringUtil.class);

    private StringUtil() {
    }

    public static String filterNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    @Deprecated
    public static String filterNullObject(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static String stringToString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String deal(String val) {
        val = StringUtil.replace(val, "\"", "\u2019");
        val = StringUtil.replace(val, ">", "\u2019");
        val = StringUtil.replace(val, "<", "\u2019");
        return val;
    }

    public static String replace(String original, String oldString, String newString) {
        return StringUtil.replace(original, oldString, newString, 0);
    }

    public static String replace(String original, String oldString, String newString, int counts) {
        if (original == null || oldString == null || newString == null) {
            return "";
        }
        if (counts < 0) {
            throw new IllegalArgumentException("parameter counts can not be negative");
        }
        StringBuilder sb = new StringBuilder();
        int end = original.indexOf(oldString);
        int start = 0;
        int stringSize = oldString.length();
        for (int currentCount = 0; end != -1 && (counts == 0 || currentCount < counts); ++currentCount) {
            sb.append(original.substring(start, end));
            sb.append(newString);
            start = end + stringSize;
            end = original.indexOf(oldString, start);
        }
        end = original.length();
        sb.append(original.substring(start, end));
        return sb.toString();
    }

    public static String[] split(String sourceString, String delim) {
        if (sourceString == null || delim == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(sourceString, delim);
        ArrayList<String> stringList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            stringList.add(st.nextToken());
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public static String[] splitAndTrim(String src, String delim) {
        if (src == null || delim == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(src, delim);
        ArrayList<String> stringList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            stringList.add(st.nextToken().trim());
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public static String[] split(String str, String delimiters, boolean skipDelim) {
        if (str == null || delimiters == null) {
            return new String[0];
        }
        ArrayList<String> strList = new ArrayList<String>();
        int start = 0;
        int end = str.length();
        while (start <= end) {
            String tok;
            int delimIdx = str.indexOf(delimiters, start);
            if (delimIdx < 0) {
                tok = str.substring(start);
                if (!skipDelim || !"".equals(tok)) {
                    strList.add(tok);
                }
                start = end + delimiters.length();
                continue;
            }
            tok = str.substring(start, delimIdx);
            if (!skipDelim || !"".equals(tok)) {
                strList.add(tok);
            }
            start = delimIdx + delimiters.length();
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static String firstCharUp(String str) {
        return str.replaceFirst("" + str.charAt(0), ("" + str.charAt(0)).toUpperCase());
    }

    public static String firstCharLower(String str) {
        return str.replaceFirst("" + str.charAt(0), ("" + str.charAt(0)).toLowerCase());
    }

    public static Object convertStringToOther(Class clazz, String str, String dateFormat) throws Exception {
        if (clazz.isAssignableFrom(Date.class)) {
            if (dateFormat == null || "".equals(dateFormat)) {
                return DateUtil.parse(str);
            }
            return DateUtil.parse(str, dateFormat);
        }
        Class[] parameterTypes = new Class[]{str.getClass()};
        Constructor c = clazz.getConstructor(parameterTypes);
        Object o = c.newInstance(str);
        return o;
    }

    public static void judgeNull(Object obj, String info) throws BusinessException {
        if (obj == null || "".equals(obj.toString().trim())) {
            throw new BusinessException(info);
        }
    }

    public static byte[] compress(String s) {
        byte[] input = null;
        input = s.getBytes();
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            if (count <= 0) continue;
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        byte[] compressedData = bos.toByteArray();
        return compressedData;
    }

    public static String decompress(byte[] compressedData) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        boolean done = false;
        while (!done) {
            try {
                int count = decompressor.inflate(buf);
                if (count < buf.length) {
                    done = true;
                }
                if (count > 0) {
                    bos.write(buf, 0, count);
                }
            }
            catch (DataFormatException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
            Thread.currentThread();
            Thread.yield();
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            return bos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Deprecated
    public static boolean checkNull(String data) {
        return data == null || "".equals(data) || "null".equalsIgnoreCase(data);
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String arrayToString(String[] strArray) {
        return StringUtil.arrayToString(strArray, ",");
    }

    public static String arrayToString(String[] strArray, String label) {
        if (strArray == null || strArray.length == 0) {
            return "";
        }
        StringBuilder returnValue = new StringBuilder("");
        for (int i = 0; i < strArray.length; ++i) {
            returnValue.append(strArray[i] + (i == strArray.length - 1 ? "" : label));
        }
        return returnValue.toString();
    }

    public static String getPingYin(String src) {
        if (Strings.isBlank(src)) {
            return "";
        }
        char[] t1 = null;
        t1 = src.toCharArray();
        String[] t2 = new String[t1.length];
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_V);
        String t4 = "";
        int t0 = t1.length;
        try {
            for (int i = 0; i < t0; ++i) {
                if (Character.toString(t1[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    t2 = PinyinHelper.toHanyuPinyinStringArray((char)t1[i], (HanyuPinyinOutputFormat)t3);
                    t4 = t4 + t2[0];
                    continue;
                }
                t4 = t4 + Character.toString(t1[i]);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        return t4;
    }

    public static String getPinYinHeadChar(String str) {
        if (Strings.isBlank(str)) {
            return "";
        }
        String convert = "";
        try {
            for (int j = 0; j < str.length(); ++j) {
                char word = str.charAt(j);
                String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
                if (pinyinArray != null) {
                    convert = convert + pinyinArray[0].charAt(0);
                    continue;
                }
                if (Character.toString(word).matches("[\\u4E00-\\u9FA5]+")) continue;
                convert = convert + word;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        return convert;
    }

    public static String getFirstPinYinHeadChar(String str) {
        if (Strings.isBlank(str)) {
            return "";
        }
        String convert = "";
        try {
            char word = str.charAt(0);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            if (pinyinArray != null) {
                convert = Character.toString(pinyinArray[0].charAt(0));
            } else if (!Character.toString(word).matches("[\\u4E00-\\u9FA5]+")) {
                convert = Character.toString(word);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        return convert;
    }

    public static String getPasswdStrong(String passwd) {
        String result = "4";
        if (Strings.isBlank(passwd)) {
            return result;
        }
        try {
            SingletonInvocable instance = SingletonInvocable.getInstance();
            Invocable invoke = instance.getScriptInvocable();
            if (invoke != null) {
                result = invoke.invokeFunction("getPwdStrongForLoginPage", passwd).toString();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u83b7\u53d6\u5bc6\u7801\u5f3a\u5ea6\u51fa\u9519\uff0c\u9ed8\u8ba4\u5bc6\u7801\u5f3a\u5ea6\u4e3a\u6700\u5f3a\uff01", (Throwable)e);
        }
        return result;
    }
}

