/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.po.lock.Lock;
import com.seeyon.ctp.util.JDBCAgent;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoredProcedureCaller {
    private static Log log = LogFactory.getLog(StoredProcedureCaller.class);

    private static Connection getConnection() throws SQLException, ClassNotFoundException {
        return JDBCAgent.getRawConnection();
    }

    public static Object execute(String callString, Long id, int readOnly) throws SQLException, ClassNotFoundException {
        Connection connection = null;
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            Long result;
            connection = StoredProcedureCaller.getConnection();
            stmt = connection.prepareCall(callString);
            stmt.setLong(1, (long)id);
            stmt.setInt(2, readOnly);
            stmt.registerOutParameter(3, -5);
            stmt.execute();
            Long l = result = Long.valueOf(stmt.getLong(3));
            return l;
        }
        catch (SQLException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e2) {
                    log.warn((Object)e2.getLocalizedMessage());
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    log.warn((Object)e.getLocalizedMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn((Object)e.getLocalizedMessage());
                }
            }
        }
    }

    public static boolean callProcForGetLock(Lock lock) throws SQLException, ClassNotFoundException {
        Connection connection = null;
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = StoredProcedureCaller.getConnection();
            stmt = connection.prepareCall("{call PROC_GET_RESOURCE_LOCK(?,?,?,?,?,?,?,?,?,?)}");
            stmt.setLong(1, lock.getId());
            stmt.setLong(2, lock.getOwner());
            stmt.setString(3, lock.getFrom());
            stmt.setLong(4, lock.getLoginTime());
            stmt.setString(5, lock.getModule());
            stmt.setLong(6, lock.getResourceId());
            stmt.setInt(7, lock.getAction());
            stmt.setLong(8, lock.getLockTime());
            stmt.setLong(9, lock.getExpirationTime());
            stmt.registerOutParameter(10, 4);
            stmt.execute();
            int result = stmt.getInt(10);
            boolean bl = result == 1;
            return bl;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e2) {
                    log.warn((Object)e2.getLocalizedMessage());
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    log.warn((Object)e.getLocalizedMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn((Object)e.getLocalizedMessage());
                }
            }
        }
    }
}

