/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.util.SerializableException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.nustaq.serialization.FSTConfiguration;

public final class SerializableUtil {
    private static final Log log = CtpLogFactory.getLog(SerializableUtil.class);
    private static final FSTConfiguration configuration = FSTConfiguration.createDefaultConfiguration();

    private SerializableUtil() {
    }

    public static <T extends Serializable> byte[] getBytes(T object) throws SerializableException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream outstream = null;
        ObjectOutputStream objstream = null;
        try {
            outstream = new ByteArrayOutputStream();
            objstream = new ObjectOutputStream(outstream);
            objstream.writeObject(object);
            objstream.flush();
        }
        catch (Exception e) {
            throw new SerializableException(e);
        }
        finally {
            if (objstream != null) {
                try {
                    objstream.close();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
            if (outstream != null) {
                try {
                    outstream.close();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
        return outstream.toByteArray();
    }

    public static Object getObject(InputStream in) throws SerializableException {
        if (in == null) {
            return null;
        }
        ObjectInputStream objstream = null;
        Object object = null;
        try {
            objstream = new ObjectInputStream(in);
            object = objstream.readObject();
        }
        catch (Exception e) {
            throw new SerializableException(e);
        }
        finally {
            if (objstream != null) {
                try {
                    objstream.close();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
        return object;
    }

    public static Object getObject(byte[] objectData) throws SerializableException {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        return SerializableUtil.getObject(bais);
    }

    public static byte[] fstSerialize(Object obj) {
        return configuration.asByteArray(obj);
    }

    public static Object fstDeserialize(byte[] sec) {
        try {
            return configuration.asObject(sec);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fst\u53cd\u5e8f\u5217\u5316\u51fa\u9519 [" + t.getLocalizedMessage() + "]"), t);
            }
            return null;
        }
    }

    public static String fstSerializeToString(Object obj) {
        try {
            return new String(configuration.asByteArray(obj), "ISO-8859-1");
        }
        catch (Throwable t) {
            log.error((Object)"\u5e8f\u5217\u5316\u51fa\u9519", t);
            return null;
        }
    }

    public static Object fstDeserializeFromString(String sec) {
        if (sec == null) {
            return null;
        }
        try {
            return configuration.asObject(sec.getBytes("ISO-8859-1"));
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u53cd\u5e8f\u5217\u5316\u51fa\u9519", t);
            }
            return null;
        }
    }

    static {
        configuration.registerClass(new Class[]{Event.class});
    }
}

