/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.util.Strings;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;

public class ResourceLoadUtils {
    public static final String CLASSPATH_PREFIX = "classpath*:";

    public static InputStream getFromServletContext(ServletContext servletContext, String location) {
        if (Strings.isBlank(location)) {
            return null;
        }
        if (!location.startsWith("/")) {
            location = "/" + location;
        }
        return servletContext.getResourceAsStream(location);
    }

    public static InputStream getFromClasspath(String location) {
        if (Strings.isBlank(location)) {
            return null;
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
    }

    public static InputStream get(ServletContext servletContext, String location) {
        if (Strings.isBlank(location)) {
            return null;
        }
        if (location.startsWith(CLASSPATH_PREFIX)) {
            return ResourceLoadUtils.getFromClasspath(StringUtils.substringAfter((String)location, (String)CLASSPATH_PREFIX));
        }
        return ResourceLoadUtils.getFromServletContext(servletContext, location);
    }
}

