/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;

public class PropertiesUtil {
    private static Log log = CtpLogFactory.getLog(PropertiesUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getFromClasspath(String filepath) {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filepath);
            if (in != null) {
                props.load(in);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    public static Properties getFromFile(File file) {
        return PropertiesUtil.getFromAbsolutepath(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getFromAbsolutepath(String filepath) {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(filepath);
            if (in != null) {
                props.load(in);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getFromServletContext(String filepath, ServletContext servletContext) {
        if (!filepath.startsWith("/")) {
            filepath = "/" + filepath;
        }
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = servletContext.getResourceAsStream(filepath);
            if (in != null) {
                props.load(in);
            }
        }
        catch (Exception e) {
            log.warn((Object)"\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    public static void saveToFile(Properties pro, File file, String comments) {
        PropertiesUtil.saveToAbsolutePath(pro, file.getAbsolutePath(), comments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToAbsolutePath(Properties pro, String realPath, String comments) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(realPath);
            pro.store(fos, comments);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            if (fos != null) {
                try {
                    ((OutputStream)fos).close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }
}

