/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import java.beans.PropertyEditorSupport;
import java.text.NumberFormat;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class NumberBinder
extends PropertyEditorSupport {
    private final Class numberClass;
    private final NumberFormat numberFormat;
    private final boolean allowEmpty;

    public NumberBinder(Class numberClass, boolean allowEmpty) throws IllegalArgumentException {
        if (numberClass == null || !Number.class.isAssignableFrom(numberClass)) {
            throw new IllegalArgumentException("Property class must be a subclass of Number");
        }
        this.numberClass = numberClass;
        this.numberFormat = null;
        this.allowEmpty = allowEmpty;
    }

    public NumberBinder(Class numberClass, NumberFormat numberFormat, boolean allowEmpty) throws IllegalArgumentException {
        if (numberClass == null || !Number.class.isAssignableFrom(numberClass)) {
            throw new IllegalArgumentException("Property class must be a subclass of Number");
        }
        this.numberClass = numberClass;
        this.numberFormat = numberFormat;
        this.allowEmpty = allowEmpty;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!this.allowEmpty || StringUtils.hasText((String)text)) {
            if (this.numberFormat != null) {
                this.setValue(NumberUtils.parseNumber((String)text, (Class)this.numberClass, (NumberFormat)this.numberFormat));
            } else {
                this.setValue(NumberUtils.parseNumber((String)text, (Class)this.numberClass));
            }
        }
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value == null) {
            return "";
        }
        if (this.numberFormat != null) {
            return this.numberFormat.format(value);
        }
        return value.toString();
    }
}

