/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.SeeyonSSLProtocolSocketFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;

public class HttpClientUtil {
    private static final Log log = CtpLogFactory.getLog(HttpClientUtil.class);
    private HttpClient client = new HttpClient();
    private HttpMethodBase httpMethod = null;

    public HttpClientUtil() {
        this(15000);
    }

    public HttpClientUtil(int timeoutInMilliseconds) {
        this(timeoutInMilliseconds, timeoutInMilliseconds);
    }

    public HttpClientUtil(int connectTimeout, int dataTimeout) {
        this.client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        HttpClientUtil.setProxy(this.client);
        HttpConnectionManagerParams ps = this.client.getHttpConnectionManager().getParams();
        ps.setSoTimeout(dataTimeout);
        ps.setConnectionTimeout(connectTimeout);
    }

    public void open(String url, String method) {
        if (url.startsWith("https")) {
            Protocol myhttps = new Protocol("https", (ProtocolSocketFactory)new SeeyonSSLProtocolSocketFactory(), 443);
            Protocol.registerProtocol((String)"https", (Protocol)myhttps);
        } else {
            log.error((Object)"\u8bbf\u95ee\u5916\u90e8\u7ad9\u70b9\u8bf7\u4f7f\u7528HTTPS\uff01\uff01\uff01");
        }
        if ("get".equalsIgnoreCase(method)) {
            this.httpMethod = new GetMethod(url);
        } else if ("post".equalsIgnoreCase(method)) {
            this.httpMethod = new PostMethod(url);
        } else {
            throw new IllegalArgumentException("Unsupport method : " + method);
        }
    }

    public void openGet(String url) {
        this.open(url, "get");
    }

    public void openPost(String url) {
        this.open(url, "post");
    }

    public void setRequestHeader(String name, String value) {
        this.httpMethod.setRequestHeader(name, value);
    }

    public void setRequestBodyJson(Object obj) {
        String contentType = "application/json; charset=utf-8";
        StringRequestEntity requestEntity = null;
        try {
            requestEntity = new StringRequestEntity(JSONUtil.toJSONString(obj), contentType, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        ((PostMethod)this.httpMethod).setRequestEntity((RequestEntity)requestEntity);
    }

    public void addParameter(String name, String value) throws IllegalArgumentException {
        if (name == null || value == null) {
            throw new IllegalArgumentException("Arguments to addParameter(String, String) cannot be null");
        }
        if (this.httpMethod instanceof GetMethod) {
            String q = this.httpMethod.getQueryString();
            if (q == null) {
                this.httpMethod.setQueryString(name + "=" + value);
            } else {
                this.httpMethod.setQueryString(q + "&" + name + "=" + value);
            }
        } else if (this.httpMethod instanceof PostMethod) {
            ((PostMethod)this.httpMethod).addParameter(name, String.valueOf(value));
        }
    }

    public int send() throws IOException {
        this.httpMethod.setRequestHeader("Connection", "close");
        return this.client.executeMethod((HttpMethod)this.httpMethod);
    }

    public Map<String, String> getResponseHeader() {
        Header[] h;
        HashMap<String, String> r = new HashMap<String, String>();
        for (Header header : h = this.httpMethod.getResponseHeaders()) {
            r.put(header.getName(), header.getValue());
        }
        return r;
    }

    public Map<String, String> getCookies() {
        Cookie[] cs;
        HashMap<String, String> r = new HashMap<String, String>();
        for (Cookie c : cs = this.client.getState().getCookies()) {
            r.put(c.getName(), c.getValue());
        }
        return r;
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return this.httpMethod.getResponseBodyAsStream();
    }

    public String getResponseBodyAsString(String contentCharset) throws IOException {
        int len;
        InputStream instream = this.httpMethod.getResponseBodyAsStream();
        ByteArrayOutputStream outstream = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        while ((len = instream.read(buffer)) > 0) {
            outstream.write(buffer, 0, len);
        }
        outstream.close();
        byte[] rawdata = outstream.toByteArray();
        if (contentCharset != null) {
            return new String(rawdata, contentCharset);
        }
        return new String(rawdata);
    }

    public <T> T getResponseJsonAsObject(Class<T> cls) throws IOException {
        String responseStr = this.httpMethod.getResponseBodyAsString();
        return JSONUtil.parseJSONString(responseStr, cls);
    }

    public void close() {
        if (this.httpMethod != null) {
            try {
                this.httpMethod.releaseConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void setProxy(HttpClient client) {
        int proxyPort;
        String proxyHost = SystemEnvironment.getHttpProxyHost();
        if (Strings.isNotBlank(proxyHost) && (proxyPort = SystemEnvironment.getHttpProxyPort()) > 0) {
            client.getHostConfiguration().setProxy(proxyHost, proxyPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String url) {
        if (Strings.isNotBlank(url)) {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(url);
            HttpClientUtil.setProxy(client);
            get.setRequestHeader("Connection", "close");
            try {
                client.executeMethod((HttpMethod)get);
                String string = get.getResponseBodyAsString();
                return string;
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
            finally {
                get.releaseConnection();
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String c;
        HttpClientUtil h;
        try {
            h = new HttpClientUtil();
            h.open("http://news.baidu.com:81", "get");
            h.send();
            c = h.getResponseBodyAsString("UTF-8");
            h.close();
            log.info((Object)c);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        h = new HttpClientUtil();
        h.open("http://news.baidu.com", "get");
        h.send();
        c = h.getResponseBodyAsString("UTF-8");
        h.close();
        log.info((Object)c);
    }
}

