/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class FlipPageInfo
extends FlipInfo {
    private HttpServletRequest request;
    private String paramStr;
    private String firstPageLink;
    private String lastPageLink;
    private String previousPageLink;
    private String nextPageLink;
    private String paraPageLink;

    public FlipPageInfo(HttpServletRequest request) {
        this(request, request == null ? null : FlipPageInfo.convertMap(request.getParameterMap()));
    }

    public FlipPageInfo(HttpServletRequest request, Map params) {
        this.request = request;
        HashMap ps = new HashMap();
        this.setParams(ps);
        if (params != null) {
            ps.putAll(params);
            for (String key : params.keySet()) {
                Object val = params.get(key);
                if (val == null) continue;
                if (val instanceof String) {
                    String str = (String)val;
                    str = StringUtil.replace(str, "\\", "\\\\");
                    str = StringUtil.replace(str, "\n", "\\n");
                    str = StringUtil.replace(str, "\r", "\\r");
                    str = StringUtil.replace(str, "</script>", "<//script>");
                    val = str;
                }
                ps.put(key, val);
            }
        }
        this.firstPageLink = "#";
        this.lastPageLink = "#";
        this.previousPageLink = "#";
        this.nextPageLink = "#";
        if (request != null) {
            this.init(ps);
        }
    }

    public FlipPageInfo(int page, int size) {
        super(page, size);
    }

    private static Map convertMap(Map params) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String pName : params.keySet()) {
            Object valueObj = params.get(pName);
            if (valueObj == null) continue;
            String pValue = "";
            if (valueObj.getClass().isArray()) {
                String[] varray = (String[])valueObj;
                if (varray.length <= 0) continue;
                pValue = varray[0];
            } else {
                pValue = valueObj.toString();
            }
            result.put(pName, pValue);
        }
        return result;
    }

    private void init(Map params) {
        String jsonStr;
        try {
            super.setSize(Integer.valueOf(this.request.getParameter("size")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String pagePara = this.request.getParameter("page");
        if (pagePara != null) {
            try {
                super.setPage(Integer.valueOf(pagePara));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setSortField(this.request.getParameter("sortField"));
        this.setSortOrder(this.request.getParameter("sortOrder"));
        if (!params.containsKey("_json_params") && (jsonStr = this.request.getParameter("_json_params")) != null && !"".equals(jsonStr)) {
            params.put("_json_params", jsonStr);
        }
        StringBuilder paramsb = new StringBuilder();
        for (String pName : params.keySet()) {
            Object valueObj = params.get(pName);
            if (valueObj == null) continue;
            String pValue = "";
            if (valueObj.getClass().isArray()) {
                String[] varray = (String[])valueObj;
                if (varray.length <= 0) continue;
                for (int i = 0; i < varray.length; ++i) {
                    pValue = varray[i];
                    if ("page".equals(pName)) continue;
                    paramsb.append(pName);
                    paramsb.append("=");
                    try {
                        paramsb.append(URLEncoder.encode(pValue, "GBK"));
                    }
                    catch (UnsupportedEncodingException e) {
                        paramsb.append(pValue);
                    }
                    paramsb.append("&");
                }
                pName = "page";
            } else {
                pValue = valueObj.toString();
            }
            if ("page".equals(pName)) continue;
            paramsb.append(pName);
            paramsb.append("=");
            try {
                paramsb.append(URLEncoder.encode(pValue, "GBK"));
            }
            catch (UnsupportedEncodingException e) {
                paramsb.append(pValue);
            }
            paramsb.append("&");
        }
        this.paramStr = paramsb.toString();
        this.paraPageLink = this.request.getRequestURI() + "?" + this.paramStr;
    }

    private void initLinks() {
        String uri = this.request.getRequestURI();
        int pagei = this.getPage();
        int pages = this.getPages();
        if (pagei > 1) {
            this.firstPageLink = uri + "?" + this.paramStr + "page=1";
            this.previousPageLink = uri + "?" + this.paramStr.toString() + "page=" + (pagei - 1);
        }
        if (pagei < pages) {
            this.nextPageLink = uri + "?" + this.paramStr.toString() + "page=" + (pagei + 1);
            this.lastPageLink = uri + "?" + this.paramStr.toString() + "page=" + pages;
        }
    }

    @Override
    public void setData(List data) {
        super.setData(data);
        if (this.request != null) {
            this.initLinks();
        }
    }

    public String getFirstPageLink() {
        return this.firstPageLink;
    }

    public String getLastPageLink() {
        return this.lastPageLink;
    }

    public String getPreviousPageLink() {
        return this.previousPageLink;
    }

    public String getNextPageLink() {
        return this.nextPageLink;
    }

    public String getParaPageLink() {
        return this.paraPageLink;
    }

    public void initByFlipInfo(FlipInfo fi) {
        super.setPage(fi.getPage());
        super.setSize(fi.getSize());
        super.setTotal(fi.getTotal());
        super.setData(fi.getData());
        super.setNeedTotal(fi.isNeedTotal());
    }
}

