/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.mozilla.universalchardet.UniversalDetector;

public class FileUtil {
    private static Log logger = CtpLogFactory.getLog(FileUtil.class);
    private static MimetypesFileTypeMap typeMap = new MimetypesFileTypeMap();

    public static String detectEncoding(String fileName) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            String string = FileUtil.detectEncoding(fis);
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static String detectEncoding(InputStream fis) throws IOException {
        int nread;
        byte[] buf = new byte[4096];
        UniversalDetector detector = new UniversalDetector(null);
        while ((nread = fis.read(buf)) > 0 && !detector.isDone()) {
            detector.handleData(buf, 0, nread);
        }
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        if (encoding != null) {
            logger.debug((Object)("Detected encoding = " + encoding));
        } else {
            logger.debug((Object)"No encoding detected.");
        }
        detector.reset();
        return encoding;
    }

    public static String getDownloadFileName(HttpServletRequest request, String filename) {
        String new_filename = null;
        if (filename == null) {
            return null;
        }
        try {
            new_filename = URLEncoder.encode(filename, "UTF-8").replace("%C2%A0", "%20").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e1) {
            logger.warn((Object)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301UTF-8\u7f16\u7801\u8f6c\u6362\uff1a", (Throwable)e1);
        }
        String userAgent = request.getHeader("User-Agent");
        String rtn = "filename=\"" + new_filename + "\"";
        if (userAgent != null) {
            boolean isIe;
            boolean bl = isIe = (userAgent = userAgent.toLowerCase()).indexOf("msie") != -1;
            boolean bl2 = !isIe ? userAgent.indexOf("edge/") != -1 : (isIe = isIe);
            if (isIe) {
                boolean isExcel = filename.endsWith("xls") || filename.endsWith("xlsx");
                boolean isIe7 = userAgent.contains("msie 7");
                if (isIe7 || isExcel && new_filename != null && new_filename.length() > 130) {
                    try {
                        new_filename = new String(filename.getBytes("GBK"), "ISO8859-1");
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.warn((Object)("\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301UTF-8\u7f16\u7801\u8f6c\u6362\uff1a" + e.getLocalizedMessage()), (Throwable)e);
                    }
                }
                if (filename.indexOf(".") < 0 && new_filename != null) {
                    new_filename = new_filename.replace("%20", " ");
                }
                rtn = "filename=\"" + new_filename + "\"";
            } else if (userAgent.indexOf("opera") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            } else if (userAgent.indexOf("safari") != -1) {
                try {
                    rtn = "filename=\"" + new String(filename.getBytes("UTF-8"), "ISO8859-1") + "\"";
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn((Object)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301UTF-8\u7f16\u7801\u8f6c\u6362\uff1a", (Throwable)e);
                }
            } else if (userAgent.indexOf("micromessenger") != -1) {
                try {
                    rtn = "filename=\"" + new String(filename.getBytes("UTF-8"), "ISO8859-1") + "\"";
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn((Object)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301UTF-8\u7f16\u7801\u8f6c\u6362\uff1a", (Throwable)e);
                }
            } else if (userAgent.indexOf("dingtalk") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            } else if (userAgent.indexOf("applewebkit") != -1) {
                try {
                    new_filename = MimeUtility.encodeText((String)filename, (String)"UTF8", (String)"B");
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn((Object)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301UTF-8\u7f16\u7801\u8f6c\u6362\uff1a", (Throwable)e);
                }
                rtn = "filename=\"" + new_filename + "\"";
            } else if (userAgent.indexOf("mozilla") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            }
        }
        return rtn;
    }

    public static String getMimeType(String fileName) {
        return typeMap.getContentType(fileName.toLowerCase());
    }

    public static boolean deleteFile(File f) {
        if (!f.exists()) {
            return true;
        }
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteFile(children[i]);
                if (success) continue;
                return false;
            }
        }
        return f.delete();
    }

    public static boolean clearFolder(File f) {
        if (!f.exists()) {
            return true;
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("The the param is a not directory.");
        }
        File[] children = f.listFiles();
        if (children != null) {
            for (File child : children) {
                boolean ret = FileUtil.deleteFile(child);
                if (ret) continue;
                return ret;
            }
        }
        return true;
    }

    public static String getSuffix(String fileName) {
        String ret = fileName;
        int last = fileName.lastIndexOf(".");
        if (last != -1) {
            ret = fileName.substring(last + 1, fileName.length());
        }
        return ret;
    }

    public static String getFileNameWithoutSuffix(String fileName) {
        String ret = fileName;
        int last = fileName.lastIndexOf(".");
        if (last != -1) {
            ret = fileName.substring(0, last);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File des) {
        boolean ret = false;
        InputStream inStream = null;
        FileOutputStream fs = null;
        if (src.getAbsolutePath().equals(des.getAbsolutePath())) {
            return false;
        }
        try {
            File toPath = new File(des.getParent());
            if (!toPath.exists()) {
                toPath.mkdirs();
            }
            inStream = new FileInputStream(src);
            fs = new FileOutputStream(des);
            byte[] buffer = new byte[1444];
            int byteread = 0;
            while ((byteread = inStream.read(buffer)) != -1) {
                fs.write(buffer, 0, byteread);
            }
            fs.flush();
            ret = true;
        }
        catch (Exception e) {
            logger.error((Object)("\u62f7\u8d1d\u6587\u4ef6\u62a5\u9519:src=" + src.getAbsolutePath() + ", des=" + des.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFileAndAddContent(File src, File des, String content) {
        boolean ret = false;
        BufferedReader reader = null;
        BufferedWriter out = null;
        if (src.getAbsolutePath().equals(des.getAbsolutePath())) {
            return false;
        }
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(src), "UTF-8"));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(des), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                out.write(line);
                out.newLine();
            }
            out.write(content);
            out.flush();
            ret = true;
        }
        catch (Exception e) {
            logger.error((Object)("\u62f7\u8d1d\u6587\u4ef6\u62a5\u9519:src=" + src.getAbsolutePath() + ", des=" + des.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addContent(File des, String content) {
        boolean ret = false;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(des, true), "UTF-8"));
            out.write(content);
            out.flush();
            ret = true;
        }
        catch (Exception e) {
            logger.error((Object)("\u5411\u6587\u4ef6\u8ffd\u52a0\u5185\u5bb9\u5931\u8d25, path=" + des.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    public static boolean makeDir(String path) {
        File file;
        boolean ret = false;
        if (path != null && !(file = new File(path)).exists()) {
            ret = file.mkdir();
        }
        return ret;
    }

    public static boolean inDirectory(File file, File directory) {
        if (file == null || directory == null) {
            return false;
        }
        try {
            return file.getCanonicalPath().startsWith(directory.getCanonicalPath() + File.separator);
        }
        catch (IOException e) {
            logger.error((Object)(e.getLocalizedMessage() + file.getPath() + " " + directory.getPath()), (Throwable)e);
            return false;
        }
    }
}

