/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CachePojo<T> {
    private List<T> cacheList = new ArrayList<T>();
    private Map<String, Method> classMetadata = new HashMap<String, Method>();
    private Map<String, Index> indexMap = new HashMap<String, Index>();
    private Class<T> cls = null;

    public CachePojo(Class<T> cls) {
        Field[] f = cls.getDeclaredFields();
        for (int i = 0; i < f.length; ++i) {
            String field = f[i].getName();
            Method m = this.findGetMethod(field, cls);
            this.classMetadata.put(field, m);
        }
        this.cls = cls;
    }

    public List<T> getAll() {
        return this.cacheList;
    }

    public void clear() {
        this.cacheList.clear();
        for (String key : this.indexMap.keySet()) {
            Index index = this.indexMap.get(key);
            index.clear();
        }
    }

    public void createIndex(String[] pojoFieldName) {
        if (pojoFieldName != null) {
            for (int i = 0; i < pojoFieldName.length; ++i) {
                Method m = this.classMetadata.get(pojoFieldName[i]);
                if (m == null) {
                    throw new RuntimeException(pojoFieldName[i] + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684getter\u65b9\u6cd5");
                }
                Index index = new Index();
                this.indexMap.put(pojoFieldName[i], index);
            }
        }
    }

    public void createIndexNoMethod(String[] pojoFieldName) {
        if (pojoFieldName != null) {
            for (int i = 0; i < pojoFieldName.length; ++i) {
                Index index = new Index();
                this.indexMap.put(pojoFieldName[i], index);
            }
        }
    }

    public void createAllIndex() {
        Field[] pojoFieldNames = this.cls.getDeclaredFields();
        for (int i = 0; i < pojoFieldNames.length; ++i) {
            String pojoFieldName = pojoFieldNames[i].getName();
            Method m = this.classMetadata.get(pojoFieldName);
            if (m == null) {
                throw new RuntimeException(this.cls.getName() + ":" + pojoFieldName + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684getter\u65b9\u6cd5");
            }
            Index index = new Index();
            this.indexMap.put(pojoFieldName, index);
        }
    }

    public List<T> get(String indexName, Object value) {
        int[] index = this.find(indexName, value);
        if (index == null) {
            return null;
        }
        int length = index.length;
        ArrayList<T> list = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.cacheList.get(index[i]));
        }
        return list;
    }

    public List<T> get(String[] indexNames, Object[] values) {
        int[] index = this.find(indexNames, values);
        if (index == null) {
            return null;
        }
        int length = index.length;
        ArrayList<T> list = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.cacheList.get(index[i]));
        }
        return list;
    }

    public List<T> getNotEqual(String indexNames, Object values) {
        int[] index = this.findNotEqual(indexNames, values);
        if (index == null) {
            return null;
        }
        int length = index.length;
        ArrayList<T> list = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.cacheList.get(index[i]));
        }
        return list;
    }

    public List<T> getNotEqual(String[] indexNames, Object[] values) {
        int[] index = this.findNotEqual(indexNames, values);
        if (index == null) {
            return null;
        }
        int length = index.length;
        ArrayList<T> list = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.cacheList.get(index[i]));
        }
        return list;
    }

    public T getUnique(String[] indexNames, Object[] values) {
        List<T> list = this.get(indexNames, values);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public T getUnique(String indexName, Object value) {
        List<T> list = this.get(indexName, value);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public void add(T t) {
        if (t == null) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        if (this.indexMap.size() == 0) {
            this.createAllIndex();
        }
        this.cacheList.add(t);
        int indexNumber = this.cacheList.size() - 1;
        for (String key : this.indexMap.keySet()) {
            Index index = this.indexMap.get(key);
            Method method = this.classMetadata.get(key);
            Object value = this.getMethodValue(method, t);
            index.put(value, indexNumber);
        }
    }

    private int[] find(String[] indexNames, Object[] values) {
        if (indexNames.length != values.length) {
            throw new RuntimeException("indexNames.length!=values.length");
        }
        Index index = this.indexMap.get(indexNames[0]);
        int[] r = index.get(values[0]);
        if (r == null) {
            return null;
        }
        for (int i = 1; i < indexNames.length; ++i) {
            if (r == null) {
                return null;
            }
            index = this.indexMap.get(indexNames[i]);
            int[] s = index.get(values[i]);
            if (s == null) {
                return null;
            }
            r = this.include(r, s);
        }
        return r;
    }

    private int[] include(int[] a, int[] b) {
        int[] min = null;
        int[] max = null;
        if (a.length > b.length) {
            min = b;
            max = a;
        } else {
            min = a;
            max = b;
        }
        int[] r = new int[min.length];
        Arrays.sort(max);
        int length = 0;
        for (int i = 0; i < min.length; ++i) {
            int index = Arrays.binarySearch(max, min[i]);
            if (index < 0) continue;
            r[length] = max[index];
            ++length;
        }
        if (length == 0) {
            return null;
        }
        int[] re = new int[length];
        System.arraycopy(r, 0, re, 0, length);
        return re;
    }

    private int[] findNotEqual(String[] indexNames, Object[] values) {
        if (indexNames.length != values.length) {
            throw new RuntimeException("indexNames.length!=values.length");
        }
        Index index = this.indexMap.get(indexNames[0]);
        int[] r = index.getNotEqual(values[0]);
        if (r == null) {
            return null;
        }
        for (int i = 1; i < indexNames.length; ++i) {
            if (r == null) {
                return null;
            }
            index = this.indexMap.get(indexNames[i]);
            int[] s = index.getNotEqual(values[i]);
            if (s == null) {
                return null;
            }
            r = this.include(r, s);
        }
        return r;
    }

    private int[] findNotEqual(String indexName, Object value) {
        Index index = this.indexMap.get(indexName);
        int[] r = index.getNotEqual(value);
        return r;
    }

    private int[] find(String indexName, Object value) {
        Index index = this.indexMap.get(indexName);
        return index.get(value);
    }

    private Object getMethodValue(Method method, Object obj) {
        Object temp = null;
        try {
            temp = method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return temp;
    }

    private Method findGetMethod(String filed, Class<T> cls) {
        Method[] method = cls.getMethods();
        Method returnMethod = null;
        for (int i = 0; i < method.length; ++i) {
            if (!("get" + filed).toUpperCase().equals(method[i].getName().toUpperCase())) continue;
            returnMethod = method[i];
        }
        return returnMethod;
    }

    private class Index {
        private Map<Object, int[]> indexMap = new HashMap<Object, int[]>();
        private Object NULL = new Object();

        public void put(Object t, int value, int increase) {
            t = t == null ? this.NULL : t;
            int[] old = this.indexMap.get(t);
            int n = increase = increase == 0 || increase < 0 ? 10 : increase;
            if (old == null) {
                old = new int[11];
                old[0] = 1;
                old[1] = value;
            } else if (old[0] == old.length - 1) {
                old = this.increase(old, increase);
                old[0] = old[0] + 1;
                old[old[0]] = value;
            } else {
                old[0] = old[0] + 1;
                old[old[0]] = value;
            }
            this.indexMap.put(t, old);
        }

        public void clear() {
            this.indexMap.clear();
        }

        public void put(Object t, int value) {
            this.put(t, value, 10);
        }

        public int[] get(Object key) {
            int[] data = this.indexMap.get(key = key == null ? this.NULL : key);
            if (data == null) {
                return null;
            }
            int[] r = new int[data[0]];
            System.arraycopy(data, 1, r, 0, data[0]);
            return r;
        }

        public int[] getNotEqual(Object key) {
            key = key == null ? this.NULL : key;
            Set<Object> set = this.indexMap.keySet();
            Iterator<Object> setI = set.iterator();
            int[] r = null;
            while (setI.hasNext()) {
                Object temp = setI.next();
                if ((key == null || key.equals(temp)) && (key != null || temp == null)) continue;
                int[] value = this.get(temp);
                if (r == null) {
                    r = value;
                    continue;
                }
                int rLen = r.length;
                int vLen = 0;
                if (value != null) {
                    vLen = value.length;
                }
                int[] t = new int[rLen + vLen];
                System.arraycopy(r, 0, t, 0, rLen);
                System.arraycopy(value, 0, t, rLen, vLen);
                r = t;
            }
            return r;
        }

        private int[] increase(int[] in, int arg0) {
            int[] r = new int[in.length + arg0];
            System.arraycopy(in, 0, r, 0, in.length);
            return r;
        }

        public String toString() {
            return this.indexMap.toString();
        }
    }
}

