/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class BooleanBinder
extends PropertyEditorSupport {
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_ON = "on";
    public static final String VALUE_OFF = "off";
    public static final String VALUE_YES = "yes";
    public static final String VALUE_NO = "no";
    public static final String VALUE_1 = "1";
    public static final String VALUE_0 = "0";
    private final String trueString;
    private final String falseString;
    private final boolean allowEmpty;

    public BooleanBinder(boolean allowEmpty) {
        this(null, null, allowEmpty);
    }

    public BooleanBinder(String trueString, String falseString, boolean allowEmpty) {
        this.trueString = trueString;
        this.falseString = falseString;
        this.allowEmpty = allowEmpty;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!this.allowEmpty || StringUtils.hasText((String)text)) {
            if (this.trueString != null && text.equalsIgnoreCase(this.trueString)) {
                this.setValue(Boolean.TRUE);
            } else if (this.falseString != null && text.equalsIgnoreCase(this.falseString)) {
                this.setValue(Boolean.FALSE);
            } else if (this.trueString == null && (text.equalsIgnoreCase(VALUE_TRUE) || text.equalsIgnoreCase(VALUE_ON) || text.equalsIgnoreCase(VALUE_YES) || text.equals(VALUE_1))) {
                this.setValue(Boolean.TRUE);
            } else if (this.falseString == null && (text.equalsIgnoreCase(VALUE_FALSE) || text.equalsIgnoreCase(VALUE_OFF) || text.equalsIgnoreCase(VALUE_NO) || text.equals(VALUE_0))) {
                this.setValue(Boolean.FALSE);
            } else {
                throw new IllegalArgumentException("Invalid boolean value [" + text + "]");
            }
        }
    }

    @Override
    public String getAsText() {
        if (Boolean.TRUE.equals(this.getValue())) {
            return this.trueString != null ? this.trueString : VALUE_TRUE;
        }
        if (Boolean.FALSE.equals(this.getValue())) {
            return this.falseString != null ? this.falseString : VALUE_FALSE;
        }
        return "";
    }
}

