/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread.trace;

import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.thread.ThreadValue;
import com.seeyon.ctp.thread.trace.DaoRuntimeData;

public class RuntimeData {
    private String threadId = null;
    private String actionCode = null;
    private String flowNo = null;
    private String traceInfo = null;
    private long beginTime;
    private long endTime;
    private Object processObject = null;
    private boolean isLogDuplicateSQL = false;
    private DaoRuntimeData daoRuntimeData = null;
    private boolean isEventThread = false;

    public RuntimeData(String traceInfo) {
        this.init(traceInfo, "N/A");
    }

    public RuntimeData(String traceInfo, String actionCode) {
        this.init(traceInfo, actionCode);
    }

    private void init(String traceInfo, String actionCode) {
        this.traceInfo = traceInfo;
        this.actionCode = actionCode;
        this.threadId = ThreadValue.getThreadId();
        this.flowNo = ThreadValue.getFlowNo();
        String isLogDuplicateSQL = SystemProperties.getInstance().getProperty("monitor.dao.duplicateSql");
        boolean bl = this.isLogDuplicateSQL = isLogDuplicateSQL != null && isLogDuplicateSQL.compareTo("true") == 0;
        if (this.isLogDuplicateSQL) {
            this.daoRuntimeData = new DaoRuntimeData();
        }
    }

    public void release(String traceInfo) {
        this.traceInfo = traceInfo;
        this.actionCode = null;
        this.threadId = null;
        this.flowNo = null;
        this.isLogDuplicateSQL = false;
        this.daoRuntimeData = null;
    }

    public String getActionCode() {
        return this.actionCode;
    }

    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public String getFlowNo() {
        return this.flowNo;
    }

    public void setFlowNo(String flowNo) {
        this.flowNo = flowNo;
    }

    public String getTraceInfo() {
        return this.traceInfo;
    }

    public void setTraceInfo(String traceInfo) {
        this.traceInfo = traceInfo;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public Object getProcessObject() {
        return this.processObject;
    }

    public void setProcessObject(Object processObject) {
        this.processObject = processObject;
    }

    public boolean isLogDuplicateSQL() {
        return this.isLogDuplicateSQL;
    }

    public void setLogDuplicateSQL(boolean isLogDuplicateSQL) {
        this.isLogDuplicateSQL = isLogDuplicateSQL;
    }

    public DaoRuntimeData getDaoRuntimeData() {
        return this.daoRuntimeData;
    }

    public void setDaoRuntimeData(DaoRuntimeData daoRuntimeData) {
        this.daoRuntimeData = daoRuntimeData;
    }

    public void addDaoTaskInfo(String daoTaskInfo) {
        if (!this.isLogDuplicateSQL) {
            return;
        }
        if (this.daoRuntimeData != null) {
            this.daoRuntimeData.addTask(daoTaskInfo);
        }
    }

    public boolean isEventThread() {
        return this.isEventThread;
    }

    public void setEventThread(boolean isEventThread) {
        this.isEventThread = isEventThread;
    }
}

