/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread.trace;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.monitor.DuplicateSqlMonitorBuffer;
import com.seeyon.ctp.common.monitor.MonitorBuffer;
import com.seeyon.ctp.common.monitor.MonitorBufferPool;
import com.seeyon.ctp.thread.ThreadUtil;
import com.seeyon.ctp.thread.monitor.ThreadMonitor;
import com.seeyon.ctp.thread.trace.RuntimeData;
import com.seeyon.ctp.thread.trace.RuntimeTaskData;
import com.seeyon.ctp.util.array.LoopArray;
import org.apache.commons.logging.Log;

public class DaoRuntimeData {
    protected static int _checkContinueNum = 2;
    private static final Log LOGGER = CtpLogFactory.getLog("monitor.sql");
    protected RuntimeTaskData[] tackCache = new RuntimeTaskData[128];
    protected LoopArray<RuntimeTaskData> tasks = new LoopArray<RuntimeTaskData>(this.tackCache);
    protected LoopArray<RuntimeTaskData> illegalTask = new LoopArray<RuntimeTaskData>(this.tackCache);

    public void addTask(String sql) {
        if (sql == null || sql.length() == 0) {
            return;
        }
        RuntimeTaskData task = new RuntimeTaskData("dao", null, sql);
        this.validateTask(task);
        this.tasks.add(task);
    }

    public void validateTask(RuntimeTaskData task) {
        RuntimeTaskData[] lasts = this.tasks.getLast(_checkContinueNum);
        if (lasts != null && lasts.length == _checkContinueNum) {
            MonitorBuffer buf;
            int pos;
            String s1 = lasts[_checkContinueNum - 1].getTaskInfo();
            String s2 = task.getTaskInfo();
            if (s1.length() == s2.length() && s1.compareTo(s2) == 0 && (pos = (buf = MonitorBufferPool.getInstance().getMonitorBuffer(DuplicateSqlMonitorBuffer.BufferType_DuplicateSQL)).addBuffer(ThreadMonitor.getData().getActionCode(), s2, ThreadUtil.getSQLTraceInfo())) > 0) {
                task.setTraceInfo(ThreadUtil.getSQLTraceInfo());
                this.illegalTask.add(task);
            }
        }
    }

    public void printTasklist() {
        RuntimeData data = ThreadMonitor.getData();
        RuntimeTaskData[] list = this.illegalTask.getArray();
        if (list == null || list.length == 0) {
            return;
        }
        LOGGER.info((Object)("\n\u8bf7\u6c42[" + data.getActionCode() + "] \u91cd\u590dSQL\u4fe1\u606f:------------"));
        for (RuntimeTaskData d : list) {
            LOGGER.info((Object)d.getTaskInfo());
            if (d.getTraceInfo() == null) continue;
            LOGGER.info((Object)"----SQL\u91cd\u590d\uff0c\u5806\u6808\u4fe1\u606f\uff1a");
            LOGGER.info((Object)d.getTraceInfo());
        }
    }
}

